/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigquery;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntFunction;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.text.translate.JavaUnicodeEscaper;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.text.translate.LookupTranslator;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BeamBigQuerySqlDialect;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.avatica.util.ByteString;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rel.rel2sql.RelToSqlConverter;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rex.RexDynamicParam;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rex.RexLocalRef;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rex.RexProgram;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlDynamicParam;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlLiteral;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.util.BitString;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.util.TimestampString;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class BeamSqlUnparseContext
extends SqlImplementor.SimpleContext {
    private final @UnknownKeyFor @NonNull @Initialized SqlImplementor imp = new RelToSqlConverter(BeamBigQuerySqlDialect.DEFAULT);
    private static final @UnknownKeyFor @NonNull @Initialized CharSequenceTranslator ESCAPE_FOR_ZETA_SQL = new LookupTranslator((CharSequence[][])new String[][]{{"\"", "\\\""}, {"\\", "\\\\"}}).with(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])EntityArrays.JAVA_CTRL_CHARS_ESCAPE())}).with(new CharSequenceTranslator[]{JavaUnicodeEscaper.outsideOf((int)32, (int)127)});
    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized RelDataType> nullParams = new HashMap<String, RelDataType>();

    public @UnknownKeyFor @NonNull @Initialized SqlImplementor implementor() {
        return this.imp;
    }

    public BeamSqlUnparseContext(@UnknownKeyFor @NonNull @Initialized IntFunction<@UnknownKeyFor @NonNull @Initialized SqlNode> field) {
        super(BeamBigQuerySqlDialect.DEFAULT, field);
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized RelDataType> getNullParams() {
        return this.nullParams;
    }

    public @UnknownKeyFor @NonNull @Initialized SqlNode toSql(@UnknownKeyFor @NonNull @Initialized RexProgram program, @UnknownKeyFor @NonNull @Initialized RexNode rex) {
        if (rex.getKind().equals((Object)SqlKind.LITERAL)) {
            RexLiteral literal = (RexLiteral)rex;
            SqlTypeName name = literal.getTypeName();
            SqlTypeFamily family = name.getFamily();
            if (SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals((Object)name)) {
                TimestampString timestampString = (TimestampString)literal.getValueAs(TimestampString.class);
                return new SqlDateTimeLiteral(timestampString, SqlImplementor.POS);
            }
            if (SqlTypeFamily.BINARY.equals((Object)family)) {
                ByteString byteString = (ByteString)literal.getValueAs(ByteString.class);
                BitString bitString = BitString.createFromHexString((String)byteString.toString(16));
                return new SqlByteStringLiteral(bitString, SqlImplementor.POS);
            }
            if (SqlTypeFamily.CHARACTER.equals((Object)family)) {
                String escaped = ESCAPE_FOR_ZETA_SQL.translate((CharSequence)literal.getValueAs(String.class));
                return SqlLiteral.createCharString((String)escaped, (SqlParserPos)SqlImplementor.POS);
            }
            if (SqlTypeName.SYMBOL.equals((Object)literal.getTypeName())) {
                Enum symbol = (Enum)literal.getValueAs(Enum.class);
                if (TimeUnitRange.DOW.equals((Object)symbol)) {
                    return new ReplaceLiteral(literal, SqlImplementor.POS, "DAYOFWEEK");
                }
                if (TimeUnitRange.DOY.equals((Object)symbol)) {
                    return new ReplaceLiteral(literal, SqlImplementor.POS, "DAYOFYEAR");
                }
                if (TimeUnitRange.WEEK.equals((Object)symbol)) {
                    return new ReplaceLiteral(literal, SqlImplementor.POS, "ISOWEEK");
                }
            }
        } else {
            if (rex.getKind().equals((Object)SqlKind.DYNAMIC_PARAM)) {
                RexDynamicParam param = (RexDynamicParam)rex;
                int index = param.getIndex();
                String name = "null_param_" + index;
                this.nullParams.put(name, param.getType());
                return new NamedDynamicParam(index, SqlImplementor.POS, name);
            }
            if (SqlKind.SEARCH.equals((Object)rex.getKind())) {
                RexCall search = (RexCall)rex;
                if (search.operands.get(1) instanceof RexLocalRef) {
                    RexLocalRef ref = (RexLocalRef)search.operands.get(1);
                    RexLiteral literal = (RexLiteral)program.getExprList().get(ref.getIndex());
                    rex = search.clone(search.getType(), (List)ImmutableList.of((Object)((RexNode)search.operands.get(0)), (Object)literal));
                }
            }
        }
        return super.toSql(program, rex);
    }

    private static class NamedDynamicParam
    extends SqlDynamicParam {
        private final @UnknownKeyFor @NonNull @Initialized String newName;

        NamedDynamicParam(@UnknownKeyFor @NonNull @Initialized int index, @UnknownKeyFor @NonNull @Initialized SqlParserPos pos, @UnknownKeyFor @NonNull @Initialized String newName) {
            super(index, pos);
            this.newName = newName;
        }

        public void unparse(@UnknownKeyFor @NonNull @Initialized SqlWriter writer, @UnknownKeyFor @NonNull @Initialized int leftPrec, @UnknownKeyFor @NonNull @Initialized int rightPrec) {
            writer.literal("@" + this.newName);
        }
    }

    private static class ReplaceLiteral
    extends SqlLiteral {
        private final @UnknownKeyFor @NonNull @Initialized String newValue;

        ReplaceLiteral(@UnknownKeyFor @NonNull @Initialized RexLiteral literal, @UnknownKeyFor @NonNull @Initialized SqlParserPos pos, @UnknownKeyFor @NonNull @Initialized String newValue) {
            super((Object)literal.getValue(), literal.getTypeName(), pos);
            this.newValue = newValue;
        }

        public void unparse(@UnknownKeyFor @NonNull @Initialized SqlWriter writer, @UnknownKeyFor @NonNull @Initialized int leftPrec, @UnknownKeyFor @NonNull @Initialized int rightPrec) {
            writer.literal(this.newValue);
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
            if (!(obj instanceof ReplaceLiteral)) {
                return false;
            }
            if (!this.newValue.equals(((ReplaceLiteral)((Object)obj)).newValue)) {
                return false;
            }
            return super.equals(obj);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return super.hashCode();
        }
    }

    private static class SqlByteStringLiteral
    extends SqlLiteral {
        SqlByteStringLiteral(@UnknownKeyFor @NonNull @Initialized BitString bytes, @UnknownKeyFor @NonNull @Initialized SqlParserPos pos) {
            super((Object)bytes, SqlTypeName.BINARY, pos);
        }

        public @UnknownKeyFor @NonNull @Initialized SqlByteStringLiteral clone(@UnknownKeyFor @NonNull @Initialized SqlParserPos pos) {
            return new SqlByteStringLiteral((BitString)this.value, pos);
        }

        public void unparse(@UnknownKeyFor @NonNull @Initialized SqlWriter writer, @UnknownKeyFor @NonNull @Initialized int leftPrec, @UnknownKeyFor @NonNull @Initialized int rightPrec) {
            assert (this.value instanceof BitString);
            StringBuilder builder = new StringBuilder("B'");
            for (byte b : ((BitString)this.value).getAsByteArray()) {
                builder.append(String.format("\\x%02X", b));
            }
            builder.append("'");
            writer.literal(builder.toString());
        }
    }

    private static class SqlDateTimeLiteral
    extends SqlLiteral {
        private final @UnknownKeyFor @NonNull @Initialized TimestampString timestampString;

        SqlDateTimeLiteral(@UnknownKeyFor @NonNull @Initialized TimestampString timestampString, @UnknownKeyFor @NonNull @Initialized SqlParserPos pos) {
            super((Object)timestampString, SqlTypeName.TIMESTAMP, pos);
            this.timestampString = timestampString;
        }

        public void unparse(@UnknownKeyFor @NonNull @Initialized SqlWriter writer, @UnknownKeyFor @NonNull @Initialized int leftPrec, @UnknownKeyFor @NonNull @Initialized int rightPrec) {
            writer.literal("DATETIME '" + this.timestampString.toString() + "'");
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@UnknownKeyFor @NonNull @Initialized Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SqlDateTimeLiteral that = (SqlDateTimeLiteral)((Object)o);
            return Objects.equals(this.timestampString, that.timestampString);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(super.hashCode(), this.timestampString);
        }
    }
}

