/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.catalog;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.meta.catalog.Catalog;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.store.InMemoryMetaStore;
import org.apache.beam.sdk.extensions.sql.meta.store.MetaStore;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class InMemoryCatalog
implements Catalog {
    private final @UnknownKeyFor @NonNull @Initialized String name;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> properties;
    protected final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableProvider> tableProviders = new HashMap<String, TableProvider>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized MetaStore> metaStores = new HashMap<String, MetaStore>();
    private final @UnknownKeyFor @NonNull @Initialized HashSet<@UnknownKeyFor @NonNull @Initialized String> databases = new HashSet<String>(Collections.singleton("default"));
    protected @Nullable @UnknownKeyFor @Initialized String currentDatabase = "default";

    public InMemoryCatalog(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> properties) {
        this(name, new InMemoryMetaStore(), properties);
    }

    public InMemoryCatalog(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized MetaStore defaultMetastore, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> properties) {
        this.name = name;
        this.properties = properties;
        this.metaStores.put("default", defaultMetastore);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String type() {
        return "local";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String name() {
        return (String)Preconditions.checkStateNotNull((Object)this.name, (Object)(this.getClass().getSimpleName() + " has not been initialized"));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized MetaStore metaStore(@UnknownKeyFor @NonNull @Initialized String db) {
        @Nullable MetaStore metaStore = this.metaStores.get(db);
        if (metaStore == null) {
            metaStore = new InMemoryMetaStore();
            this.tableProviders.values().forEach(metaStore::registerProvider);
            this.metaStores.put(db, metaStore);
        }
        return metaStore;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> properties() {
        return (Map)Preconditions.checkStateNotNull(this.properties, (Object)"InMemoryCatalog has not been initialized");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean createDatabase(@UnknownKeyFor @NonNull @Initialized String database) {
        return this.databases.add(database);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean databaseExists(@UnknownKeyFor @NonNull @Initialized String db) {
        return this.databases.contains(db);
    }

    @Override
    public void useDatabase(@UnknownKeyFor @NonNull @Initialized String database) {
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)this.databaseExists(database), (Object)"Database '%s' does not exist.");
        this.currentDatabase = database;
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized String currentDatabase() {
        return this.currentDatabase;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> databases() {
        return this.databases;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean dropDatabase(@UnknownKeyFor @NonNull @Initialized String database, @UnknownKeyFor @NonNull @Initialized boolean cascade) {
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((!cascade ? 1 : 0) != 0, (String)"%s does not support CASCADE.", (Object)this.getClass().getSimpleName());
        boolean removed = this.databases.remove(database);
        if (database.equals(this.currentDatabase)) {
            this.currentDatabase = null;
        }
        return removed;
    }

    @Override
    public void registerTableProvider(@UnknownKeyFor @NonNull @Initialized TableProvider provider) {
        this.tableProviders.put(provider.getTableType(), provider);
        this.metaStores.values().forEach(m -> m.registerProvider(provider));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableProvider> tableProviders() {
        return this.tableProviders;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return MoreObjects.toStringHelper(InMemoryCatalog.class).add("name", (Object)this.name).add("currentDatabase", (Object)this.currentDatabase).add("databases", this.databases).toString();
    }
}

