/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.meta.BaseBeamTable;
import org.apache.beam.sdk.extensions.sql.meta.catalog.Catalog;
import org.apache.beam.sdk.extensions.sql.meta.catalog.CatalogManager;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SystemTables {
    public static @UnknownKeyFor @NonNull @Initialized CatalogsMetaTable catalogs(@UnknownKeyFor @NonNull @Initialized CatalogManager catalogManager, @UnknownKeyFor @NonNull @Initialized boolean currentOnly) {
        return new CatalogsMetaTable(catalogManager, currentOnly);
    }

    public static @UnknownKeyFor @NonNull @Initialized DatabasesMetaTable databases(@UnknownKeyFor @NonNull @Initialized Catalog catalog, @UnknownKeyFor @NonNull @Initialized boolean currentOnly) {
        return new DatabasesMetaTable(catalog, currentOnly);
    }

    public static @UnknownKeyFor @NonNull @Initialized TablesMetaTable tables(@UnknownKeyFor @NonNull @Initialized Catalog catalog, @UnknownKeyFor @NonNull @Initialized String dbName) {
        return new TablesMetaTable(catalog, dbName);
    }

    public static class TablesMetaTable
    extends BaseBeamTable {
        private final @UnknownKeyFor @NonNull @Initialized Catalog catalog;
        private final @UnknownKeyFor @NonNull @Initialized String dbName;
        private static final @UnknownKeyFor @NonNull @Initialized Schema SCHEMA = Schema.builder().addStringField("NAME").addStringField("TYPE").build();

        public TablesMetaTable(@UnknownKeyFor @NonNull @Initialized Catalog catalog, @UnknownKeyFor @NonNull @Initialized String dbName) {
            this.catalog = catalog;
            this.dbName = dbName;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> buildIOReader(@UnknownKeyFor @NonNull @Initialized PBegin begin) {
            List rows = this.catalog.metaStore(this.dbName).getTables().values().stream().map(table -> Row.withSchema((Schema)SCHEMA).addValues(new Object[]{table.getName(), table.getType()}).build()).collect(Collectors.toList());
            return (PCollection)begin.apply((PTransform)Create.of(rows).withRowSchema(SCHEMA));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized POutput buildIOWriter(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
            throw new UnsupportedOperationException("Cannot write to SHOW TABLES");
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded() {
            return PCollection.IsBounded.BOUNDED;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Schema getSchema() {
            return SCHEMA;
        }
    }

    public static class DatabasesMetaTable
    extends BaseBeamTable {
        private final @UnknownKeyFor @NonNull @Initialized Catalog catalog;
        private final @UnknownKeyFor @NonNull @Initialized boolean currentOnly;
        private static final @UnknownKeyFor @NonNull @Initialized Schema SCHEMA = Schema.builder().addStringField("NAME").build();

        DatabasesMetaTable(@UnknownKeyFor @NonNull @Initialized Catalog catalog, @UnknownKeyFor @NonNull @Initialized boolean currentOnly) {
            this.catalog = catalog;
            this.currentOnly = currentOnly;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> buildIOReader(@UnknownKeyFor @NonNull @Initialized PBegin begin) {
            String currentDb;
            Collection<String> databases = this.currentOnly ? ((currentDb = this.catalog.currentDatabase()) != null ? Collections.singleton(currentDb) : Collections.emptyList()) : this.catalog.databases();
            List rows = databases.stream().map(db -> Row.withSchema((Schema)SCHEMA).addValues(new Object[]{db}).build()).collect(Collectors.toList());
            return (PCollection)begin.apply((PTransform)Create.of(rows).withRowSchema(SCHEMA));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized POutput buildIOWriter(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
            throw new UnsupportedOperationException("Cannot write to SHOW DATABASES");
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded() {
            return PCollection.IsBounded.BOUNDED;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Schema getSchema() {
            return SCHEMA;
        }
    }

    public static class CatalogsMetaTable
    extends BaseBeamTable {
        private final @UnknownKeyFor @NonNull @Initialized CatalogManager catalogManager;
        private final @UnknownKeyFor @NonNull @Initialized boolean currentOnly;
        private static final @UnknownKeyFor @NonNull @Initialized Schema SCHEMA = Schema.builder().addStringField("NAME").addStringField("TYPE").build();

        public CatalogsMetaTable(@UnknownKeyFor @NonNull @Initialized CatalogManager catalogManager, @UnknownKeyFor @NonNull @Initialized boolean currentOnly) {
            this.catalogManager = catalogManager;
            this.currentOnly = currentOnly;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> buildIOReader(@UnknownKeyFor @NonNull @Initialized PBegin begin) {
            ImmutableList catalogs = this.currentOnly ? ImmutableList.of((Object)this.catalogManager.currentCatalog()) : this.catalogManager.catalogs();
            List rows = catalogs.stream().map(cat -> Row.withSchema((Schema)SCHEMA).addValues(new Object[]{cat.name(), cat.type()}).build()).collect(Collectors.toList());
            return (PCollection)begin.apply((PTransform)Create.of(rows).withRowSchema(SCHEMA));
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized POutput buildIOWriter(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
            throw new UnsupportedOperationException("Cannot write to SHOW CATALOGS");
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded() {
            return PCollection.IsBounded.BOUNDED;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Schema getSchema() {
            return SCHEMA;
        }
    }
}

