/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.parser;

import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.CatalogManagerSchema;
import org.apache.beam.sdk.extensions.sql.impl.parser.BeamSqlParser;
import org.apache.beam.sdk.extensions.sql.impl.parser.SqlDdlNodes;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.runtime.Resources;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Schema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlSetOption;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.util.Pair;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.util.Static;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

public class SqlUseCatalog
extends SqlSetOption
implements BeamSqlParser.ExecutableStatement {
    private final @UnknownKeyFor @NonNull @Initialized SqlIdentifier catalogName;
    private static final @UnknownKeyFor @NonNull @Initialized SqlOperator OPERATOR = new SqlSpecialOperator("USE CATALOG", SqlKind.OTHER);

    public SqlUseCatalog(@UnknownKeyFor @NonNull @Initialized SqlParserPos pos, @UnknownKeyFor @NonNull @Initialized String scope, @UnknownKeyFor @NonNull @Initialized SqlNode catalogName) {
        super(pos, scope, SqlDdlNodes.getIdentifier(catalogName, pos), null);
        this.catalogName = SqlDdlNodes.getIdentifier(catalogName, pos);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized SqlOperator getOperator() {
        return OPERATOR;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SqlNode> getOperandList() {
        return Collections.singletonList(this.catalogName);
    }

    @Override
    public void execute(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized CalcitePrepare.Context context) {
        Pair<CalciteSchema, String> pair = SqlDdlNodes.schema(context, true, this.catalogName);
        Schema schema = ((CalciteSchema)pair.left).schema;
        if (!(schema instanceof CatalogManagerSchema)) {
            throw SqlUtil.newContextException((SqlParserPos)this.catalogName.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal("Attempting to 'USE CATALOG' " + this.catalogName + "' with unexpected Calcite Schema of type " + schema.getClass()));
        }
        ((CatalogManagerSchema)schema).useCatalog(this.catalogName);
    }
}

