/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.parser;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.CatalogManagerSchema;
import org.apache.beam.sdk.extensions.sql.impl.CatalogSchema;
import org.apache.beam.sdk.extensions.sql.impl.TableName;
import org.apache.beam.sdk.extensions.sql.impl.parser.BeamSqlParser;
import org.apache.beam.sdk.extensions.sql.impl.parser.SqlDdlNodes;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.runtime.Resources;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Schema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlDrop;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.util.Pair;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.util.Static;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Splitter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SqlDropDatabase
extends SqlDrop
implements BeamSqlParser.ExecutableStatement {
    private static final @UnknownKeyFor @NonNull @Initialized SqlOperator OPERATOR = new SqlSpecialOperator("DROP DATABASE", SqlKind.OTHER_DDL);
    private final @UnknownKeyFor @NonNull @Initialized SqlIdentifier databaseName;
    private final @UnknownKeyFor @NonNull @Initialized boolean cascade;

    public SqlDropDatabase(@UnknownKeyFor @NonNull @Initialized SqlParserPos pos, @UnknownKeyFor @NonNull @Initialized boolean ifExists, @UnknownKeyFor @NonNull @Initialized SqlIdentifier databaseName, @UnknownKeyFor @NonNull @Initialized boolean cascade) {
        super(OPERATOR, pos, ifExists);
        this.databaseName = databaseName;
        this.cascade = cascade;
    }

    public void unparse(@UnknownKeyFor @NonNull @Initialized SqlWriter writer, @UnknownKeyFor @NonNull @Initialized int leftPrec, @UnknownKeyFor @NonNull @Initialized int rightPrec) {
        writer.keyword(this.getOperator().getName());
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.databaseName.unparse(writer, leftPrec, rightPrec);
        if (this.cascade) {
            writer.keyword("CASCADE");
        } else {
            writer.keyword("RESTRICT");
        }
    }

    @Override
    public void execute(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized CalcitePrepare.Context context) {
        Pair<CalciteSchema, String> pair = SqlDdlNodes.schema(context, true, this.databaseName);
        Schema schema = ((CalciteSchema)pair.left).schema;
        if (!(schema instanceof CatalogManagerSchema)) {
            throw SqlUtil.newContextException((SqlParserPos)this.databaseName.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal("Attempting to drop database '" + this.databaseName + "' with unexpected Calcite Schema of type " + schema.getClass()));
        }
        ArrayList components = Lists.newArrayList((Iterable)Splitter.on((String)".").split((CharSequence)this.databaseName.toString()));
        TableName pathOverride = TableName.create(components, "");
        CatalogSchema catalogSchema = ((CatalogManagerSchema)schema).getCatalogSchema(pathOverride);
        catalogSchema.dropDatabase(this.databaseName, this.cascade, this.ifExists);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SqlNode> getOperandList() {
        return ImmutableList.of((Object)this.databaseName);
    }
}

