/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.impl.TableName;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.CustomTableResolver;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.InMemoryMetaTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class FullNameTableProvider
implements TableProvider,
CustomTableResolver {
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableName> knownTables = new ArrayList<TableName>();

    protected FullNameTableProvider() {
    }

    public abstract @UnknownKeyFor @NonNull @Initialized Table getTableByFullName(@UnknownKeyFor @NonNull @Initialized TableName var1);

    @Override
    public void registerKnownTableNames(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableName> tableNames) {
        this.knownTables.addAll(tableNames);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TableProvider getSubProvider(@UnknownKeyFor @NonNull @Initialized String name) {
        List<TableName> tablesToLookFor = this.knownTables.stream().filter(TableName::isCompound).filter(tableName -> tableName.getPrefix().equals(name)).collect(Collectors.toList());
        return tablesToLookFor.size() > 0 ? new TableNameTrackingProvider(1, tablesToLookFor) : null;
    }

    class TableNameTrackingProvider
    extends InMemoryMetaTableProvider {
        @UnknownKeyFor @NonNull @Initialized int schemaLevel;
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableName> tableNames;

        TableNameTrackingProvider(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized int schemaLevel, List<TableName> tableNames) {
            this.schemaLevel = schemaLevel;
            this.tableNames = tableNames;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TableProvider getSubProvider(@UnknownKeyFor @NonNull @Initialized String name) {
            List<TableName> matchingTables = this.tableNames.stream().filter(TableName::isCompound).filter(tableName -> tableName.getPath().size() > this.schemaLevel).filter(tableName -> tableName.getPath().get(this.schemaLevel).equals(name)).collect(Collectors.toList());
            return matchingTables.size() > 0 ? new TableNameTrackingProvider(this.schemaLevel + 1, matchingTables) : null;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String getTableType() {
            return "google.cloud.datacatalog.subprovider";
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Table getTable(@UnknownKeyFor @NonNull @Initialized String name) {
            Optional<TableName> matchingTable = this.tableNames.stream().filter(tableName -> tableName.getTableName().equals(name)).findFirst();
            TableName fullTableName = matchingTable.orElseThrow(() -> new IllegalStateException("Unexpected table '" + name + "' requested. Current schema level is " + this.schemaLevel + ". Current known table names: " + this.tableNames.toString()));
            return FullNameTableProvider.this.getTableByFullName(fullTableName);
        }

        @Override
        public synchronized @UnknownKeyFor @NonNull @Initialized BeamSqlTable buildBeamSqlTable(@UnknownKeyFor @NonNull @Initialized Table table) {
            return FullNameTableProvider.this.buildBeamSqlTable(table);
        }
    }
}

