/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.io.Serializable;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.transform.BeamSetOperatorsTransforms;
import org.apache.beam.sdk.schemas.transforms.CoGroup;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamSetOperatorRelBase
extends PTransform<PCollectionList<Row>, PCollection<Row>> {
    private @UnknownKeyFor @NonNull @Initialized BeamRelNode beamRelNode;
    private @UnknownKeyFor @NonNull @Initialized boolean all;
    private @UnknownKeyFor @NonNull @Initialized OpType opType;

    public BeamSetOperatorRelBase(@UnknownKeyFor @NonNull @Initialized BeamRelNode beamRelNode, @UnknownKeyFor @NonNull @Initialized OpType opType, @UnknownKeyFor @NonNull @Initialized boolean all) {
        this.beamRelNode = beamRelNode;
        this.opType = opType;
        this.all = all;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row> inputs) {
        Preconditions.checkArgument((inputs.size() == 2 ? 1 : 0) != 0, (String)"Wrong number of arguments to %s: %s", (Object)this.beamRelNode.getClass().getSimpleName(), inputs);
        PCollection leftRows = inputs.get(0);
        PCollection rightRows = inputs.get(1);
        WindowFn leftWindow = leftRows.getWindowingStrategy().getWindowFn();
        WindowFn rightWindow = rightRows.getWindowingStrategy().getWindowFn();
        if (!leftWindow.isCompatible(rightWindow)) {
            throw new IllegalArgumentException("inputs of " + this.opType + " have different window strategy: " + leftWindow + " VS " + rightWindow);
        }
        String lhsTag = "lhs";
        String rhsTag = "rhs";
        PCollection joined = (PCollection)PCollectionTuple.of((String)"lhs", (PCollection)leftRows, (String)"rhs", (PCollection)rightRows).apply("CoGroup", (PTransform)CoGroup.join((CoGroup.By)CoGroup.By.fieldNames((String[])new String[]{"*"})));
        return ((PCollection)joined.apply("FilterResults", (PTransform)ParDo.of((DoFn)new BeamSetOperatorsTransforms.SetOperatorFilteringDoFn("lhs", "rhs", this.opType, this.all)))).setRowSchema(joined.getSchema().getField("key").getType().getRowSchema());
    }

    public static enum OpType implements Serializable
    {
        UNION,
        INTERSECT,
        MINUS;

    }
}

