/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.parser;

import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchema;
import org.apache.beam.sdk.extensions.sql.impl.CatalogManagerSchema;
import org.apache.beam.sdk.extensions.sql.impl.CatalogSchema;
import org.apache.beam.sdk.extensions.sql.impl.TableName;
import org.apache.beam.sdk.extensions.sql.impl.parser.SqlDdlNodes;
import org.apache.beam.sdk.extensions.sql.impl.parser.SqlDropObject;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.runtime.Resources;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Schema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.util.Pair;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.util.Static;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SqlDropTable
extends SqlDropObject {
    private static final @UnknownKeyFor @NonNull @Initialized SqlOperator OPERATOR = new SqlSpecialOperator("DROP TABLE", SqlKind.DROP_TABLE);

    SqlDropTable(@UnknownKeyFor @NonNull @Initialized SqlParserPos pos, @UnknownKeyFor @NonNull @Initialized boolean ifExists, @UnknownKeyFor @NonNull @Initialized SqlIdentifier name) {
        super(OPERATOR, pos, ifExists, name);
    }

    @Override
    public void execute(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized CalcitePrepare.Context context) {
        BeamCalciteSchema beamCalciteSchema;
        Pair<CalciteSchema, String> pair = SqlDdlNodes.schema(context, true, this.name);
        TableName pathOverride = TableName.create(this.name.toString());
        Schema schema = ((CalciteSchema)pair.left).schema;
        if (schema instanceof CatalogManagerSchema) {
            CatalogSchema catalogSchema = ((CatalogManagerSchema)schema).getCatalogSchema(pathOverride);
            beamCalciteSchema = catalogSchema.getDatabaseSchema(pathOverride);
        } else if (schema instanceof BeamCalciteSchema) {
            beamCalciteSchema = (BeamCalciteSchema)schema;
        } else {
            throw SqlUtil.newContextException((SqlParserPos)this.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal("Attempting to drop a table using unexpected Calcite Schema of type " + schema.getClass()));
        }
        if (beamCalciteSchema.getTable((String)pair.right) == null) {
            if (!this.ifExists) {
                throw SqlUtil.newContextException((SqlParserPos)this.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.tableNotFound(this.name.toString()));
            }
            return;
        }
        beamCalciteSchema.getTableProvider().dropTable((String)pair.right);
    }
}

