/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchema;
import org.apache.beam.sdk.extensions.sql.impl.CatalogSchema;
import org.apache.beam.sdk.extensions.sql.impl.JdbcConnection;
import org.apache.beam.sdk.extensions.sql.impl.TableName;
import org.apache.beam.sdk.extensions.sql.impl.parser.SqlDdlNodes;
import org.apache.beam.sdk.extensions.sql.meta.catalog.Catalog;
import org.apache.beam.sdk.extensions.sql.meta.catalog.CatalogManager;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.store.MetaStore;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.runtime.Resources;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Function;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Schema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.SchemaVersion;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Schemas;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Table;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.util.Static;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogManagerSchema
implements Schema {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(CatalogManagerSchema.class);
    private final @UnknownKeyFor @NonNull @Initialized JdbcConnection connection;
    private final @UnknownKeyFor @NonNull @Initialized CatalogManager catalogManager;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized CatalogSchema> catalogSubSchemas = new HashMap<String, CatalogSchema>();

    CatalogManagerSchema(@UnknownKeyFor @NonNull @Initialized JdbcConnection jdbcConnection, @UnknownKeyFor @NonNull @Initialized CatalogManager catalogManager) {
        this.connection = jdbcConnection;
        this.catalogManager = catalogManager;
    }

    @VisibleForTesting
    public @UnknownKeyFor @NonNull @Initialized JdbcConnection connection() {
        return this.connection;
    }

    public void createCatalog(@UnknownKeyFor @NonNull @Initialized SqlIdentifier catalogIdentifier, @UnknownKeyFor @NonNull @Initialized String type, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> properties, @UnknownKeyFor @NonNull @Initialized boolean replace, @UnknownKeyFor @NonNull @Initialized boolean ifNotExists) {
        String name = SqlDdlNodes.name(catalogIdentifier);
        if (this.catalogManager.getCatalog(name) != null) {
            if (replace) {
                LOG.info("Replacing existing catalog '{}'", (Object)name);
                this.catalogManager.dropCatalog(name);
            } else {
                if (!ifNotExists) {
                    throw SqlUtil.newContextException((SqlParserPos)catalogIdentifier.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal(String.format("Catalog '%s' already exists.", name)));
                }
                LOG.info("Catalog '{}' already exists", (Object)name);
                return;
            }
        }
        this.catalogManager.createCatalog(name, type, properties);
        CatalogSchema catalogSchema = new CatalogSchema(this.connection, (Catalog)Preconditions.checkStateNotNull((Object)this.catalogManager.getCatalog(name)));
        this.catalogSubSchemas.put(name, catalogSchema);
    }

    public void useCatalog(@UnknownKeyFor @NonNull @Initialized SqlIdentifier catalogIdentifier) {
        String name = catalogIdentifier.toString();
        if (this.catalogManager.getCatalog(catalogIdentifier.toString()) == null) {
            throw SqlUtil.newContextException((SqlParserPos)catalogIdentifier.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal(String.format("Cannot use catalog: '%s' not found.", name)));
        }
        if (this.catalogManager.currentCatalog().name().equals(name)) {
            LOG.info("Catalog '{}' is already in use.", (Object)name);
            return;
        }
        this.catalogManager.useCatalog(name);
        LOG.info("Switched to catalog '{}' (type: {})", (Object)name, (Object)this.catalogManager.currentCatalog().type());
    }

    public void dropCatalog(@UnknownKeyFor @NonNull @Initialized SqlIdentifier identifier, @UnknownKeyFor @NonNull @Initialized boolean ifExists) {
        String name = SqlDdlNodes.name(identifier);
        if (this.catalogManager.getCatalog(name) == null) {
            if (!ifExists) {
                throw SqlUtil.newContextException((SqlParserPos)identifier.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal(String.format("Cannot drop catalog: '%s' not found.", name)));
            }
            LOG.info("Ignoring 'DROP CATALOG` call for non-existent catalog: {}", (Object)name);
            return;
        }
        if (this.catalogManager.currentCatalog().name().equals(name)) {
            throw SqlUtil.newContextException((SqlParserPos)identifier.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal(String.format("Unable to drop active catalog '%s'. Please switch to another catalog first.", name)));
        }
        this.catalogManager.dropCatalog(name);
        LOG.info("Successfully dropped catalog '{}'", (Object)name);
        this.catalogSubSchemas.remove(name);
    }

    public void maybeRegisterProvider(@UnknownKeyFor @NonNull @Initialized TableName path, @UnknownKeyFor @NonNull @Initialized String type) {
        type = type.toLowerCase();
        CatalogSchema catalogSchema = this.getCatalogSchema(path);
        BeamCalciteSchema beamCalciteSchema = catalogSchema.getDatabaseSchema(path);
        if (beamCalciteSchema.getTableProvider() instanceof MetaStore) {
            MetaStore metaStore = (MetaStore)beamCalciteSchema.getTableProvider();
            if (metaStore.tableProviders().containsKey(type)) {
                return;
            }
            @Nullable TableProvider provider = catalogSchema.getCatalog().tableProviders().get(type);
            if (provider == null) {
                provider = this.catalogManager.tableProviders().get(type);
            }
            if (provider != null) {
                metaStore.registerProvider(provider);
            }
        }
    }

    public @Nullable @UnknownKeyFor @Initialized Table getTable(@UnknownKeyFor @NonNull @Initialized String table) {
        @Nullable CatalogSchema catalogSchema = this.catalogSubSchemas.get(this.catalogManager.currentCatalog().name());
        return catalogSchema != null ? catalogSchema.getTable(table) : null;
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getTableNames() {
        return this.getCurrentCatalogSchema().getTableNames();
    }

    public @UnknownKeyFor @NonNull @Initialized CatalogSchema getCatalogSchema(@UnknownKeyFor @NonNull @Initialized TableName tablePath) {
        @Nullable Schema catalogSchema = this.getSubSchema(tablePath.catalog());
        if (catalogSchema == null) {
            catalogSchema = this.getCurrentCatalogSchema();
        }
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((boolean)(catalogSchema instanceof CatalogSchema), (String)"Unexpected Schema type for Catalog '%s': %s", (Object)tablePath.catalog(), catalogSchema.getClass());
        return (CatalogSchema)catalogSchema;
    }

    public @UnknownKeyFor @NonNull @Initialized CatalogSchema getCurrentCatalogSchema() {
        return (CatalogSchema)Preconditions.checkStateNotNull((Object)this.getSubSchema(this.catalogManager.currentCatalog().name()), (String)"Could not find Calcite Schema for active catalog '%s'.", (Object)this.catalogManager.currentCatalog().name());
    }

    public @Nullable @UnknownKeyFor @Initialized Schema getSubSchema(@Nullable @UnknownKeyFor @Initialized String name) {
        Catalog catalog;
        if (name == null) {
            return null;
        }
        @Nullable CatalogSchema catalogSchema = this.catalogSubSchemas.get(name);
        if (catalogSchema == null && (catalog = this.catalogManager.getCatalog(name)) != null) {
            catalogSchema = new CatalogSchema(this.connection, catalog);
            this.catalogSubSchemas.put(name, catalogSchema);
        }
        if (catalogSchema != null) {
            return catalogSchema;
        }
        return this.getCurrentCatalogSchema().getSubSchema(name);
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getSubSchemaNames() {
        return this.catalogManager.catalogs().stream().map(Catalog::name).collect(Collectors.toSet());
    }

    public void setPipelineOption(@UnknownKeyFor @NonNull @Initialized String key, @UnknownKeyFor @NonNull @Initialized String value) {
        HashMap<String, String> options = new HashMap<String, String>(this.connection.getPipelineOptionsMap());
        options.put(key, value);
        this.connection.setPipelineOptionsMap(options);
    }

    public void removePipelineOption(@UnknownKeyFor @NonNull @Initialized String key) {
        HashMap<String, String> options = new HashMap<String, String>(this.connection.getPipelineOptionsMap());
        options.remove(key);
        this.connection.setPipelineOptionsMap(options);
    }

    public void removeAllPipelineOptions() {
        this.connection.setPipelineOptionsMap(Collections.emptyMap());
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getTypeNames() {
        return Collections.emptySet();
    }

    public @Nullable @UnknownKeyFor @Initialized RelProtoDataType getType(@UnknownKeyFor @NonNull @Initialized String s) {
        return null;
    }

    public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Function> getFunctions(@UnknownKeyFor @NonNull @Initialized String s) {
        return Collections.emptySet();
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getFunctionNames() {
        return Collections.emptySet();
    }

    public @UnknownKeyFor @NonNull @Initialized Expression getExpression(@Nullable @UnknownKeyFor @Initialized SchemaPlus schemaPlus, @UnknownKeyFor @NonNull @Initialized String s) {
        return Schemas.subSchemaExpression((SchemaPlus)((SchemaPlus)Preconditions.checkStateNotNull((Object)schemaPlus)), (String)s, this.getClass());
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isMutable() {
        return true;
    }

    public @UnknownKeyFor @NonNull @Initialized Schema snapshot(@UnknownKeyFor @NonNull @Initialized SchemaVersion schemaVersion) {
        return this;
    }
}

