/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.example.model;

import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.sdk.schemas.JavaBeanSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@DefaultSchema(value=JavaBeanSchema.class)
public class Order
implements Serializable {
    private @UnknownKeyFor @NonNull @Initialized int id;
    private @UnknownKeyFor @NonNull @Initialized int customerId;

    public Order(@UnknownKeyFor @NonNull @Initialized int id, @UnknownKeyFor @NonNull @Initialized int customerId) {
        this.id = id;
        this.customerId = customerId;
    }

    public Order() {
    }

    public @UnknownKeyFor @NonNull @Initialized int getId() {
        return this.id;
    }

    public @UnknownKeyFor @NonNull @Initialized int getCustomerId() {
        return this.customerId;
    }

    public void setId(@UnknownKeyFor @NonNull @Initialized int id) {
        this.id = id;
    }

    public void setCustomerId(@UnknownKeyFor @NonNull @Initialized int customerId) {
        this.customerId = customerId;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Order order = (Order)o;
        return this.id == order.id && this.customerId == order.customerId;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.id, this.customerId);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "Order{id=" + this.id + ", customerId=" + this.customerId + '}';
    }
}

