/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigquery;

import java.io.Serializable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.sql.impl.schema.BaseBeamTable;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;

@Experimental
public class BeamBigQueryTable
extends BaseBeamTable
implements Serializable {
    private String tableSpec;

    public BeamBigQueryTable(Schema beamSchema, String tableSpec) {
        super(beamSchema);
        this.tableSpec = tableSpec;
    }

    @Override
    public PCollection<Row> buildIOReader(PBegin begin) {
        return ((PCollection)begin.apply((PTransform)BigQueryIO.read((SerializableFunction)BigQueryUtils.toBeamRow((Schema)this.schema)).from(this.tableSpec))).setRowSchema(this.getSchema());
    }

    @Override
    public POutput buildIOWriter(PCollection<Row> input) {
        return input.apply((PTransform)BigQueryIO.write().withSchema(BigQueryUtils.toTableSchema((Schema)this.getSchema())).withFormatFunction(BigQueryUtils.toTableRow()).to(this.tableSpec));
    }

    String getTableSpec() {
        return this.tableSpec;
    }
}

