/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlCreate;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlExecutableStatement;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlKind;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Pair;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Static;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchema;
import org.apache.beam.sdk.extensions.sql.impl.parser.SqlDdlNodes;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.schemas.Schema;

public class SqlCreateTable
extends SqlCreate
implements SqlExecutableStatement {
    private final SqlIdentifier name;
    private final List<Schema.Field> columnList;
    private final SqlNode type;
    private final SqlNode comment;
    private final SqlNode location;
    private final SqlNode tblProperties;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("CREATE TABLE", SqlKind.CREATE_TABLE);

    public SqlCreateTable(SqlParserPos pos, boolean replace, boolean ifNotExists, SqlIdentifier name, List<Schema.Field> columnList, SqlNode type, SqlNode comment, SqlNode location, SqlNode tblProperties) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.name = Preconditions.checkNotNull(name);
        this.columnList = columnList;
        this.type = Preconditions.checkNotNull(type);
        this.comment = comment;
        this.location = location;
        this.tblProperties = tblProperties;
    }

    @Override
    public List<SqlNode> getOperandList() {
        throw new UnsupportedOperationException("Getting operands CREATE TABLE is unsupported at the moment");
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        writer.keyword("TABLE");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.columnList != null) {
            SqlWriter.Frame frame = writer.startList("(", ")");
            this.columnList.forEach(column -> this.unparseColumn(writer, (Schema.Field)column));
            writer.endList(frame);
        }
        writer.keyword("TYPE");
        this.type.unparse(writer, 0, 0);
        if (this.comment != null) {
            writer.keyword("COMMENT");
            this.comment.unparse(writer, 0, 0);
        }
        if (this.location != null) {
            writer.keyword("LOCATION");
            this.location.unparse(writer, 0, 0);
        }
        if (this.tblProperties != null) {
            writer.keyword("TBLPROPERTIES");
            this.tblProperties.unparse(writer, 0, 0);
        }
    }

    @Override
    public void execute(CalcitePrepare.Context context) {
        Pair<CalciteSchema, String> pair = SqlDdlNodes.schema(context, true, this.name);
        if (((CalciteSchema)pair.left).plus().getTable((String)pair.right) != null) {
            if (!this.ifNotExists) {
                throw SqlUtil.newContextException(this.name.getParserPosition(), Static.RESOURCE.tableExists((String)pair.right));
            }
            return;
        }
        if (!(((CalciteSchema)pair.left).schema instanceof BeamCalciteSchema)) {
            throw SqlUtil.newContextException(this.name.getParserPosition(), Static.RESOURCE.internal("Schema is not instanceof BeamCalciteSchema"));
        }
        BeamCalciteSchema schema = (BeamCalciteSchema)((CalciteSchema)pair.left).schema;
        schema.getTableProvider().createTable(this.toTable());
    }

    private void unparseColumn(SqlWriter writer, Schema.Field column) {
        writer.sep(",");
        writer.identifier(column.getName());
        writer.identifier(CalciteUtils.toSqlTypeName(column.getType()).name());
        if (column.getNullable() != null && !column.getNullable().booleanValue()) {
            writer.keyword("NOT NULL");
        }
        if (column.getDescription() != null) {
            writer.keyword("COMMENT");
            writer.literal(column.getDescription());
        }
    }

    private Table toTable() {
        return Table.builder().type(SqlDdlNodes.getString(this.type)).name(this.name.getSimple()).schema((Schema)this.columnList.stream().collect(Schema.toSchema())).comment(SqlDdlNodes.getString(this.comment)).location(SqlDdlNodes.getString(this.location)).properties(this.tblProperties == null ? new JSONObject() : JSON.parseObject((String)SqlDdlNodes.getString(this.tblProperties))).build();
    }
}

