/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.map;

import java.util.HashMap;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironment;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;

public class BeamSqlMapExpression
extends BeamSqlExpression {
    public BeamSqlMapExpression(List<BeamSqlExpression> operands) {
        super(operands, SqlTypeName.MAP);
    }

    @Override
    public boolean accept() {
        int distinctCount = 2;
        if (this.operands.size() < 2) {
            return false;
        }
        if (((BeamSqlExpression)this.operands.get(0)).getOutputType().equals((Object)((BeamSqlExpression)this.operands.get(1)).getOutputType())) {
            distinctCount = 1;
        }
        return this.operands.stream().map(BeamSqlExpression::getOutputType).distinct().count() == (long)distinctCount;
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window, BeamSqlExpressionEnvironment env) {
        HashMap elements = new HashMap();
        for (int idx = 0; idx < this.operands.size() / 2; ++idx) {
            elements.put(((BeamSqlExpression)this.operands.get(idx * 2)).evaluate(inputRow, window, env).getValue(), ((BeamSqlExpression)this.operands.get(idx * 2 + 1)).evaluate(inputRow, window, env).getValue());
        }
        return BeamSqlPrimitive.of(this.outputType, elements);
    }
}

