/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator;

import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironment;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;

public class BeamSqlCaseExpression
extends BeamSqlExpression {
    public BeamSqlCaseExpression(List<BeamSqlExpression> operands) {
        super(operands, operands.get(operands.size() - 1).getOutputType());
    }

    @Override
    public boolean accept() {
        if (this.operands.size() % 2 != 1) {
            return false;
        }
        for (int i = 0; i < this.operands.size() - 1; i += 2) {
            if (this.opType(i) != SqlTypeName.BOOLEAN) {
                return false;
            }
            if (this.opType(i + 1) == this.outputType) continue;
            return false;
        }
        return true;
    }

    @Override
    public BeamSqlPrimitive evaluate(Row inputRow, BoundedWindow window, BeamSqlExpressionEnvironment env) {
        for (int i = 0; i < this.operands.size() - 1; i += 2) {
            Boolean wasOpEvaluated = (Boolean)this.opValueEvaluated(i, inputRow, window, env);
            if (wasOpEvaluated == null || !wasOpEvaluated.booleanValue()) continue;
            return BeamSqlPrimitive.of(this.outputType, this.opValueEvaluated(i + 1, inputRow, window, env));
        }
        return BeamSqlPrimitive.of(this.outputType, this.opValueEvaluated(this.operands.size() - 1, inputRow, window, env));
    }
}

