/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Deque;

public class StackWriter
extends FilterWriter {
    public static final int INDENT = -268435455;
    public static final int OUTDENT = -268435454;
    public static final int OPEN_SQL_STRING_LITERAL = -268435453;
    public static final int CLOSE_SQL_STRING_LITERAL = -268435452;
    public static final int OPEN_SQL_IDENTIFIER = -268435451;
    public static final int CLOSE_SQL_IDENTIFIER = -268435450;
    public static final String INDENT_TAB = "\t";
    public static final String INDENT_SPACE4 = "    ";
    private static final Character SINGLE_QUOTE = Character.valueOf('\'');
    private static final Character DOUBLE_QUOTE = Character.valueOf('\"');
    private int indentationDepth;
    private String indentation;
    private boolean needIndent;
    private final Deque<Character> quoteStack = new ArrayDeque<Character>();

    public StackWriter(Writer writer, String indentation) {
        super(writer);
        this.indentation = indentation;
    }

    private void indentIfNeeded() throws IOException {
        if (this.needIndent) {
            for (int i = 0; i < this.indentationDepth; ++i) {
                this.out.write(this.indentation);
            }
            this.needIndent = false;
        }
    }

    private void writeQuote(Character quoteChar) throws IOException {
        this.indentIfNeeded();
        int n = 1;
        for (Character quote : this.quoteStack) {
            if (!quote.equals(quoteChar)) continue;
            n *= 2;
        }
        for (int i = 0; i < n; ++i) {
            this.out.write(quoteChar.charValue());
        }
    }

    private void pushQuote(Character quoteChar) throws IOException {
        this.writeQuote(quoteChar);
        this.quoteStack.push(quoteChar);
    }

    private void popQuote(Character quoteChar) throws IOException {
        Character pop = this.quoteStack.pop();
        assert (pop.equals(quoteChar));
        this.writeQuote(quoteChar);
    }

    @Override
    public void write(int c) throws IOException {
        switch (c) {
            case -268435455: {
                ++this.indentationDepth;
                break;
            }
            case -268435454: {
                --this.indentationDepth;
                break;
            }
            case -268435453: {
                this.pushQuote(SINGLE_QUOTE);
                break;
            }
            case -268435452: {
                this.popQuote(SINGLE_QUOTE);
                break;
            }
            case -268435451: {
                this.pushQuote(DOUBLE_QUOTE);
                break;
            }
            case -268435450: {
                this.popQuote(DOUBLE_QUOTE);
                break;
            }
            case 10: {
                this.out.write(c);
                this.needIndent = true;
                break;
            }
            case 13: {
                this.out.write(c);
                break;
            }
            case 39: {
                this.writeQuote(SINGLE_QUOTE);
                break;
            }
            case 34: {
                this.writeQuote(DOUBLE_QUOTE);
                break;
            }
            default: {
                this.indentIfNeeded();
                this.out.write(c);
            }
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            this.write(cbuf[i]);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            this.write(str.charAt(i));
        }
    }

    public static void printSqlStringLiteral(PrintWriter pw, String s) {
        pw.write(-268435453);
        pw.print(s);
        pw.write(-268435452);
    }

    public static void printSqlIdentifier(PrintWriter pw, String s) {
        pw.write(-268435451);
        pw.print(s);
        pw.write(-268435450);
    }
}

