/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.dialect;

import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlDialect;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlWriter;

public class Db2SqlDialect
extends SqlDialect {
    public static final SqlDialect DEFAULT = new Db2SqlDialect(EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.DB2));

    public Db2SqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }

    @Override
    public boolean hasImplicitTableAlias() {
        return false;
    }

    @Override
    public void unparseSqlIntervalQualifier(SqlWriter writer, SqlIntervalQualifier qualifier, RelDataTypeSystem typeSystem) {
        switch (qualifier.timeUnitRange) {
            case YEAR: 
            case MONTH: 
            case DAY: 
            case HOUR: 
            case MINUTE: 
            case SECOND: 
            case MICROSECOND: {
                String timeUnit = qualifier.timeUnitRange.startUnit.name();
                writer.keyword(timeUnit);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported type: " + (Object)((Object)qualifier.timeUnitRange)));
            }
        }
        if (null != qualifier.timeUnitRange.endUnit) {
            throw new AssertionError((Object)("Unsupported end unit: " + (Object)((Object)qualifier.timeUnitRange.endUnit)));
        }
    }

    @Override
    public void unparseSqlIntervalLiteral(SqlWriter writer, SqlIntervalLiteral literal, int leftPrec, int rightPrec) {
        SqlIntervalLiteral.IntervalValue interval = (SqlIntervalLiteral.IntervalValue)literal.getValue();
        if (interval.getSign() == -1) {
            writer.print("-");
        }
        writer.literal(literal.getValue().toString());
        this.unparseSqlIntervalQualifier(writer, interval.getIntervalQualifier(), RelDataTypeSystem.DEFAULT);
    }
}

