/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.Lists;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.runtime.CalciteException;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.runtime.Resources;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlCall;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlFunction;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlKind;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlLiteral;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlNodeList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlSelect;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlUnresolvedFunction;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SelectScope;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.NlsString;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Static;

public class SqlCallBinding
extends SqlOperatorBinding {
    private static final SqlCall DEFAULT_CALL = SqlStdOperatorTable.DEFAULT.createCall(SqlParserPos.ZERO, new SqlNode[0]);
    private final SqlValidator validator;
    private final SqlValidatorScope scope;
    private final SqlCall call;

    public SqlCallBinding(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        super(validator.getTypeFactory(), call.getOperator());
        this.validator = validator;
        this.scope = scope;
        this.call = call;
    }

    @Override
    public int getGroupCount() {
        SelectScope selectScope = SqlValidatorUtil.getEnclosingSelectScope(this.scope);
        if (selectScope == null) {
            return 0;
        }
        SqlSelect select = selectScope.getNode();
        SqlNodeList group = select.getGroup();
        if (group != null) {
            int n = 0;
            for (SqlNode groupItem : group) {
                if (groupItem instanceof SqlNodeList && ((SqlNodeList)groupItem).size() == 0) continue;
                ++n;
            }
            return n;
        }
        return this.validator.isAggregate(select) ? 0 : -1;
    }

    public SqlValidator getValidator() {
        return this.validator;
    }

    public SqlValidatorScope getScope() {
        return this.scope;
    }

    public SqlCall getCall() {
        return this.call;
    }

    public List<SqlNode> operands() {
        List<RelDataType> paramTypes;
        if (this.hasAssignment() && !(this.call.getOperator() instanceof SqlUnresolvedFunction)) {
            return this.permutedOperands(this.call);
        }
        List<SqlNode> operandList = this.call.getOperandList();
        if (this.call.getOperator() instanceof SqlFunction && (paramTypes = ((SqlFunction)this.call.getOperator()).getParamTypes()) != null && operandList.size() < paramTypes.size()) {
            ArrayList<SqlNode> list = Lists.newArrayList(operandList);
            while (list.size() < paramTypes.size()) {
                list.add(DEFAULT_CALL);
            }
            return list;
        }
        return operandList;
    }

    private boolean hasAssignment() {
        for (SqlNode operand : this.call.getOperandList()) {
            if (operand == null || operand.getKind() != SqlKind.ARGUMENT_ASSIGNMENT) continue;
            return true;
        }
        return false;
    }

    private List<SqlNode> permutedOperands(SqlCall call) {
        SqlFunction operator = (SqlFunction)call.getOperator();
        return Lists.transform(operator.getParamNames(), paramName -> {
            for (SqlNode operand2 : call.getOperandList()) {
                SqlCall call2 = (SqlCall)operand2;
                assert (operand2.getKind() == SqlKind.ARGUMENT_ASSIGNMENT);
                SqlIdentifier id = (SqlIdentifier)call2.operand(1);
                if (!id.getSimple().equals(paramName)) continue;
                return call2.operand(0);
            }
            return DEFAULT_CALL;
        });
    }

    public SqlNode operand(int i) {
        return this.operands().get(i);
    }

    public SqlCall permutedCall() {
        List<SqlNode> operandList = this.operands();
        if (operandList.equals(this.call.getOperandList())) {
            return this.call;
        }
        return this.call.getOperator().createCall(this.call.pos, operandList);
    }

    @Override
    public SqlMonotonicity getOperandMonotonicity(int ordinal) {
        return this.call.getOperandList().get(ordinal).getMonotonicity(this.scope);
    }

    @Override
    public String getStringLiteralOperand(int ordinal) {
        Object node = this.call.operand(ordinal);
        Comparable o = SqlLiteral.value(node);
        return o instanceof NlsString ? ((NlsString)o).getValue() : null;
    }

    @Override
    public int getIntLiteralOperand(int ordinal) {
        Object node = this.call.operand(ordinal);
        Comparable o = SqlLiteral.value(node);
        if (o instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)o;
            try {
                return bd.intValueExact();
            }
            catch (ArithmeticException e) {
                throw SqlUtil.newContextException(((SqlNode)node).pos, Static.RESOURCE.numberLiteralOutOfRange(bd.toString()));
            }
        }
        throw new AssertionError();
    }

    @Override
    public <T> T getOperandLiteralValue(int ordinal, Class<T> clazz) {
        try {
            Object node = this.call.operand(ordinal);
            return SqlLiteral.unchain(node).getValueAs(clazz);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public boolean isOperandNull(int ordinal, boolean allowCast) {
        return SqlUtil.isNullLiteral(this.call.operand(ordinal), allowCast);
    }

    @Override
    public boolean isOperandLiteral(int ordinal, boolean allowCast) {
        return SqlUtil.isLiteral(this.call.operand(ordinal), allowCast);
    }

    @Override
    public int getOperandCount() {
        return this.call.getOperandList().size();
    }

    @Override
    public RelDataType getOperandType(int ordinal) {
        Object operand = this.call.operand(ordinal);
        RelDataType type = this.validator.deriveType(this.scope, (SqlNode)operand);
        SqlValidatorNamespace namespace = this.validator.getNamespace((SqlNode)operand);
        if (namespace != null) {
            return namespace.getType();
        }
        return type;
    }

    @Override
    public RelDataType getCursorOperand(int ordinal) {
        Object operand = this.call.operand(ordinal);
        if (!SqlUtil.isCallTo(operand, SqlStdOperatorTable.CURSOR)) {
            return null;
        }
        SqlCall cursorCall = (SqlCall)operand;
        Object query = cursorCall.operand(0);
        return this.validator.deriveType(this.scope, (SqlNode)query);
    }

    @Override
    public String getColumnListParamInfo(int ordinal, String paramName, List<String> columnList) {
        Object operand = this.call.operand(ordinal);
        if (!SqlUtil.isCallTo(operand, SqlStdOperatorTable.ROW)) {
            return null;
        }
        for (SqlNode id : ((SqlCall)operand).getOperandList()) {
            columnList.add(((SqlIdentifier)id).getSimple());
        }
        return this.validator.getParentCursor(paramName);
    }

    @Override
    public CalciteException newError(Resources.ExInst<SqlValidatorException> e) {
        return this.validator.newValidationError(this.call, e);
    }

    public CalciteException newValidationSignatureError() {
        return this.validator.newValidationError(this.call, Static.RESOURCE.canNotApplyOp2Type(this.getOperator().getName(), this.call.getCallSignature(this.validator, this.scope), this.getOperator().getAllowedSignatures()));
    }

    public CalciteException newValidationError(Resources.ExInst<SqlValidatorException> ex) {
        return this.validator.newValidationError(this.call, ex);
    }
}

