/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree;

import java.lang.reflect.Modifier;
import java.util.Objects;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree.MemberDeclaration;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree.Visitor;

public class FieldDeclaration
extends MemberDeclaration {
    public final int modifier;
    public final ParameterExpression parameter;
    public final Expression initializer;

    public FieldDeclaration(int modifier, ParameterExpression parameter, Expression initializer) {
        assert (parameter != null) : "parameter should not be null";
        this.modifier = modifier;
        this.parameter = parameter;
        this.initializer = initializer;
    }

    @Override
    public MemberDeclaration accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        Expression initializer = this.initializer == null ? null : this.initializer.accept(shuttle);
        return shuttle.visit(this, initializer);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(ExpressionWriter writer) {
        String modifiers = Modifier.toString(this.modifier);
        writer.append(modifiers);
        if (!modifiers.isEmpty()) {
            writer.append(' ');
        }
        writer.append(this.parameter.type).append(' ').append(this.parameter.name);
        if (this.initializer != null) {
            writer.append(" = ").append(this.initializer);
        }
        writer.append(';');
        writer.newlineAndIndent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldDeclaration that = (FieldDeclaration)o;
        if (this.modifier != that.modifier) {
            return false;
        }
        if (this.initializer != null ? !this.initializer.equals(that.initializer) : that.initializer != null) {
            return false;
        }
        return this.parameter.equals(that.parameter);
    }

    public int hashCode() {
        return Objects.hash(this.modifier, this.parameter, this.initializer);
    }
}

