/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable;

import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.interpreter.Interpreter;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptCost;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.SingleRel;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.BuiltInMethod;

public class EnumerableInterpreter
extends SingleRel
implements EnumerableRel {
    private final double factor;

    public EnumerableInterpreter(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, double factor) {
        super(cluster, traitSet, input);
        assert (this.getConvention() instanceof EnumerableConvention);
        this.factor = factor;
    }

    public static EnumerableInterpreter create(RelNode input, double factor) {
        RelTraitSet traitSet = input.getTraitSet().replace(EnumerableConvention.INSTANCE);
        return new EnumerableInterpreter(input.getCluster(), traitSet, input, factor);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(this.factor);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new EnumerableInterpreter(this.getCluster(), traitSet, EnumerableInterpreter.sole(inputs), this.factor);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        JavaTypeFactory typeFactory = implementor.getTypeFactory();
        BlockBuilder builder = new BlockBuilder();
        PhysType physType = PhysTypeImpl.of(typeFactory, this.getRowType(), JavaRowFormat.ARRAY);
        Expression interpreter_ = builder.append("interpreter", Expressions.new_(Interpreter.class, new Expression[]{implementor.getRootExpression(), implementor.stash(this.getInput(), RelNode.class)}));
        Expression sliced_ = this.getRowType().getFieldCount() == 1 ? Expressions.call(BuiltInMethod.SLICE0.method, interpreter_) : interpreter_;
        builder.add(sliced_);
        return implementor.result(physType, builder.toBlock());
    }
}

