/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.parser;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.TableUtils;
import org.apache.beam.sdk.extensions.sql.impl.BeamCalciteSchema;
import org.apache.beam.sdk.extensions.sql.impl.CatalogManagerSchema;
import org.apache.beam.sdk.extensions.sql.impl.CatalogSchema;
import org.apache.beam.sdk.extensions.sql.impl.TableName;
import org.apache.beam.sdk.extensions.sql.impl.parser.BeamSqlParser;
import org.apache.beam.sdk.extensions.sql.impl.parser.SqlDdlNodes;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.runtime.Resources;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlCreate;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlNodeList;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.util.Pair;
import org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.util.Static;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SqlCreateExternalTable
extends SqlCreate
implements BeamSqlParser.ExecutableStatement {
    private final @UnknownKeyFor @NonNull @Initialized SqlIdentifier name;
    private final @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field> columnList;
    private final @UnknownKeyFor @NonNull @Initialized SqlNode type;
    private final @UnknownKeyFor @NonNull @Initialized SqlNode comment;
    private final @UnknownKeyFor @NonNull @Initialized SqlNode location;
    private final @UnknownKeyFor @NonNull @Initialized SqlNode tblProperties;
    private final @Nullable @UnknownKeyFor @Initialized SqlNodeList partitionFields;
    private static final @UnknownKeyFor @NonNull @Initialized SqlOperator OPERATOR = new SqlSpecialOperator("CREATE EXTERNAL TABLE", SqlKind.OTHER_DDL);

    public SqlCreateExternalTable(@UnknownKeyFor @NonNull @Initialized SqlParserPos pos, @UnknownKeyFor @NonNull @Initialized boolean replace, @UnknownKeyFor @NonNull @Initialized boolean ifNotExists, @UnknownKeyFor @NonNull @Initialized SqlIdentifier name, @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field> columnList, @UnknownKeyFor @NonNull @Initialized SqlNode type, @UnknownKeyFor @NonNull @Initialized SqlNodeList partitionFields, @UnknownKeyFor @NonNull @Initialized SqlNode comment, @UnknownKeyFor @NonNull @Initialized SqlNode location, @UnknownKeyFor @NonNull @Initialized SqlNode tblProperties) {
        super(OPERATOR, pos, replace, ifNotExists);
        this.name = (SqlIdentifier)Preconditions.checkNotNull((Object)name);
        this.columnList = columnList;
        this.type = (SqlNode)Preconditions.checkNotNull((Object)type);
        this.partitionFields = partitionFields;
        this.comment = comment;
        this.location = location;
        this.tblProperties = tblProperties;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SqlNode> getOperandList() {
        throw new UnsupportedOperationException("Getting operands CREATE TABLE is unsupported at the moment");
    }

    public void unparse(@UnknownKeyFor @NonNull @Initialized SqlWriter writer, @UnknownKeyFor @NonNull @Initialized int leftPrec, @UnknownKeyFor @NonNull @Initialized int rightPrec) {
        writer.keyword("CREATE");
        writer.keyword("EXTERNAL");
        writer.keyword("TABLE");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        if (this.columnList != null) {
            SqlWriter.Frame frame = writer.startList("(", ")");
            this.columnList.forEach(column -> this.unparseColumn(writer, (Schema.Field)column));
            writer.endList(frame);
        }
        writer.keyword("TYPE");
        this.type.unparse(writer, 0, 0);
        if (this.partitionFields != null) {
            writer.keyword("PARTITIONED");
            writer.keyword("BY");
            writer.sep("(");
            for (int i = 0; i < this.partitionFields.size(); ++i) {
                if (i > 0) {
                    writer.sep(",");
                }
                SqlNode field = this.partitionFields.get(i);
                field.unparse(writer, 0, 0);
            }
            writer.sep(")");
        }
        if (this.comment != null) {
            writer.keyword("COMMENT");
            this.comment.unparse(writer, 0, 0);
        }
        if (this.location != null) {
            writer.keyword("LOCATION");
            this.location.unparse(writer, 0, 0);
        }
        if (this.tblProperties != null) {
            writer.keyword("TBLPROPERTIES");
            this.tblProperties.unparse(writer, 0, 0);
        }
    }

    @Override
    public void execute(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized CalcitePrepare.Context context) {
        BeamCalciteSchema beamCalciteSchema;
        Pair<CalciteSchema, String> pair = SqlDdlNodes.schema(context, true, this.name);
        if (((CalciteSchema)pair.left).plus().getTable((String)pair.right) != null) {
            if (!this.ifNotExists) {
                throw SqlUtil.newContextException((SqlParserPos)this.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.tableExists((String)pair.right));
            }
            return;
        }
        org.apache.beam.vendor.calcite.v1_40_0.org.apache.calcite.schema.Schema schema = ((CalciteSchema)pair.left).schema;
        if (schema instanceof CatalogManagerSchema) {
            TableName pathOverride = TableName.create(this.name.toString());
            CatalogManagerSchema catalogManagerSchema = (CatalogManagerSchema)schema;
            catalogManagerSchema.maybeRegisterProvider(pathOverride, SqlDdlNodes.getString(this.type));
            CatalogSchema catalogSchema = catalogManagerSchema.getCatalogSchema(pathOverride);
            beamCalciteSchema = catalogSchema.getDatabaseSchema(pathOverride);
        } else if (schema instanceof BeamCalciteSchema) {
            beamCalciteSchema = (BeamCalciteSchema)schema;
        } else {
            throw SqlUtil.newContextException((SqlParserPos)this.name.getParserPosition(), (Resources.ExInst)Static.RESOURCE.internal("Attempting to create a table with unexpected Calcite Schema of type " + schema.getClass()));
        }
        Table table = this.toTable();
        if (this.partitionFields != null) {
            Preconditions.checkArgument((boolean)beamCalciteSchema.getTableProvider().supportsPartitioning(table), (String)"Invalid use of 'PARTITIONED BY()': Table '%s' of type '%s' does not support partitioning.", (Object)SqlDdlNodes.name(this.name), (Object)SqlDdlNodes.getString(this.type));
        }
        beamCalciteSchema.getTableProvider().createTable(table);
    }

    private void unparseColumn(@UnknownKeyFor @NonNull @Initialized SqlWriter writer, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field column) {
        writer.sep(",");
        writer.identifier(column.getName(), false);
        writer.identifier(CalciteUtils.toSqlTypeName(column.getType()).name(), false);
        if (column.getType().getNullable() != null && !column.getType().getNullable().booleanValue()) {
            writer.keyword("NOT NULL");
        }
        if (column.getDescription() != null) {
            writer.keyword("COMMENT");
            writer.literal(column.getDescription());
        }
    }

    private @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> parsePartitionFields() {
        if (this.partitionFields == null) {
            return null;
        }
        return this.partitionFields.stream().map(SqlDdlNodes::getString).collect(Collectors.toList());
    }

    private @UnknownKeyFor @NonNull @Initialized Table toTable() {
        return Table.builder().type(SqlDdlNodes.getString(this.type)).name(SqlDdlNodes.name(this.name)).schema((Schema)this.columnList.stream().collect(Schema.toSchema())).partitionFields(this.parsePartitionFields()).comment(SqlDdlNodes.getString(this.comment)).location(SqlDdlNodes.getString(this.location)).properties(this.tblProperties == null ? TableUtils.emptyProperties() : TableUtils.parseProperties(SqlDdlNodes.getString(this.tblProperties))).build();
    }
}

