/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.impl.AutoValue_TableName;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
public abstract class TableName {
    public abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getPath();

    public abstract @UnknownKeyFor @NonNull @Initialized String getTableName();

    public static @UnknownKeyFor @NonNull @Initialized TableName create(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fullPath) {
        Preconditions.checkNotNull(fullPath, (Object)"Full table path cannot be null");
        Preconditions.checkArgument((fullPath.size() > 0 ? 1 : 0) != 0, (Object)"Full table path has to have at least one element");
        return TableName.create(fullPath.subList(0, fullPath.size() - 1), fullPath.get(fullPath.size() - 1));
    }

    public static @UnknownKeyFor @NonNull @Initialized TableName create(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> path, @UnknownKeyFor @NonNull @Initialized String tableName) {
        Preconditions.checkNotNull((Object)tableName, (Object)"Table name cannot be null");
        return new AutoValue_TableName(path == null ? Collections.emptyList() : path, tableName);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isCompound() {
        return this.getPath().size() > 0;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isSimple() {
        return this.getPath().size() == 0;
    }

    public @UnknownKeyFor @NonNull @Initialized String getPrefix() {
        Preconditions.checkState((boolean)this.isCompound());
        return this.getPath().get(0);
    }

    public @UnknownKeyFor @NonNull @Initialized TableName removePrefix() {
        List<String> pathPostfix = this.getPath().stream().skip(1L).collect(Collectors.toList());
        return TableName.create(pathPostfix, this.getTableName());
    }
}

