/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.iceberg;

import java.util.Map;
import java.util.Set;
import org.apache.beam.sdk.extensions.sql.meta.catalog.InMemoryCatalog;
import org.apache.beam.sdk.extensions.sql.meta.provider.iceberg.IcebergTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.store.InMemoryMetaStore;
import org.apache.beam.sdk.io.iceberg.IcebergCatalogConfig;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class IcebergCatalog
extends InMemoryCatalog {
    private static final @UnknownKeyFor @NonNull @Initialized String BEAM_HADOOP_PREFIX = "beam.catalog.hadoop";
    private final @UnknownKeyFor @NonNull @Initialized InMemoryMetaStore metaStore = new InMemoryMetaStore();
    @VisibleForTesting
    final @UnknownKeyFor @NonNull @Initialized IcebergCatalogConfig catalogConfig;

    public IcebergCatalog(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> properties) {
        super(name, properties);
        ImmutableMap.Builder catalogProps = ImmutableMap.builder();
        ImmutableMap.Builder hadoopProps = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (entry.getKey().startsWith(BEAM_HADOOP_PREFIX)) {
                hadoopProps.put((Object)entry.getKey(), (Object)entry.getValue());
                continue;
            }
            catalogProps.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        this.catalogConfig = IcebergCatalogConfig.builder().setCatalogName(name).setCatalogProperties((Map)catalogProps.build()).setConfigProperties((Map)hadoopProps.build()).build();
        this.metaStore.registerProvider(new IcebergTableProvider(this.catalogConfig));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized InMemoryMetaStore metaStore() {
        return this.metaStore;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String type() {
        return "iceberg";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean createDatabase(@UnknownKeyFor @NonNull @Initialized String database) {
        return this.catalogConfig.createNamespace(database);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean dropDatabase(@UnknownKeyFor @NonNull @Initialized String database, @UnknownKeyFor @NonNull @Initialized boolean cascade) {
        boolean removed = this.catalogConfig.dropNamespace(database, cascade);
        if (database.equals(this.currentDatabase)) {
            this.currentDatabase = null;
        }
        return removed;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> listDatabases() {
        return this.catalogConfig.listNamespaces();
    }
}

