/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.datagen;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.beam.sdk.extensions.sql.meta.provider.datagen.AdvancingTimestampFn;
import org.apache.beam.sdk.extensions.sql.meta.provider.datagen.DataGeneratorRowFn;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

public class DataGeneratorPTransform
extends PTransform<PBegin, PCollection<Row>> {
    private final @UnknownKeyFor @NonNull @Initialized Schema schema;
    private final @UnknownKeyFor @NonNull @Initialized ObjectNode properties;

    public DataGeneratorPTransform(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized ObjectNode properties) {
        this.schema = schema;
        this.properties = properties;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
        GenerateSequence generator;
        JsonNode rpsNode = this.properties.path("rows-per-second");
        JsonNode numRowsNode = this.properties.path("number-of-rows");
        if (!rpsNode.isMissingNode()) {
            generator = GenerateSequence.from((long)0L).withRate(rpsNode.asLong(), Duration.standardSeconds((long)1L));
        } else if (!numRowsNode.isMissingNode()) {
            generator = GenerateSequence.from((long)0L).to(numRowsNode.asLong());
        } else {
            throw new IllegalArgumentException("A 'datagen' table requires either 'rows-per-second' (for unbounded) or 'number-of-rows' (for bounded) in TBLPROPERTIES.");
        }
        String behavior = this.properties.path("timestamp.behavior").asText("processing-time");
        String eventTimeColumn = null;
        if ("event-time".equalsIgnoreCase(behavior)) {
            JsonNode columnNode = this.properties.path("event-time.timestamp-column");
            if (columnNode.isMissingNode() || columnNode.isNull()) {
                throw new IllegalArgumentException("For 'event-time' behavior, 'event-time.timestamp-column' must be specified.");
            }
            eventTimeColumn = columnNode.asText();
            if (!this.schema.hasField(eventTimeColumn)) {
                throw new IllegalArgumentException(String.format("The specified 'event-time.timestamp-column' ('%s') does not exist in the table schema.", eventTimeColumn));
            }
            Schema.Field eventTimeField = this.schema.getField(eventTimeColumn);
            if (!Schema.TypeName.DATETIME.equals((Object)eventTimeField.getType().getTypeName())) {
                throw new IllegalArgumentException(String.format("The specified 'event-time.timestamp-column' ('%s') must be of type TIMESTAMP, but was '%s'.", eventTimeColumn, eventTimeField.getType()));
            }
            long maxOutOfOrdernessMs = this.properties.path("event_time.max-out-of-orderness").asLong(0L);
            generator = generator.withTimestampFn((SerializableFunction)new AdvancingTimestampFn(maxOutOfOrdernessMs));
        }
        return ((PCollection)((PCollection)input.getPipeline().apply("GenerateSequence", (PTransform)generator)).apply("GenerateRows", (PTransform)ParDo.of((DoFn)new DataGeneratorRowFn(this.schema, this.properties, eventTimeColumn)))).setRowSchema(this.schema);
    }
}

