/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.catalog;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.beam.sdk.extensions.sql.meta.catalog.Catalog;
import org.apache.beam.sdk.extensions.sql.meta.catalog.CatalogManager;
import org.apache.beam.sdk.extensions.sql.meta.catalog.CatalogRegistrar;
import org.apache.beam.sdk.extensions.sql.meta.catalog.InMemoryCatalog;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class InMemoryCatalogManager
implements CatalogManager {
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Catalog> catalogs = new HashMap<String, Catalog>();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TableProvider> tableProviderMap = new HashMap<String, TableProvider>();
    private @UnknownKeyFor @NonNull @Initialized String currentCatalogName;

    public InMemoryCatalogManager() {
        this.catalogs.put("default", new InMemoryCatalog("default", Collections.emptyMap()));
        this.currentCatalogName = "default";
    }

    @Override
    public void createCatalog(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String type, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> properties) {
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((!this.catalogs.containsKey(name) ? 1 : 0) != 0, (String)"Catalog with name '%s' already exists.", (Object)name);
        Catalog catalog = this.findAndCreateCatalog(name, type, properties);
        this.tableProviderMap.values().forEach(catalog.metaStore()::registerProvider);
        this.catalogs.put(name, catalog);
    }

    @Override
    public void useCatalog(@UnknownKeyFor @NonNull @Initialized String name) {
        if (!this.catalogs.containsKey(name)) {
            throw new IllegalArgumentException("Catalog not found: " + name);
        }
        this.currentCatalogName = name;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Catalog currentCatalog() {
        return (Catalog)Preconditions.checkStateNotNull((Object)this.catalogs.get(this.currentCatalogName));
    }

    @Override
    public @Nullable @UnknownKeyFor @Initialized Catalog getCatalog(@UnknownKeyFor @NonNull @Initialized String name) {
        return this.catalogs.get(name);
    }

    @Override
    public void dropCatalog(@UnknownKeyFor @NonNull @Initialized String name) {
        this.catalogs.remove(name);
    }

    @Override
    public void registerTableProvider(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized TableProvider tableProvider) {
        this.tableProviderMap.put(name, tableProvider);
        this.catalogs.values().forEach(catalog -> catalog.metaStore().registerProvider(tableProvider));
    }

    private @UnknownKeyFor @NonNull @Initialized Catalog findAndCreateCatalog(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String type, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> properties) {
        ImmutableList.Builder list = ImmutableList.builder();
        for (CatalogRegistrar catalogRegistrar : ServiceLoader.load(CatalogRegistrar.class, this.getClass().getClassLoader())) {
            for (Class<? extends Catalog> catalogClass : catalogRegistrar.getCatalogs()) {
                Catalog catalog = this.createCatalogInstance(catalogClass, name, properties);
                if (!catalog.type().equalsIgnoreCase(type)) continue;
                list.add((Object)catalog);
            }
        }
        ImmutableList foundCatalogs = list.build();
        if (foundCatalogs.size() > 1) {
            throw new IllegalStateException(String.format("Could not create catalog '%s': expected only one implementation for type '%s' but found %s", name, type, foundCatalogs.size()));
        }
        if (foundCatalogs.isEmpty()) {
            throw new UnsupportedOperationException(String.format("Could not find type '%s' for catalog '%s'.", type, name));
        }
        return (Catalog)foundCatalogs.get(0);
    }

    private @UnknownKeyFor @NonNull @Initialized Catalog createCatalogInstance(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Catalog> catalogClass, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> properties) {
        try {
            return catalogClass.getConstructor(String.class, Map.class).newInstance(name, properties);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(String.format("Encountered an error when constructing Catalog '%s'", name), e);
        }
    }
}

