/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.iceberg;

import java.util.HashMap;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.iceberg.IcebergTable;
import org.apache.beam.sdk.io.iceberg.IcebergCatalogConfig;
import org.apache.beam.sdk.io.iceberg.TableAlreadyExistsException;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergTableProvider
implements TableProvider {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(IcebergTableProvider.class);
    private static final @UnknownKeyFor @NonNull @Initialized String BEAM_HADOOP_PREFIX = "beam.catalog.hadoop";
    @VisibleForTesting
    final @UnknownKeyFor @NonNull @Initialized IcebergCatalogConfig catalogConfig;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Table> tables = new HashMap<String, Table>();

    public IcebergTableProvider(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> properties) {
        ImmutableMap.Builder catalogProps = ImmutableMap.builder();
        ImmutableMap.Builder hadoopProps = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (entry.getKey().startsWith(BEAM_HADOOP_PREFIX)) {
                hadoopProps.put((Object)entry.getKey(), (Object)entry.getValue());
                continue;
            }
            catalogProps.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        this.catalogConfig = IcebergCatalogConfig.builder().setCatalogName(name).setCatalogProperties((Map)catalogProps.build()).setConfigProperties((Map)hadoopProps.build()).build();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTableType() {
        return "iceberg";
    }

    @Override
    public void createTable(@UnknownKeyFor @NonNull @Initialized Table table) {
        try {
            this.catalogConfig.createTable((String)Preconditions.checkStateNotNull((Object)table.getLocation()), table.getSchema(), table.getPartitionFields());
        }
        catch (TableAlreadyExistsException e) {
            LOG.info("Iceberg table '{}' already exists at location '{}'.", (Object)table.getName(), (Object)table.getLocation());
        }
        this.tables.put(table.getName(), table);
    }

    @Override
    public void dropTable(@UnknownKeyFor @NonNull @Initialized String tableName) {
        Table table = (Table)Preconditions.checkArgumentNotNull((Object)this.getTable(tableName), (String)"Table '%s' is not registered.", (Object)tableName);
        String location = (String)Preconditions.checkStateNotNull((Object)table.getLocation());
        if (this.catalogConfig.dropTable(location)) {
            LOG.info("Dropped table '{}' (location: '{}').", (Object)tableName, (Object)location);
        } else {
            LOG.info("Ignoring DROP TABLE call for '{}' (location: '{}') because it does not exist.", (Object)tableName, (Object)location);
        }
        this.tables.remove(tableName);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Table> getTables() {
        return this.tables;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamSqlTable buildBeamSqlTable(@UnknownKeyFor @NonNull @Initialized Table table) {
        return new IcebergTable(table, this.catalogConfig);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean supportsPartitioning(@UnknownKeyFor @NonNull @Initialized Table table) {
        return true;
    }
}

