/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.iceberg;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTableFilter;
import org.apache.beam.sdk.extensions.sql.meta.DefaultTableFilter;
import org.apache.beam.sdk.extensions.sql.meta.ProjectSupport;
import org.apache.beam.sdk.extensions.sql.meta.SchemaBaseBeamTable;
import org.apache.beam.sdk.extensions.sql.meta.Table;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BeamSqlUnparseContext;
import org.apache.beam.sdk.extensions.sql.meta.provider.iceberg.IcebergFilter;
import org.apache.beam.sdk.io.iceberg.IcebergCatalogConfig;
import org.apache.beam.sdk.managed.Managed;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.dialect.BigQuerySqlDialect;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IcebergTable
extends SchemaBaseBeamTable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(IcebergTable.class);
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized String CATALOG_PROPERTIES_FIELD = "catalog_properties";
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized String HADOOP_CONFIG_PROPERTIES_FIELD = "config_properties";
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized String CATALOG_NAME_FIELD = "catalog_name";
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized String TRIGGERING_FREQUENCY_FIELD = "triggering_frequency_seconds";
    @VisibleForTesting
    final @UnknownKeyFor @NonNull @Initialized String tableIdentifier;
    @VisibleForTesting
    final @UnknownKeyFor @NonNull @Initialized IcebergCatalogConfig catalogConfig;
    @VisibleForTesting
    @Nullable @UnknownKeyFor @Initialized Integer triggeringFrequency;
    @VisibleForTesting
    final @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> partitionFields;

    IcebergTable(@UnknownKeyFor @NonNull @Initialized Table table, @UnknownKeyFor @NonNull @Initialized IcebergCatalogConfig catalogConfig) {
        super(table.getSchema());
        this.schema = table.getSchema();
        this.tableIdentifier = (String)Preconditions.checkArgumentNotNull((Object)table.getLocation());
        this.catalogConfig = catalogConfig;
        ObjectNode properties = table.getProperties();
        if (properties.has(TRIGGERING_FREQUENCY_FIELD)) {
            this.triggeringFrequency = properties.get(TRIGGERING_FREQUENCY_FIELD).asInt();
        }
        this.partitionFields = table.getPartitionFields();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized POutput buildIOWriter(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
        ImmutableMap.Builder configBuilder = ImmutableMap.builder();
        configBuilder.putAll(this.getBaseConfig());
        if (this.triggeringFrequency != null) {
            configBuilder.put((Object)TRIGGERING_FREQUENCY_FIELD, (Object)this.triggeringFrequency);
        }
        if (this.partitionFields != null) {
            configBuilder.put((Object)"partition_fields", this.partitionFields);
        }
        return input.apply((PTransform)Managed.write((String)"iceberg").withConfig((Map)configBuilder.build()));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> buildIOReader(@UnknownKeyFor @NonNull @Initialized PBegin begin) {
        return ((PCollectionRowTuple)begin.apply((PTransform)Managed.read((String)"iceberg").withConfig(this.getBaseConfig()))).getSinglePCollection();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> buildIOReader(@UnknownKeyFor @NonNull @Initialized PBegin begin, @UnknownKeyFor @NonNull @Initialized BeamSqlTableFilter filter, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fieldNames) {
        String expression;
        IcebergFilter icebergFilter;
        HashMap<String, Object> readConfig = new HashMap<String, Object>(this.getBaseConfig());
        if (!(filter instanceof DefaultTableFilter || (icebergFilter = (IcebergFilter)filter).getSupported().isEmpty() || (expression = this.generateFilterExpression(this.getSchema(), icebergFilter.getSupported())).isEmpty())) {
            LOG.info("Pushing down the following filter: {}", (Object)expression);
            readConfig.put("filter", expression);
        }
        if (!fieldNames.isEmpty()) {
            readConfig.put("keep", fieldNames);
        }
        return ((PCollectionRowTuple)begin.apply("Read Iceberg with push-down", (PTransform)Managed.read((String)"iceberg").withConfig(readConfig))).getSinglePCollection();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ProjectSupport supportsProjects() {
        return ProjectSupport.WITHOUT_FIELD_REORDERING;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamSqlTableFilter constructFilter(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> filter) {
        return new IcebergFilter(filter);
    }

    @Override
    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> getBaseConfig() {
        ImmutableMap.Builder managedConfigBuilder = ImmutableMap.builder();
        managedConfigBuilder.put((Object)"table", (Object)this.tableIdentifier);
        @Nullable String name = this.catalogConfig.getCatalogName();
        @Nullable Map catalogProps = this.catalogConfig.getCatalogProperties();
        @Nullable Map hadoopConfProps = this.catalogConfig.getConfigProperties();
        if (name != null) {
            managedConfigBuilder.put((Object)CATALOG_NAME_FIELD, (Object)name);
        }
        if (catalogProps != null) {
            managedConfigBuilder.put((Object)CATALOG_PROPERTIES_FIELD, (Object)catalogProps);
        }
        if (hadoopConfProps != null) {
            managedConfigBuilder.put((Object)HADOOP_CONFIG_PROPERTIES_FIELD, (Object)hadoopConfProps);
        }
        return managedConfigBuilder.build();
    }

    private @UnknownKeyFor @NonNull @Initialized String generateFilterExpression(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> supported) {
        IntFunction<SqlNode> field = i -> new SqlIdentifier(schema.getField(i).getName(), SqlParserPos.ZERO);
        BeamSqlUnparseContext context = new BeamSqlUnparseContext(field);
        SqlNode andSqlNode = null;
        for (RexNode node : supported) {
            SqlNode sqlNode = context.toSql(null, node);
            if (andSqlNode == null) {
                andSqlNode = sqlNode;
                continue;
            }
            andSqlNode = SqlStdOperatorTable.AND.createCall(SqlParserPos.ZERO, (List)ImmutableList.of((Object)andSqlNode, (Object)sqlNode));
        }
        return ((SqlNode)Preconditions.checkStateNotNull(andSqlNode)).toSqlString(BigQuerySqlDialect.DEFAULT).getSql();
    }
}

