/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.udaf;

import java.nio.charset.StandardCharsets;
import org.apache.beam.sdk.transforms.Combine;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class StringAgg {

    public static class StringAggByte
    extends Combine.CombineFn<byte[], String, byte[]> {
        private final @UnknownKeyFor @NonNull @Initialized String delimiter;

        public StringAggByte(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] delimiter) {
            this.delimiter = new String(delimiter, StandardCharsets.UTF_8);
        }

        public @UnknownKeyFor @NonNull @Initialized String createAccumulator() {
            return "";
        }

        public @UnknownKeyFor @NonNull @Initialized String addInput(@UnknownKeyFor @NonNull @Initialized String mutableAccumulator, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] input) {
            if (input != null) {
                mutableAccumulator = !mutableAccumulator.isEmpty() ? mutableAccumulator + this.delimiter + new String(input, StandardCharsets.UTF_8) : new String(input, StandardCharsets.UTF_8);
            }
            return mutableAccumulator;
        }

        public @UnknownKeyFor @NonNull @Initialized String mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> accumList) {
            String mergeString = "";
            for (String stringAccum : accumList) {
                if (stringAccum.isEmpty()) continue;
                if (!mergeString.isEmpty()) {
                    mergeString = mergeString + this.delimiter + stringAccum;
                    continue;
                }
                mergeString = stringAccum;
            }
            return mergeString;
        }

        public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] extractOutput(@UnknownKeyFor @NonNull @Initialized String output) {
            return output.getBytes(StandardCharsets.UTF_8);
        }
    }

    public static class StringAggString
    extends Combine.CombineFn<String, String, String> {
        private final @UnknownKeyFor @NonNull @Initialized String delimiter;

        public StringAggString(@UnknownKeyFor @NonNull @Initialized String delimiter) {
            this.delimiter = delimiter;
        }

        public @UnknownKeyFor @NonNull @Initialized String createAccumulator() {
            return "";
        }

        public @UnknownKeyFor @NonNull @Initialized String addInput(@UnknownKeyFor @NonNull @Initialized String curString, @UnknownKeyFor @NonNull @Initialized String nextString) {
            if (!nextString.isEmpty()) {
                curString = !curString.isEmpty() ? curString + this.delimiter + nextString : nextString;
            }
            return curString;
        }

        public @UnknownKeyFor @NonNull @Initialized String mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> accumList) {
            String mergeString = "";
            for (String stringAccum : accumList) {
                if (stringAccum.isEmpty()) continue;
                if (!mergeString.isEmpty()) {
                    mergeString = mergeString + this.delimiter + stringAccum;
                    continue;
                }
                mergeString = stringAccum;
            }
            return mergeString;
        }

        public @UnknownKeyFor @NonNull @Initialized String extractOutput(@UnknownKeyFor @NonNull @Initialized String output) {
            return output;
        }
    }
}

