/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.kafka;

import java.io.Serializable;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.BeamKafkaTable;
import org.apache.beam.sdk.io.kafka.KafkaRecord;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializer;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PayloadSerializerKafkaTable
extends BeamKafkaTable {
    private final @UnknownKeyFor @NonNull @Initialized PayloadSerializer serializer;

    PayloadSerializerKafkaTable(@UnknownKeyFor @NonNull @Initialized Schema requiredSchema, @UnknownKeyFor @NonNull @Initialized String bootstrapServers, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> topics, @UnknownKeyFor @NonNull @Initialized PayloadSerializer serializer) {
        super(requiredSchema, bootstrapServers, topics);
        this.serializer = serializer;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KafkaRecord<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> getPTransformForInput() {
        return new PTransform<PCollection<KafkaRecord<byte[], byte[]>>, PCollection<Row>>("deserialize-kafka-rows"){

            public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KafkaRecord<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> input) {
                return ((PCollection)input.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(Row.class)).via((SerializableFunction & Serializable)record -> PayloadSerializerKafkaTable.this.serializer.deserialize((byte[])record.getKV().getValue())))).setRowSchema(PayloadSerializerKafkaTable.this.getSchema());
            }
        };
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ProducerRecord<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>>> getPTransformForOutput() {
        final String topic = (String)Iterables.getOnlyElement(this.getTopics());
        return new PTransform<PCollection<Row>, PCollection<ProducerRecord<byte[], byte[]>>>("serialize-kafka-rows"){

            public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ProducerRecord<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
                return (PCollection)input.apply((PTransform)MapElements.into((TypeDescriptor)new TypeDescriptor<ProducerRecord<byte[], byte[]>>(){}).via((SerializableFunction & Serializable)row -> new ProducerRecord(topic, (Object)new byte[0], (Object)PayloadSerializerKafkaTable.this.serializer.serialize(row))));
            }
        };
    }
}

