/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform.agg;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.CovarianceAccumulator;
import org.apache.beam.sdk.extensions.sql.impl.utils.BigDecimalConverter;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.runtime.SqlFunctions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class CovarianceFn<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized Number>
extends Combine.CombineFn<Row, CovarianceAccumulator, T> {
    static final @UnknownKeyFor @NonNull @Initialized MathContext MATH_CTX = new MathContext(10, RoundingMode.HALF_UP);
    private static final @UnknownKeyFor @NonNull @Initialized boolean SAMPLE = true;
    private static final @UnknownKeyFor @NonNull @Initialized boolean POP = false;
    private @UnknownKeyFor @NonNull @Initialized boolean isSample;
    private @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized BigDecimal, T> decimalConverter;

    public static <V extends Number> @UnknownKeyFor @NonNull @Initialized CovarianceFn newPopulation(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.TypeName typeName) {
        return CovarianceFn.newPopulation(BigDecimalConverter.forSqlType(typeName));
    }

    public static <V extends Number> @UnknownKeyFor @NonNull @Initialized CovarianceFn newPopulation(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized BigDecimal, V> decimalConverter) {
        return new CovarianceFn<V>(false, decimalConverter);
    }

    public static <V extends Number> @UnknownKeyFor @NonNull @Initialized CovarianceFn newSample(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Schema.TypeName typeName) {
        return CovarianceFn.newSample(BigDecimalConverter.forSqlType(typeName));
    }

    public static <V extends Number> @UnknownKeyFor @NonNull @Initialized CovarianceFn newSample(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized BigDecimal, V> decimalConverter) {
        return new CovarianceFn<V>(true, decimalConverter);
    }

    private CovarianceFn(@UnknownKeyFor @NonNull @Initialized boolean isSample, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized BigDecimal, T> decimalConverter) {
        this.isSample = isSample;
        this.decimalConverter = decimalConverter;
    }

    public @UnknownKeyFor @NonNull @Initialized CovarianceAccumulator createAccumulator() {
        return CovarianceAccumulator.ofZeroElements();
    }

    public @UnknownKeyFor @NonNull @Initialized CovarianceAccumulator addInput(@UnknownKeyFor @NonNull @Initialized CovarianceAccumulator currentVariance, @UnknownKeyFor @NonNull @Initialized Row rawInput) {
        if (rawInput == null) {
            return currentVariance;
        }
        Preconditions.checkArgument((rawInput.getFieldCount() > 1 ? 1 : 0) != 0);
        return currentVariance.combineWith(CovarianceAccumulator.ofSingleElement(SqlFunctions.toBigDecimal((Object)rawInput.getBaseValue(0, Object.class)), SqlFunctions.toBigDecimal((Object)rawInput.getBaseValue(1, Object.class))));
    }

    public @UnknownKeyFor @NonNull @Initialized CovarianceAccumulator mergeAccumulators(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized CovarianceAccumulator> covariances) {
        return StreamSupport.stream(covariances.spliterator(), false).reduce(CovarianceAccumulator.ofZeroElements(), CovarianceAccumulator::combineWith);
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized CovarianceAccumulator> getAccumulatorCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized Row> inputCoder) {
        return SerializableCoder.of(CovarianceAccumulator.class);
    }

    public T extractOutput(@UnknownKeyFor @NonNull @Initialized CovarianceAccumulator accumulator) {
        return (T)((Number)this.decimalConverter.apply((Object)this.getCovariance(accumulator)));
    }

    private @UnknownKeyFor @NonNull @Initialized BigDecimal getCovariance(@UnknownKeyFor @NonNull @Initialized CovarianceAccumulator covariance) {
        BigDecimal adjustedCount;
        BigDecimal bigDecimal = adjustedCount = this.isSample ? covariance.count().subtract(BigDecimal.ONE) : covariance.count();
        if (adjustedCount.equals(BigDecimal.ZERO)) {
            return BigDecimal.ZERO;
        }
        return covariance.covariance().divide(adjustedCount, MATH_CTX);
    }
}

