/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamIOSinkRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.StateSpecs;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Top;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelCollation;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelCollationImpl;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelFieldCollation;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.Sort;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamSortRel
extends Sort
implements BeamRelNode {
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> fieldIndices = new ArrayList<Integer>();
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> orientation = new ArrayList<Boolean>();
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> nullsFirst = new ArrayList<Boolean>();
    private @UnknownKeyFor @NonNull @Initialized int startIndex = 0;
    private @UnknownKeyFor @NonNull @Initialized int count;

    public BeamSortRel(@UnknownKeyFor @NonNull @Initialized RelOptCluster cluster, @UnknownKeyFor @NonNull @Initialized RelTraitSet traits, @UnknownKeyFor @NonNull @Initialized RelNode child, @UnknownKeyFor @NonNull @Initialized RelCollation collation, @Nullable @UnknownKeyFor @Initialized RexNode offset, @Nullable @UnknownKeyFor @Initialized RexNode fetch) {
        super(cluster, traits, child, collation, offset, fetch);
        List fieldExps = this.getSortExps();
        RelCollationImpl collationImpl = (RelCollationImpl)collation;
        List collations = collationImpl.getFieldCollations();
        for (int i = 0; i < fieldExps.size(); ++i) {
            RexNode fieldExp = (RexNode)fieldExps.get(i);
            RexInputRef inputRef = (RexInputRef)fieldExp;
            this.fieldIndices.add(inputRef.getIndex());
            this.orientation.add(((RelFieldCollation)collations.get(i)).getDirection() == RelFieldCollation.Direction.ASCENDING);
            RelFieldCollation.NullDirection rawNullDirection = ((RelFieldCollation)collations.get((int)i)).nullDirection;
            if (rawNullDirection == RelFieldCollation.NullDirection.UNSPECIFIED) {
                rawNullDirection = ((RelFieldCollation)collations.get(i)).getDirection().defaultNullDirection();
            }
            this.nullsFirst.add(rawNullDirection == RelFieldCollation.NullDirection.FIRST);
        }
        if (fetch == null) {
            throw new UnsupportedOperationException("ORDER BY without a LIMIT is not supported!");
        }
        RexLiteral fetchLiteral = (RexLiteral)fetch;
        this.count = ((BigDecimal)fetchLiteral.getValue()).intValue();
        if (offset != null) {
            RexLiteral offsetLiteral = (RexLiteral)offset;
            this.startIndex = ((BigDecimal)offsetLiteral.getValue()).intValue();
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized NodeStats estimateNodeStats(@UnknownKeyFor @NonNull @Initialized BeamRelMetadataQuery mq) {
        return BeamSqlRelUtils.getNodeStats(this.input, mq);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamCostModel beamComputeSelfCost(@UnknownKeyFor @NonNull @Initialized RelOptPlanner planner, @UnknownKeyFor @NonNull @Initialized BeamRelMetadataQuery mq) {
        NodeStats inputEstimates = BeamSqlRelUtils.getNodeStats(this.input, mq);
        double rowSize = this.getRowType().getFieldCount();
        double cpu = inputEstimates.getRowCount() * inputEstimates.getRowCount() * rowSize;
        double cpuRate = inputEstimates.getRate() * inputEstimates.getWindow() * rowSize;
        return BeamCostModel.FACTORY.makeCost(cpu, cpuRate);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isLimitOnly() {
        return this.fieldIndices.isEmpty();
    }

    public @UnknownKeyFor @NonNull @Initialized int getCount() {
        return this.count;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildPTransform() {
        return new Transform();
    }

    public @UnknownKeyFor @NonNull @Initialized Sort copy(@UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized RelNode newInput, @UnknownKeyFor @NonNull @Initialized RelCollation newCollation, @UnknownKeyFor @NonNull @Initialized RexNode offset, @UnknownKeyFor @NonNull @Initialized RexNode fetch) {
        return new BeamSortRel(this.getCluster(), traitSet, newInput, newCollation, offset, fetch);
    }

    private static class ReversedBeamSqlRowComparator
    implements Comparator<Row>,
    Serializable {
        private final @UnknownKeyFor @NonNull @Initialized BeamSqlRowComparator comparator;

        public ReversedBeamSqlRowComparator(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> fieldsIndices, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> orientation, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> nullsFirst) {
            this.comparator = new BeamSqlRowComparator(fieldsIndices, orientation, nullsFirst);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int compare(@UnknownKeyFor @NonNull @Initialized Row row1, @UnknownKeyFor @NonNull @Initialized Row row2) {
            return this.comparator.compare(row2, row1);
        }
    }

    public static class BeamSqlRowComparator
    implements Comparator<Row>,
    Serializable {
        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> fieldsIndices;
        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> orientation;
        private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> nullsFirst;

        public BeamSqlRowComparator(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> fieldsIndices, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> orientation, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> nullsFirst) {
            this.fieldsIndices = fieldsIndices;
            this.orientation = orientation;
            this.nullsFirst = nullsFirst;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized int compare(@UnknownKeyFor @NonNull @Initialized Row row1, @UnknownKeyFor @NonNull @Initialized Row row2) {
            for (int i = 0; i < this.fieldsIndices.size(); ++i) {
                boolean isValue2Null;
                int fieldIndex = this.fieldsIndices.get(i);
                int fieldRet = 0;
                Schema.FieldType fieldType = row1.getSchema().getField(fieldIndex).getType();
                SqlTypeName sqlTypeName = CalciteUtils.toSqlTypeName(fieldType);
                boolean isValue1Null = row1.getValue(fieldIndex) == null;
                boolean bl = isValue2Null = row2.getValue(fieldIndex) == null;
                if (isValue1Null && isValue2Null) continue;
                if (isValue1Null && !isValue2Null) {
                    fieldRet = -1 * (this.nullsFirst.get(i) != false ? -1 : 1);
                } else if (!isValue1Null && isValue2Null) {
                    fieldRet = 1 * (this.nullsFirst.get(i) != false ? -1 : 1);
                } else {
                    switch (sqlTypeName) {
                        case TINYINT: 
                        case SMALLINT: 
                        case INTEGER: 
                        case BIGINT: 
                        case FLOAT: 
                        case DOUBLE: 
                        case VARCHAR: 
                        case DATE: 
                        case TIMESTAMP: {
                            Comparable v1 = (Comparable)row1.getBaseValue(fieldIndex, Comparable.class);
                            Comparable v2 = (Comparable)row2.getBaseValue(fieldIndex, Comparable.class);
                            fieldRet = v1.compareTo(v2);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Data type: " + sqlTypeName + " not supported yet!");
                        }
                    }
                }
                if ((fieldRet *= this.orientation.get(i) != false ? 1 : -1) == 0) continue;
                return fieldRet;
            }
            return 0;
        }
    }

    private static class SubListFn<@UnknownKeyFor T>
    extends DoFn<List<T>, List<T>> {
        private @UnknownKeyFor @NonNull @Initialized int startIndex;
        private @UnknownKeyFor @NonNull @Initialized int endIndex;

        public SubListFn(@UnknownKeyFor @NonNull @Initialized int startIndex, @UnknownKeyFor @NonNull @Initialized int endIndex) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext ctx) {
            ctx.output(((List)ctx.element()).subList(this.startIndex, this.endIndex));
        }
    }

    private static class LimitFn<@UnknownKeyFor T>
    extends DoFn<KV<String, T>, T> {
        private final @UnknownKeyFor @NonNull @Initialized Integer limitCount;
        private final @UnknownKeyFor @NonNull @Initialized Integer startIndex;
        @DoFn.StateId(value="counter")
        private final @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Integer>> counterState = StateSpecs.value((Coder)VarIntCoder.of());
        @DoFn.StateId(value="skipped_rows")
        private final @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Integer>> skippedRowsState = StateSpecs.value((Coder)VarIntCoder.of());

        public LimitFn(@UnknownKeyFor @NonNull @Initialized int c, @UnknownKeyFor @NonNull @Initialized int s) {
            this.limitCount = c;
            this.startIndex = s;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context, @DoFn.StateId(value="counter") @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Integer> counterState, @DoFn.StateId(value="skipped_rows") @UnknownKeyFor @NonNull @Initialized ValueState<@UnknownKeyFor @NonNull @Initialized Integer> skippedRowsState) {
            Integer toSkipRows = (Integer)MoreObjects.firstNonNull((Object)((Integer)skippedRowsState.read()), (Object)this.startIndex);
            if (toSkipRows == 0) {
                int current = (Integer)MoreObjects.firstNonNull((Object)((Integer)counterState.read()), (Object)0);
                if (current < this.limitCount) {
                    counterState.write((Object)(current + 1));
                    context.output(((KV)context.element()).getValue());
                }
            } else {
                skippedRowsState.write((Object)(toSkipRows - 1));
            }
        }
    }

    private class LimitTransform<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<T>> {
        private final @UnknownKeyFor @NonNull @Initialized int startIndex;

        public LimitTransform(int startIndex) {
            this.startIndex = startIndex;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            Coder coder = input.getCoder();
            PCollection keyedRow = ((PCollection)input.apply((PTransform)WithKeys.of((Object)"DummyKey"))).setCoder((Coder)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)coder));
            return (PCollection)keyedRow.apply((PTransform)ParDo.of(new LimitFn(BeamSortRel.this.getCount(), this.startIndex)));
        }
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row> pinput) {
            Preconditions.checkArgument((pinput.size() == 1 ? 1 : 0) != 0, (String)"Wrong number of inputs for %s: %s", (Object)BeamIOSinkRel.class.getSimpleName(), pinput);
            PCollection upstream = pinput.get(0);
            if (BeamSortRel.this.fieldIndices.isEmpty()) {
                return ((PCollection)((PCollection)upstream.apply((PTransform)Window.into((WindowFn)new GlobalWindows()))).apply(new LimitTransform(BeamSortRel.this.startIndex))).setRowSchema(CalciteUtils.toSchema(BeamSortRel.this.getRowType()));
            }
            WindowingStrategy windowingStrategy = upstream.getWindowingStrategy();
            if (!(windowingStrategy.getWindowFn() instanceof GlobalWindows)) {
                throw new UnsupportedOperationException(String.format("`ORDER BY` is only supported for %s, actual windowing strategy: %s", GlobalWindows.class.getSimpleName(), windowingStrategy));
            }
            ReversedBeamSqlRowComparator comparator = new ReversedBeamSqlRowComparator(BeamSortRel.this.fieldIndices, BeamSortRel.this.orientation, BeamSortRel.this.nullsFirst);
            PCollection rawStream = ((PCollection)upstream.apply("extractTopOffsetAndFetch", (PTransform)Top.of((int)(BeamSortRel.this.startIndex + BeamSortRel.this.count), (Comparator)comparator).withoutDefaults())).setCoder((Coder)ListCoder.of((Coder)upstream.getCoder()));
            if (BeamSortRel.this.startIndex > 0) {
                rawStream = ((PCollection)rawStream.apply("stripLeadingOffset", (PTransform)ParDo.of(new SubListFn(BeamSortRel.this.startIndex, BeamSortRel.this.startIndex + BeamSortRel.this.count)))).setCoder((Coder)ListCoder.of((Coder)upstream.getCoder()));
            }
            return ((PCollection)rawStream.apply("flatten", (PTransform)Flatten.iterables())).setRowSchema(CalciteUtils.toSchema(BeamSortRel.this.getRowType()));
        }
    }
}

