/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPCall;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPFieldRef;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPKind;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPLiteral;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPMeasure;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPOperation;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPPattern;
import org.apache.beam.sdk.extensions.sql.impl.cep.CEPUtils;
import org.apache.beam.sdk.extensions.sql.impl.cep.OrderKey;
import org.apache.beam.sdk.extensions.sql.impl.nfa.NFA;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSortRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelCollation;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.Match;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.ImmutableBitSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamMatchRel
extends Match
implements BeamRelNode {
    public BeamMatchRel(@UnknownKeyFor @NonNull @Initialized RelOptCluster cluster, @UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized RelNode input, @UnknownKeyFor @NonNull @Initialized RelDataType rowType, @UnknownKeyFor @NonNull @Initialized RexNode pattern, @UnknownKeyFor @NonNull @Initialized boolean strictStart, @UnknownKeyFor @NonNull @Initialized boolean strictEnd, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized RexNode> patternDefinitions, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized RexNode> measures, @UnknownKeyFor @NonNull @Initialized RexNode after, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized SortedSet<@UnknownKeyFor @NonNull @Initialized String>> subsets, @UnknownKeyFor @NonNull @Initialized boolean allRows, @UnknownKeyFor @NonNull @Initialized ImmutableBitSet partitionKeys, @UnknownKeyFor @NonNull @Initialized RelCollation orderKeys, @Nullable @UnknownKeyFor @Initialized RexNode interval) {
        super(cluster, traitSet, input, rowType, pattern, strictStart, strictEnd, patternDefinitions, measures, after, subsets, allRows, partitionKeys, orderKeys, interval);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized BeamCostModel beamComputeSelfCost(@UnknownKeyFor @NonNull @Initialized RelOptPlanner planner, @UnknownKeyFor @NonNull @Initialized BeamRelMetadataQuery mq) {
        return BeamCostModel.FACTORY.makeTinyCost();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized NodeStats estimateNodeStats(@UnknownKeyFor @NonNull @Initialized BeamRelMetadataQuery mq) {
        NodeStats inputEstimate = BeamSqlRelUtils.getNodeStats(this.input, mq);
        double numRows = inputEstimate.getRowCount();
        double winSize = inputEstimate.getWindow();
        double rate = inputEstimate.getRate();
        return NodeStats.create(numRows, rate, winSize).multiply(0.5);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildPTransform() {
        return new MatchTransform(this.partitionKeys, this.orderKeys, (Map<String, RexNode>)this.measures, this.allRows, this.pattern, (Map<String, RexNode>)this.patternDefinitions);
    }

    public @UnknownKeyFor @NonNull @Initialized Match copy(@UnknownKeyFor @NonNull @Initialized RelNode input, @UnknownKeyFor @NonNull @Initialized RelDataType rowType, @UnknownKeyFor @NonNull @Initialized RexNode pattern, @UnknownKeyFor @NonNull @Initialized boolean strictStart, @UnknownKeyFor @NonNull @Initialized boolean strictEnd, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized RexNode> patternDefinitions, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized RexNode> measures, @UnknownKeyFor @NonNull @Initialized RexNode after, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized SortedSet<@UnknownKeyFor @NonNull @Initialized String>> subsets, @UnknownKeyFor @NonNull @Initialized boolean allRows, @UnknownKeyFor @NonNull @Initialized ImmutableBitSet partitionKeys, @UnknownKeyFor @NonNull @Initialized RelCollation orderKeys, @UnknownKeyFor @NonNull @Initialized RexNode interval) {
        return new BeamMatchRel(this.getCluster(), this.getTraitSet(), input, rowType, pattern, strictStart, strictEnd, patternDefinitions, measures, after, subsets, allRows, partitionKeys, orderKeys, interval);
    }

    public @UnknownKeyFor @NonNull @Initialized RelNode copy(@UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RelNode> inputs) {
        return new BeamMatchRel(this.getCluster(), traitSet, inputs.get(0), this.rowType, this.pattern, this.strictStart, this.strictEnd, (Map<String, RexNode>)this.patternDefinitions, (Map<String, RexNode>)this.measures, this.after, (Map<String, ? extends SortedSet<String>>)this.subsets, this.allRows, this.partitionKeys, this.orderKeys, this.interval);
    }

    private static class MapKeys
    extends DoFn<Row, KV<Row, Row>> {
        private final @UnknownKeyFor @NonNull @Initialized Schema partitionKeySchema;

        public MapKeys(@UnknownKeyFor @NonNull @Initialized Schema partitionKeySchema) {
            this.partitionKeySchema = partitionKeySchema;
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Row eleRow, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Row>> out) {
            Row.Builder newRowBuilder = Row.withSchema((Schema)this.partitionKeySchema);
            for (Schema.Field i : this.partitionKeySchema.getFields()) {
                String fieldName = i.getName();
                newRowBuilder.addValue(eleRow.getValue(fieldName));
            }
            KV kvPair = KV.of((Object)newRowBuilder.build(), (Object)eleRow);
            out.output((Object)kvPair);
        }
    }

    private static class SortPerKey
    extends DoFn<KV<Row, Iterable<Row>>, KV<Row, Iterable<Row>>> {
        private final @UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized OrderKey> orderKeys;

        public SortPerKey(@UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized OrderKey> orderKeys) {
            this.orderKeys = orderKeys;
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Row>> keyRows, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Row>>> out) {
            ArrayList<Row> rows = new ArrayList<Row>();
            for (Row i : (Iterable)keyRows.getValue()) {
                rows.add(i);
            }
            ArrayList<Integer> fIndexList = new ArrayList<Integer>();
            ArrayList<Boolean> dirList = new ArrayList<Boolean>();
            ArrayList<Boolean> nullDirList = new ArrayList<Boolean>();
            for (int i = this.orderKeys.size() - 1; i >= 0; --i) {
                OrderKey thisKey = this.orderKeys.get(i);
                fIndexList.add(thisKey.getIndex());
                dirList.add(thisKey.getDir());
                nullDirList.add(thisKey.getNullFirst());
            }
            rows.sort(new BeamSortRel.BeamSqlRowComparator(fIndexList, dirList, nullDirList));
            out.output((Object)KV.of((Object)((Row)keyRows.getKey()), rows));
        }
    }

    private static class MatchPattern
    extends DoFn<KV<Row, Iterable<Row>>, Row> {
        private final @UnknownKeyFor @NonNull @Initialized Schema upstreamSchema;
        private final @UnknownKeyFor @NonNull @Initialized Schema outSchema;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized CEPFieldRef> partitionKeys;
        private final @UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized CEPPattern> pattern;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized CEPMeasure> measures;
        private final @UnknownKeyFor @NonNull @Initialized boolean allRows;

        MatchPattern(@UnknownKeyFor @NonNull @Initialized Schema upstreamSchema, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized CEPFieldRef> partitionKeys, @UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized CEPPattern> pattern, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized CEPMeasure> measures, @UnknownKeyFor @NonNull @Initialized boolean allRows, @UnknownKeyFor @NonNull @Initialized Schema outSchema) {
            this.upstreamSchema = upstreamSchema;
            this.partitionKeys = partitionKeys;
            this.pattern = pattern;
            this.measures = measures;
            this.allRows = allRows;
            this.outSchema = outSchema;
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Row>> keyRows, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> out) {
            NFA partNFA = NFA.compile(this.pattern, this.upstreamSchema);
            Iterable partRows = (Iterable)keyRows.getValue();
            for (Row singleRow : partRows) {
                Map<String, ArrayList<Row>> result = partNFA.processNewRow(singleRow);
                if (result == null) continue;
                if (this.allRows) {
                    for (ArrayList<Row> i : result.values()) {
                        for (Row row : i) {
                            out.output((Object)row);
                        }
                    }
                    continue;
                }
                Row.Builder newRowBuilder = Row.withSchema((Schema)this.outSchema);
                Row.FieldValueBuilder newFieldBuilder = null;
                for (CEPFieldRef cEPFieldRef : this.partitionKeys) {
                    int colIndex = cEPFieldRef.getIndex();
                    Schema.Field parSchema = this.upstreamSchema.getField(colIndex);
                    String fieldName = parSchema.getName();
                    if (result.isEmpty()) break;
                    Row partitionKeyRow = (Row)keyRows.getKey();
                    if (newFieldBuilder == null) {
                        newFieldBuilder = newRowBuilder.withFieldValue(fieldName, partitionKeyRow.getValue(fieldName));
                        continue;
                    }
                    newFieldBuilder = newFieldBuilder.withFieldValue(fieldName, partitionKeyRow.getValue(fieldName));
                }
                for (CEPMeasure cEPMeasure : this.measures) {
                    String outName = cEPMeasure.getName();
                    CEPFieldRef patternRef = cEPMeasure.getField();
                    String patternVar = patternRef.getAlpha();
                    List patternRows = result.get(patternVar);
                    CEPOperation opr = cEPMeasure.getOperation();
                    if (opr.getClass() == CEPCall.class) {
                        CEPCall call = (CEPCall)opr;
                        CEPKind funcName = call.getOperator().getCepKind();
                        switch (funcName) {
                            case FIRST: {
                                CEPFieldRef colFirstField = (CEPFieldRef)call.getOperands().get(0);
                                CEPLiteral colFirstIndex = (CEPLiteral)call.getOperands().get(1);
                                Row rowFirstToProc = (Row)patternRows.get(colFirstIndex.getDecimal().intValue());
                                if (newFieldBuilder == null) {
                                    newFieldBuilder = newRowBuilder.withFieldValue(outName, rowFirstToProc.getValue(colFirstField.getIndex()));
                                    break;
                                }
                                newFieldBuilder = newFieldBuilder.withFieldValue(outName, rowFirstToProc.getValue(colFirstField.getIndex()));
                                break;
                            }
                            case LAST: {
                                CEPFieldRef colLastField = (CEPFieldRef)call.getOperands().get(0);
                                CEPLiteral colLastIndex = (CEPLiteral)call.getOperands().get(1);
                                Row rowLastToProc = (Row)patternRows.get(patternRows.size() - 1 - colLastIndex.getDecimal().intValue());
                                if (newFieldBuilder == null) {
                                    newFieldBuilder = newRowBuilder.withFieldValue(outName, rowLastToProc.getValue(colLastField.getIndex()));
                                    break;
                                }
                                newFieldBuilder = newFieldBuilder.withFieldValue(outName, rowLastToProc.getValue(colLastField.getIndex()));
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException("The measure function is not recognized: " + funcName.name());
                            }
                        }
                        continue;
                    }
                    if (opr.getClass() == CEPFieldRef.class) {
                        Row rowToProc = (Row)patternRows.get(0);
                        CEPFieldRef fieldRef = (CEPFieldRef)opr;
                        if (newFieldBuilder == null) {
                            newFieldBuilder = newRowBuilder.withFieldValue(outName, rowToProc.getValue(fieldRef.getIndex()));
                            continue;
                        }
                        newFieldBuilder = newFieldBuilder.withFieldValue(outName, rowToProc.getValue(fieldRef.getIndex()));
                        continue;
                    }
                    throw new UnsupportedOperationException("CEP operation is not recognized: " + opr.getClass().getName());
                }
                Row newRow = newFieldBuilder == null ? newRowBuilder.build() : newFieldBuilder.build();
                out.output((Object)newRow);
            }
        }
    }

    private class MatchTransform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private final @UnknownKeyFor @NonNull @Initialized ImmutableBitSet partitionKeys;
        private final @UnknownKeyFor @NonNull @Initialized RelCollation orderKeys;
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized RexNode> measures;
        private final @UnknownKeyFor @NonNull @Initialized boolean allRows;
        private final @UnknownKeyFor @NonNull @Initialized RexNode pattern;
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized RexNode> patternDefs;

        public MatchTransform(@UnknownKeyFor @NonNull @Initialized ImmutableBitSet partitionKeys, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized RelCollation orderKeys, @UnknownKeyFor @NonNull @Initialized Map<String, RexNode> measures, @UnknownKeyFor @NonNull @Initialized boolean allRows, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized RexNode pattern, Map<String, RexNode> patternDefs) {
            this.partitionKeys = partitionKeys;
            this.orderKeys = orderKeys;
            this.measures = measures;
            this.allRows = allRows;
            this.pattern = pattern;
            this.patternDefs = patternDefs;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row> pinput) {
            Preconditions.checkArgument((pinput.size() == 1 ? 1 : 0) != 0, (String)"Wrong number of inputs for %s: %s", (Object)BeamMatchRel.class.getSimpleName(), pinput);
            PCollection upstream = pinput.get(0);
            Schema upstreamSchema = upstream.getSchema();
            Schema outSchema = CalciteUtils.toSchema(BeamMatchRel.this.getRowType());
            Schema.Builder schemaBuilder = new Schema.Builder();
            Iterator iterator = this.partitionKeys.asList().iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                schemaBuilder.addField(upstreamSchema.getField(index));
            }
            Schema partitionKeySchema = schemaBuilder.build();
            PCollection keyedUpstream = (PCollection)upstream.apply((PTransform)ParDo.of((DoFn)new MapKeys(partitionKeySchema)));
            PCollection groupedUpstream = (PCollection)keyedUpstream.setCoder((Coder)KvCoder.of((Coder)RowCoder.of((Schema)partitionKeySchema), (Coder)RowCoder.of((Schema)upstreamSchema))).apply((PTransform)GroupByKey.create());
            ArrayList<OrderKey> orderKeyList = CEPUtils.makeOrderKeysFromCollation(this.orderKeys);
            PCollection orderedUpstream = (PCollection)groupedUpstream.apply((PTransform)ParDo.of((DoFn)new SortPerKey(orderKeyList)));
            ArrayList<CEPPattern> cepPattern = CEPUtils.getCEPPatternFromPattern(upstreamSchema, this.pattern, this.patternDefs);
            ArrayList<CEPMeasure> cepMeasures = new ArrayList<CEPMeasure>();
            for (Map.Entry<String, RexNode> i : this.measures.entrySet()) {
                CEPOperation measureOperation;
                RexCall rexCall;
                String outTableName = i.getKey();
                if (i.getValue().getClass() == RexCall.class && (rexCall = (RexCall)i.getValue()).getOperator().getKind() == SqlKind.FINAL) {
                    measureOperation = CEPOperation.of((RexNode)rexCall.getOperands().get(0));
                    cepMeasures.add(new CEPMeasure(upstreamSchema, outTableName, measureOperation));
                    continue;
                }
                measureOperation = CEPOperation.of(i.getValue());
                cepMeasures.add(new CEPMeasure(upstreamSchema, outTableName, measureOperation));
            }
            List<CEPFieldRef> cepParKeys = CEPUtils.getCEPFieldRefFromParKeys(this.partitionKeys);
            PCollection outStream = ((PCollection)orderedUpstream.apply((PTransform)ParDo.of((DoFn)new MatchPattern(upstreamSchema, cepParKeys, cepPattern, cepMeasures, this.allRows, outSchema)))).setRowSchema(outSchema);
            return outStream;
        }
    }
}

