/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.beam.sdk.extensions.sql.impl.JdbcConnection;
import org.apache.beam.sdk.extensions.sql.meta.BeamSqlTable;
import org.apache.beam.sdk.extensions.sql.meta.provider.ReadOnlyTableProvider;
import org.apache.beam.sdk.extensions.sql.meta.provider.TableProvider;
import org.apache.beam.sdk.extensions.sql.meta.store.InMemoryMetaStore;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.Function;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.Schema;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.SchemaFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.SchemaVersion;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.Table;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class BeamCalciteSchemaFactory {
    BeamCalciteSchemaFactory() {
    }

    static @UnknownKeyFor @NonNull @Initialized TableProvider fromInitialEmptySchema(@UnknownKeyFor @NonNull @Initialized JdbcConnection jdbcConnection) {
        InitialEmptySchema initialEmptySchema = (InitialEmptySchema)jdbcConnection.getCurrentBeamSchema();
        return initialEmptySchema.getTableProvider();
    }

    public static abstract class InitialEmptySchema
    implements Schema {
        public abstract @UnknownKeyFor @NonNull @Initialized TableProvider getTableProvider();

        public @UnknownKeyFor @NonNull @Initialized Table getTable(@UnknownKeyFor @NonNull @Initialized String name) {
            return (Table)InitialEmptySchema.illegal();
        }

        public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getTableNames() {
            return (Set)InitialEmptySchema.illegal();
        }

        public @UnknownKeyFor @NonNull @Initialized RelProtoDataType getType(@UnknownKeyFor @NonNull @Initialized String name) {
            return (RelProtoDataType)InitialEmptySchema.illegal();
        }

        public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getTypeNames() {
            return (Set)InitialEmptySchema.illegal();
        }

        public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Function> getFunctions(@UnknownKeyFor @NonNull @Initialized String name) {
            return (Collection)InitialEmptySchema.illegal();
        }

        public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getFunctionNames() {
            return (Set)InitialEmptySchema.illegal();
        }

        public @UnknownKeyFor @NonNull @Initialized Schema getSubSchema(@UnknownKeyFor @NonNull @Initialized String name) {
            return (Schema)InitialEmptySchema.illegal();
        }

        public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getSubSchemaNames() {
            return Collections.emptySet();
        }

        public @UnknownKeyFor @NonNull @Initialized Expression getExpression(@UnknownKeyFor @NonNull @Initialized SchemaPlus parentSchema, @UnknownKeyFor @NonNull @Initialized String name) {
            return (Expression)InitialEmptySchema.illegal();
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isMutable() {
            return (Boolean)InitialEmptySchema.illegal();
        }

        public @UnknownKeyFor @NonNull @Initialized Schema snapshot(@UnknownKeyFor @NonNull @Initialized SchemaVersion version) {
            return (Schema)InitialEmptySchema.illegal();
        }

        private static <T> T illegal() {
            throw new IllegalStateException("Beam JDBC connection has not been initialized");
        }
    }

    public static class Empty
    extends InitialEmptySchema
    implements SchemaFactory {
        private static final @UnknownKeyFor @NonNull @Initialized TableProvider READ_ONLY_TABLE_PROVIDER = new ReadOnlyTableProvider("empty", (Map<String, BeamSqlTable>)ImmutableMap.of());

        @Override
        public @UnknownKeyFor @NonNull @Initialized TableProvider getTableProvider() {
            return READ_ONLY_TABLE_PROVIDER;
        }

        public @UnknownKeyFor @NonNull @Initialized Schema create(@UnknownKeyFor @NonNull @Initialized SchemaPlus parentSchema, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> operand) {
            return this;
        }
    }

    public static class AllProviders
    extends InitialEmptySchema
    implements SchemaFactory {
        @Override
        public @UnknownKeyFor @NonNull @Initialized TableProvider getTableProvider() {
            InMemoryMetaStore metaStore = new InMemoryMetaStore();
            for (TableProvider provider : ServiceLoader.load(TableProvider.class, this.getClass().getClassLoader())) {
                metaStore.registerProvider(provider);
            }
            return metaStore;
        }

        public @UnknownKeyFor @NonNull @Initialized Schema create(@UnknownKeyFor @NonNull @Initialized SchemaPlus parentSchema, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> operand) {
            return this;
        }
    }
}

