/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date;

import java.math.BigDecimal;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionEnvironment;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.BeamSqlDatetimeMinusExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.date.TimeUnitUtils;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;
import org.joda.time.DateTime;
import org.joda.time.DurationFieldType;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

public class BeamSqlTimestampMinusIntervalExpression
extends BeamSqlExpression {
    public BeamSqlTimestampMinusIntervalExpression(List<BeamSqlExpression> operands, SqlTypeName outputType) {
        super(operands, outputType);
    }

    @Override
    public boolean accept() {
        return BeamSqlTimestampMinusIntervalExpression.accept(this.operands, this.outputType);
    }

    static boolean accept(List<BeamSqlExpression> operands, SqlTypeName outputType) {
        return operands.size() == 2 && SqlTypeName.TIMESTAMP.equals((Object)outputType) && SqlTypeName.TIMESTAMP.equals((Object)operands.get(0).getOutputType()) && BeamSqlDatetimeMinusExpression.INTERVALS_DURATIONS_TYPES.containsKey((Object)operands.get(1).getOutputType());
    }

    @Override
    public BeamSqlPrimitive evaluate(Row row, BoundedWindow window, BeamSqlExpressionEnvironment env) {
        DateTime date = new DateTime(this.opValueEvaluated(0, row, window, env));
        Period period = this.intervalToPeriod(this.op(1).evaluate(row, window, env));
        return BeamSqlPrimitive.of(this.outputType, date.minus((ReadablePeriod)period));
    }

    private Period intervalToPeriod(BeamSqlPrimitive operand) {
        BigDecimal intervalValue = operand.getDecimal();
        SqlTypeName intervalType = operand.getOutputType();
        int numberOfIntervals = intervalValue.divide(TimeUnitUtils.timeUnitInternalMultiplier(intervalType)).intValueExact();
        return new Period().withField(BeamSqlTimestampMinusIntervalExpression.durationFieldType(intervalType), numberOfIntervals);
    }

    private static DurationFieldType durationFieldType(SqlTypeName intervalTypeToCount) {
        return BeamSqlDatetimeMinusExpression.INTERVALS_DURATIONS_TYPES.get((Object)intervalTypeToCount);
    }
}

