/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.interpreter.operator;

import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.util.TimeUnit;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlExpression;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlOperator;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.operator.BeamSqlPrimitive;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class DateOperators {
    public static final BeamSqlOperator DATETIME_CEIL = new BeamSqlOperator(){

        @Override
        public boolean accept(List<BeamSqlExpression> arguments) {
            return true;
        }

        @Override
        public SqlTypeName getOutputType() {
            return SqlTypeName.TIMESTAMP;
        }

        @Override
        public BeamSqlPrimitive apply(List<BeamSqlPrimitive> arguments) {
            ReadableInstant date = arguments.get(0).getDate();
            TimeUnitRange unit = (TimeUnitRange)((Object)arguments.get(1).getValue());
            return BeamSqlPrimitive.of(this.getOutputType(), new DateTime(DateTimeUtils.unixTimestampCeil(unit, date.getMillis()), date.getZone()));
        }
    };
    public static final BeamSqlOperator DATETIME_FLOOR = new BeamSqlOperator(){

        @Override
        public boolean accept(List<BeamSqlExpression> arguments) {
            return true;
        }

        @Override
        public SqlTypeName getOutputType() {
            return SqlTypeName.TIMESTAMP;
        }

        @Override
        public BeamSqlPrimitive apply(List<BeamSqlPrimitive> arguments) {
            ReadableInstant date = arguments.get(0).getDate();
            TimeUnitRange unit = (TimeUnitRange)((Object)arguments.get(1).getValue());
            return BeamSqlPrimitive.of(this.getOutputType(), new DateTime(DateTimeUtils.unixTimestampFloor(unit, date.getMillis()), date.getZone()));
        }
    };
    public static final BeamSqlOperator EXTRACT = new BeamSqlOperator(){

        @Override
        public boolean accept(List<BeamSqlExpression> arguments) {
            return arguments.size() == 2 && arguments.get(0).getOutputType() == SqlTypeName.SYMBOL && SqlTypeName.DATETIME_TYPES.contains((Object)arguments.get(1).getOutputType());
        }

        @Override
        public SqlTypeName getOutputType() {
            return SqlTypeName.BIGINT;
        }

        @Override
        public BeamSqlPrimitive apply(List<BeamSqlPrimitive> arguments) {
            ReadableInstant time = arguments.get(1).getDate();
            TimeUnitRange unit = (TimeUnitRange)((Object)arguments.get(0).getValue());
            switch (unit) {
                case YEAR: 
                case QUARTER: 
                case MONTH: 
                case DAY: 
                case DOW: 
                case WEEK: 
                case DOY: 
                case CENTURY: 
                case MILLENNIUM: {
                    Long timeByDay = time.getMillis() / 86400000L;
                    Long extracted = DateTimeUtils.unixDateExtract(unit, timeByDay);
                    return BeamSqlPrimitive.of(this.getOutputType(), extracted);
                }
                case HOUR: 
                case MINUTE: 
                case SECOND: {
                    int timeInDay = (int)(time.getMillis() % 86400000L);
                    Long extracted = DateTimeUtils.unixTimeExtract(unit, timeInDay);
                    return BeamSqlPrimitive.of(this.getOutputType(), extracted);
                }
            }
            throw new UnsupportedOperationException("Extract for time unit: " + (Object)((Object)unit) + " not supported!");
        }
    };

    private static boolean acceptMonthOrLarger(TimeUnitRange unitRange) {
        TimeUnit smallestUnit = unitRange.endUnit == null ? unitRange.startUnit : unitRange.endUnit;
        return smallestUnit.multiplier != null && smallestUnit.multiplier.compareTo(TimeUnit.MONTH.multiplier) >= 0;
    }
}

