/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.example;

import javax.annotation.Nullable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.sql.SqlTransform;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;

class BeamSqlExample {
    BeamSqlExample() {
    }

    public static void main(String[] args) {
        PipelineOptions options = PipelineOptionsFactory.fromArgs((String[])args).as(PipelineOptions.class);
        Pipeline p = Pipeline.create((PipelineOptions)options);
        Schema type = Schema.builder().addInt32Field("c1").addStringField("c2").addDoubleField("c3").build();
        Row row1 = Row.withSchema((Schema)type).addValues(new Object[]{1, "row", 1.0}).build();
        Row row2 = Row.withSchema((Schema)type).addValues(new Object[]{2, "row", 2.0}).build();
        Row row3 = Row.withSchema((Schema)type).addValues(new Object[]{3, "row", 3.0}).build();
        PCollection inputTable = (PCollection)PBegin.in((Pipeline)p).apply((PTransform)Create.of((Object)row1, (Object[])new Row[]{row2, row3}).withCoder((Coder)type.getRowCoder()));
        PCollection outputStream = (PCollection)inputTable.apply((PTransform)SqlTransform.query("select c1, c2, c3 from PCOLLECTION where c1 > 1"));
        outputStream.apply("log_result", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<Row, Void>(){

            @Nullable
            public Void apply(Row input) {
                System.out.println("PCOLLECTION: " + input.getValues());
                return null;
            }
        }));
        PCollection outputStream2 = (PCollection)PCollectionTuple.of((TupleTag)new TupleTag("CASE1_RESULT"), (PCollection)outputStream).apply((PTransform)SqlTransform.query("select c2, sum(c3) from CASE1_RESULT group by c2"));
        outputStream2.apply("log_result", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<Row, Void>(){

            @Nullable
            public Void apply(Row input) {
                System.out.println("CASE1_RESULT: " + input.getValues());
                return null;
            }
        }));
        p.run().waitUntilFinish();
    }
}

