/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.reflect.InferredRowCoder;

class SchemaHelper {
    SchemaHelper() {
    }

    static PCollection<Row> toRows(PInput input) {
        PCollection pCollection = (PCollection)input;
        Coder coder = pCollection.getCoder();
        if (coder instanceof RowCoder) {
            return pCollection;
        }
        if (coder instanceof InferredRowCoder) {
            InferredRowCoder inferredSchemaCoder = (InferredRowCoder)coder;
            return ((PCollection)pCollection.apply(pCollection.getName() + "_transformToRows", SchemaHelper.transformToRows(inferredSchemaCoder))).setCoder((Coder)inferredSchemaCoder.rowCoder());
        }
        throw new UnsupportedOperationException("Input PCollections for Beam SQL should either have RowCoder set and contain Rows or have InferredRowCoder for its elements");
    }

    private static PTransform<PCollection<?>, PCollection<Row>> transformToRows(final InferredRowCoder coder) {
        return ParDo.of((DoFn)new DoFn<Object, Row>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                c.output((Object)coder.createRow(c.element()));
            }
        });
    }
}

