/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.Supplier;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.Suppliers;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.Sets;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.Linq4j;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.linq4j.Ord;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlCall;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlNodeList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlSelect;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.AggChecker;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.AggregatingScope;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.DelegatingScope;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SelectScope;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.ImmutableBitSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Litmus;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Pair;

public class AggregatingSelectScope
extends DelegatingScope
implements AggregatingScope {
    private final SqlSelect select;
    private final boolean distinct;
    private List<SqlNode> temporaryGroupExprList;
    public final Supplier<Resolved> resolved = Suppliers.memoize(new Supplier<Resolved>(){

        @Override
        public Resolved get() {
            assert (AggregatingSelectScope.this.temporaryGroupExprList == null);
            AggregatingSelectScope.this.temporaryGroupExprList = new ArrayList();
            try {
                Resolved resolved = AggregatingSelectScope.this.resolve();
                return resolved;
            }
            finally {
                AggregatingSelectScope.this.temporaryGroupExprList = null;
            }
        }
    });

    AggregatingSelectScope(SqlValidatorScope selectScope, SqlSelect select, boolean distinct) {
        super(selectScope);
        this.select = select;
        this.distinct = distinct;
    }

    private Resolved resolve() {
        ImmutableList.Builder<ImmutableList<ImmutableBitSet>> builder = ImmutableList.builder();
        List<SqlNode> extraExprs = ImmutableList.of();
        ImmutableMap<Integer, Integer> groupExprProjection = ImmutableMap.of();
        if (this.select.getGroup() != null) {
            SqlNodeList groupList = this.select.getGroup();
            SqlValidatorUtil.GroupAnalyzer groupAnalyzer = new SqlValidatorUtil.GroupAnalyzer(this.temporaryGroupExprList);
            for (SqlNode groupExpr : groupList) {
                SqlValidatorUtil.analyzeGroupItem(this, groupAnalyzer, builder, groupExpr);
            }
            extraExprs = groupAnalyzer.extraExprs;
            groupExprProjection = groupAnalyzer.groupExprProjection;
        }
        TreeSet<ImmutableBitSet> flatGroupSets = Sets.newTreeSet(ImmutableBitSet.COMPARATOR);
        for (List groupSet : Linq4j.product(builder.build())) {
            flatGroupSets.add(ImmutableBitSet.union(groupSet));
        }
        if (flatGroupSets.isEmpty()) {
            flatGroupSets.add(ImmutableBitSet.of());
        }
        return new Resolved(extraExprs, this.temporaryGroupExprList, flatGroupSets, groupExprProjection);
    }

    private Pair<ImmutableList<SqlNode>, ImmutableList<SqlNode>> getGroupExprs() {
        if (this.distinct) {
            assert (this.select.isDistinct());
            ImmutableList.Builder groupExprs = ImmutableList.builder();
            SelectScope selectScope = (SelectScope)this.parent;
            for (SqlNode selectItem : selectScope.getExpandedSelectList()) {
                groupExprs.add(SqlUtil.stripAs(selectItem));
            }
            return Pair.of(ImmutableList.of(), groupExprs.build());
        }
        if (this.select.getGroup() != null) {
            if (this.temporaryGroupExprList != null) {
                return Pair.of(ImmutableList.of(), ImmutableList.copyOf(this.temporaryGroupExprList));
            }
            Resolved resolved = this.resolved.get();
            return Pair.of(resolved.extraExprList, resolved.groupExprList);
        }
        return Pair.of(ImmutableList.of(), ImmutableList.of());
    }

    @Override
    public SqlNode getNode() {
        return this.select;
    }

    private static boolean allContain(List<ImmutableBitSet> bitSets, int bit) {
        for (ImmutableBitSet bitSet : bitSets) {
            if (bitSet.get(bit)) continue;
            return false;
        }
        return true;
    }

    @Override
    public RelDataType nullifyType(SqlNode node, RelDataType type) {
        Resolved r = this.resolved.get();
        for (Ord<SqlNode> groupExpr : Ord.zip(r.groupExprList)) {
            if (!((SqlNode)groupExpr.e).equalsDeep(node, Litmus.IGNORE) || !r.isNullable(groupExpr.i)) continue;
            return this.validator.getTypeFactory().createTypeWithNullability(type, true);
        }
        return type;
    }

    @Override
    public SqlValidatorScope getOperandScope(SqlCall call) {
        if (call.getOperator().isAggregator()) {
            return this.parent;
        }
        boolean matches = this.checkAggregateExpr(call, false);
        if (matches) {
            return this.parent;
        }
        return super.getOperandScope(call);
    }

    @Override
    public boolean checkAggregateExpr(SqlNode expr, boolean deep) {
        if (deep) {
            expr = this.validator.expand(expr, this);
        }
        Pair<ImmutableList<SqlNode>, ImmutableList<SqlNode>> pair = this.getGroupExprs();
        AggChecker aggChecker = new AggChecker(this.validator, this, (List)pair.left, (List)pair.right, this.distinct);
        if (deep) {
            expr.accept(aggChecker);
        }
        return aggChecker.isGroupExpr(expr);
    }

    @Override
    public void validateExpr(SqlNode expr) {
        this.checkAggregateExpr(expr, true);
    }

    public class Resolved {
        public final ImmutableList<SqlNode> extraExprList;
        public final ImmutableList<SqlNode> groupExprList;
        public final ImmutableBitSet groupSet;
        public final ImmutableList<ImmutableBitSet> groupSets;
        public final Map<Integer, Integer> groupExprProjection;

        Resolved(List<SqlNode> extraExprList, List<SqlNode> groupExprList, Iterable<ImmutableBitSet> groupSets, Map<Integer, Integer> groupExprProjection) {
            this.extraExprList = ImmutableList.copyOf(extraExprList);
            this.groupExprList = ImmutableList.copyOf(groupExprList);
            this.groupSet = ImmutableBitSet.range(groupExprList.size());
            this.groupSets = ImmutableList.copyOf(groupSets);
            this.groupExprProjection = ImmutableMap.copyOf(groupExprProjection);
        }

        public boolean isNullable(int i) {
            return i < this.groupExprList.size() && !AggregatingSelectScope.allContain(this.groupSets, i);
        }

        public boolean isGroupingExpr(SqlNode operand) {
            return this.lookupGroupingExpr(operand) >= 0;
        }

        public int lookupGroupingExpr(SqlNode operand) {
            for (Ord<SqlNode> groupExpr : Ord.zip(this.groupExprList)) {
                if (!operand.equalsDeep((SqlNode)groupExpr.e, Litmus.IGNORE)) continue;
                return groupExpr.i;
            }
            return -1;
        }
    }
}

