/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql;

import java.util.ArrayList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlCall;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlJoin;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlKind;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlLiteral;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlNodeList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlSelect;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlSyntax;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.ReturnTypes;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.util.SqlVisitor;

public class SqlSelectOperator
extends SqlOperator {
    public static final SqlSelectOperator INSTANCE = new SqlSelectOperator();

    private SqlSelectOperator() {
        super("SELECT", SqlKind.SELECT, 2, true, ReturnTypes.SCOPE, null, null);
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.SPECIAL;
    }

    @Override
    public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        assert (functionQualifier == null);
        return new SqlSelect(pos, (SqlNodeList)operands[0], (SqlNodeList)operands[1], operands[2], operands[3], (SqlNodeList)operands[4], operands[5], (SqlNodeList)operands[6], (SqlNodeList)operands[7], operands[8], operands[9]);
    }

    public SqlSelect createCall(SqlNodeList keywordList, SqlNodeList selectList, SqlNode fromClause, SqlNode whereClause, SqlNodeList groupBy, SqlNode having, SqlNodeList windowDecls, SqlNodeList orderBy, SqlNode offset, SqlNode fetch, SqlParserPos pos) {
        return new SqlSelect(pos, keywordList, selectList, fromClause, whereClause, groupBy, having, windowDecls, orderBy, offset, fetch);
    }

    @Override
    public <R> void acceptCall(SqlVisitor<R> visitor, SqlCall call, boolean onlyExpressions, SqlBasicVisitor.ArgHandler<R> argHandler) {
        if (!onlyExpressions) {
            super.acceptCall(visitor, call, onlyExpressions, argHandler);
        }
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlSelect select = (SqlSelect)call;
        SqlWriter.Frame selectFrame = writer.startList(SqlWriter.FrameTypeEnum.SELECT);
        writer.sep("SELECT");
        for (int i = 0; i < select.keywordList.size(); ++i) {
            SqlNode keyword = select.keywordList.get(i);
            keyword.unparse(writer, 0, 0);
        }
        SqlNode selectClause = select.selectList;
        if (selectClause == null) {
            selectClause = SqlIdentifier.star(SqlParserPos.ZERO);
        }
        SqlWriter.Frame selectListFrame = writer.startList(SqlWriter.FrameTypeEnum.SELECT_LIST);
        this.unparseListClause(writer, selectClause);
        writer.endList(selectListFrame);
        if (select.from != null) {
            writer.sep("FROM");
            SqlWriter.Frame fromFrame = writer.startList(SqlWriter.FrameTypeEnum.FROM_LIST);
            select.from.unparse(writer, SqlJoin.OPERATOR.getLeftPrec() - 1, SqlJoin.OPERATOR.getRightPrec() - 1);
            writer.endList(fromFrame);
        }
        if (select.where != null) {
            writer.sep("WHERE");
            if (!writer.isAlwaysUseParentheses()) {
                SqlNode node = select.where;
                SqlKind whereSepKind = SqlKind.AND;
                if (node instanceof SqlCall && node.getKind() == SqlKind.OR) {
                    whereSepKind = SqlKind.OR;
                }
                ArrayList<Object> list = new ArrayList<Object>(0);
                while (node.getKind() == whereSepKind) {
                    assert (node instanceof SqlCall);
                    SqlCall call1 = (SqlCall)node;
                    list.add(0, call1.operand(1));
                    node = call1.operand(0);
                }
                list.add(0, node);
                SqlWriter.Frame whereFrame = writer.startList(SqlWriter.FrameTypeEnum.WHERE_LIST);
                this.unparseListClause(writer, new SqlNodeList(list, select.where.getParserPosition()), whereSepKind);
                writer.endList(whereFrame);
            } else {
                select.where.unparse(writer, 0, 0);
            }
        }
        if (select.groupBy != null) {
            writer.sep("GROUP BY");
            SqlWriter.Frame groupFrame = writer.startList(SqlWriter.FrameTypeEnum.GROUP_BY_LIST);
            if (select.groupBy.getList().isEmpty()) {
                SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.SIMPLE, "(", ")");
                writer.endList(frame);
            } else {
                this.unparseListClause(writer, select.groupBy);
            }
            writer.endList(groupFrame);
        }
        if (select.having != null) {
            writer.sep("HAVING");
            select.having.unparse(writer, 0, 0);
        }
        if (select.windowDecls.size() > 0) {
            writer.sep("WINDOW");
            SqlWriter.Frame windowFrame = writer.startList(SqlWriter.FrameTypeEnum.WINDOW_DECL_LIST);
            for (SqlNode windowDecl : select.windowDecls) {
                writer.sep(",");
                windowDecl.unparse(writer, 0, 0);
            }
            writer.endList(windowFrame);
        }
        if (select.orderBy != null && select.orderBy.size() > 0) {
            writer.sep("ORDER BY");
            SqlWriter.Frame orderFrame = writer.startList(SqlWriter.FrameTypeEnum.ORDER_BY_LIST);
            this.unparseListClause(writer, select.orderBy);
            writer.endList(orderFrame);
        }
        writer.fetchOffset(select.fetch, select.offset);
        writer.endList(selectFrame);
    }

    @Override
    public boolean argumentMustBeScalar(int ordinal) {
        return ordinal == 3;
    }
}

