/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.metadata;

import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.Aggregate;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.Exchange;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.Filter;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.Join;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.Project;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.SemiJoin;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.Sort;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.Union;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.Values;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.BuiltInMethod;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.ImmutableBitSet;

public class RelMdPopulationSize
implements MetadataHandler<BuiltInMetadata.PopulationSize> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.POPULATION_SIZE.method, new RelMdPopulationSize());

    private RelMdPopulationSize() {
    }

    @Override
    public MetadataDef<BuiltInMetadata.PopulationSize> getDef() {
        return BuiltInMetadata.PopulationSize.DEF;
    }

    public Double getPopulationSize(Filter rel, RelMetadataQuery mq, ImmutableBitSet groupKey) {
        return mq.getPopulationSize(rel.getInput(), groupKey);
    }

    public Double getPopulationSize(Sort rel, RelMetadataQuery mq, ImmutableBitSet groupKey) {
        return mq.getPopulationSize(rel.getInput(), groupKey);
    }

    public Double getPopulationSize(Exchange rel, RelMetadataQuery mq, ImmutableBitSet groupKey) {
        return mq.getPopulationSize(rel.getInput(), groupKey);
    }

    public Double getPopulationSize(Union rel, RelMetadataQuery mq, ImmutableBitSet groupKey) {
        Double population = 0.0;
        for (RelNode input : rel.getInputs()) {
            Double subPop = mq.getPopulationSize(input, groupKey);
            if (subPop == null) {
                return null;
            }
            population = population + subPop;
        }
        return population;
    }

    public Double getPopulationSize(Join rel, RelMetadataQuery mq, ImmutableBitSet groupKey) {
        return RelMdUtil.getJoinPopulationSize(mq, rel, groupKey);
    }

    public Double getPopulationSize(SemiJoin rel, RelMetadataQuery mq, ImmutableBitSet groupKey) {
        return mq.getPopulationSize(rel.getLeft(), groupKey);
    }

    public Double getPopulationSize(Aggregate rel, RelMetadataQuery mq, ImmutableBitSet groupKey) {
        ImmutableBitSet.Builder childKey = ImmutableBitSet.builder();
        RelMdUtil.setAggChildKeys(groupKey, rel, childKey);
        return mq.getPopulationSize(rel.getInput(), childKey.build());
    }

    public Double getPopulationSize(Values rel, RelMetadataQuery mq, ImmutableBitSet groupKey) {
        return rel.estimateRowCount(mq) / 2.0;
    }

    public Double getPopulationSize(Project rel, RelMetadataQuery mq, ImmutableBitSet groupKey) {
        ImmutableBitSet.Builder baseCols = ImmutableBitSet.builder();
        ImmutableBitSet.Builder projCols = ImmutableBitSet.builder();
        List<RexNode> projExprs = rel.getProjects();
        RelMdUtil.splitCols(projExprs, groupKey, baseCols, projCols);
        Double population = mq.getPopulationSize(rel.getInput(), baseCols.build());
        if (population == null) {
            return null;
        }
        if (projCols.cardinality() == 0) {
            return population;
        }
        for (int bit : projCols.build()) {
            Double subRowCount = RelMdUtil.cardOfProjExpr(mq, rel, projExprs.get(bit));
            if (subRowCount == null) {
                return null;
            }
            population = population * subRowCount;
        }
        return RelMdUtil.numDistinctVals(population, mq.getRowCount(rel));
    }

    public Double getPopulationSize(RelNode rel, RelMetadataQuery mq, ImmutableBitSet groupKey) {
        boolean uniq = RelMdUtil.areColumnsDefinitelyUnique(mq, rel, groupKey);
        if (uniq) {
            return mq.getRowCount(rel);
        }
        return null;
    }
}

