/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core;

import java.util.List;
import java.util.Objects;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.Aggregate;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlAggFunction;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.mapping.Mapping;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.mapping.Mappings;

public class AggregateCall {
    private final SqlAggFunction aggFunction;
    private final boolean distinct;
    private final boolean approximate;
    public final RelDataType type;
    public final String name;
    private final ImmutableList<Integer> argList;
    public final int filterArg;

    @Deprecated
    public AggregateCall(SqlAggFunction aggFunction, boolean distinct, List<Integer> argList, RelDataType type, String name) {
        this(aggFunction, distinct, false, argList, -1, type, name);
    }

    private AggregateCall(SqlAggFunction aggFunction, boolean distinct, boolean approximate, List<Integer> argList, int filterArg, RelDataType type, String name) {
        this.type = Preconditions.checkNotNull(type);
        this.name = name;
        this.aggFunction = Preconditions.checkNotNull(aggFunction);
        this.argList = ImmutableList.copyOf(argList);
        this.filterArg = filterArg;
        this.distinct = distinct;
        this.approximate = approximate;
    }

    @Deprecated
    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, List<Integer> argList, int groupCount, RelNode input, RelDataType type, String name) {
        return AggregateCall.create(aggFunction, distinct, false, argList, -1, groupCount, input, type, name);
    }

    @Deprecated
    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, List<Integer> argList, int filterArg, int groupCount, RelNode input, RelDataType type, String name) {
        return AggregateCall.create(aggFunction, distinct, false, argList, -1, groupCount, input, type, name);
    }

    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, boolean approximate, List<Integer> argList, int filterArg, int groupCount, RelNode input, RelDataType type, String name) {
        if (type == null) {
            RelDataTypeFactory typeFactory = input.getCluster().getTypeFactory();
            List<RelDataType> types = SqlTypeUtil.projectTypes(input.getRowType(), argList);
            Aggregate.AggCallBinding callBinding = new Aggregate.AggCallBinding(typeFactory, aggFunction, types, groupCount, filterArg >= 0);
            type = aggFunction.inferReturnType(callBinding);
        }
        return AggregateCall.create(aggFunction, distinct, approximate, argList, filterArg, type, name);
    }

    @Deprecated
    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, List<Integer> argList, int filterArg, RelDataType type, String name) {
        return AggregateCall.create(aggFunction, distinct, false, argList, filterArg, type, name);
    }

    public static AggregateCall create(SqlAggFunction aggFunction, boolean distinct, boolean approximate, List<Integer> argList, int filterArg, RelDataType type, String name) {
        return new AggregateCall(aggFunction, distinct, approximate, argList, filterArg, type, name);
    }

    public final boolean isDistinct() {
        return this.distinct;
    }

    public final boolean isApproximate() {
        return this.approximate;
    }

    public final SqlAggFunction getAggregation() {
        return this.aggFunction;
    }

    public final List<Integer> getArgList() {
        return this.argList;
    }

    public final RelDataType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public AggregateCall rename(String name) {
        if (Objects.equals(this.name, name)) {
            return this;
        }
        return new AggregateCall(this.aggFunction, this.distinct, this.approximate, this.argList, this.filterArg, this.type, name);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.aggFunction.getName());
        buf.append("(");
        if (this.distinct) {
            buf.append(this.argList.size() == 0 ? "DISTINCT" : "DISTINCT ");
        }
        int i = -1;
        for (Integer arg : this.argList) {
            if (++i > 0) {
                buf.append(", ");
            }
            buf.append("$");
            buf.append(arg);
        }
        buf.append(")");
        if (this.hasFilter()) {
            buf.append(" FILTER $");
            buf.append(this.filterArg);
        }
        return buf.toString();
    }

    public boolean hasFilter() {
        return this.filterArg >= 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AggregateCall)) {
            return false;
        }
        AggregateCall other = (AggregateCall)o;
        return this.aggFunction.equals(other.aggFunction) && this.distinct == other.distinct && this.argList.equals(other.argList) && this.filterArg == other.filterArg;
    }

    public int hashCode() {
        return Objects.hash(this.aggFunction, this.distinct, this.argList, this.filterArg);
    }

    public Aggregate.AggCallBinding createBinding(Aggregate aggregateRelBase) {
        RelDataType rowType = aggregateRelBase.getInput().getRowType();
        return new Aggregate.AggCallBinding(aggregateRelBase.getCluster().getTypeFactory(), this.aggFunction, SqlTypeUtil.projectTypes(rowType, this.argList), aggregateRelBase.getGroupCount(), this.hasFilter());
    }

    public AggregateCall copy(List<Integer> args, int filterArg) {
        return new AggregateCall(this.aggFunction, this.distinct, this.approximate, args, filterArg, this.type, this.name);
    }

    @Deprecated
    public AggregateCall copy(List<Integer> args) {
        return this.copy(args, this.filterArg);
    }

    public AggregateCall adaptTo(RelNode input, List<Integer> argList, int filterArg, int oldGroupKeyCount, int newGroupKeyCount) {
        RelDataType newType = oldGroupKeyCount == newGroupKeyCount && argList.equals(this.argList) && filterArg == this.filterArg ? this.type : null;
        return AggregateCall.create(this.aggFunction, this.distinct, this.approximate, argList, filterArg, newGroupKeyCount, input, newType, this.getName());
    }

    public AggregateCall transform(Mappings.TargetMapping mapping) {
        return this.copy(Mappings.apply2((Mapping)mapping, this.argList), this.hasFilter() ? Mappings.apply(mapping, this.filterArg) : -1);
    }
}

