/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.remote;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.protobuf.ByteString;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.protobuf.Descriptors;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.protobuf.Message;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.protobuf.ProtocolStringList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.protobuf.UnsafeByteOperations;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.AvaticaClientRuntimeException;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.AvaticaConnection;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.AvaticaSeverity;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.AvaticaUtils;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.BuiltInConnectionProperty;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.ConnectionPropertiesImpl;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.Meta;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.QueryState;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.proto.Common;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.proto.Requests;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.proto.Responses;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.remote.ProtobufService;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.remote.TypedValue;

public interface Service {
    public ResultSetResponse apply(CatalogsRequest var1);

    public ResultSetResponse apply(SchemasRequest var1);

    public ResultSetResponse apply(TablesRequest var1);

    public ResultSetResponse apply(TableTypesRequest var1);

    public ResultSetResponse apply(TypeInfoRequest var1);

    public ResultSetResponse apply(ColumnsRequest var1);

    public PrepareResponse apply(PrepareRequest var1);

    public ExecuteResponse apply(ExecuteRequest var1);

    public ExecuteResponse apply(PrepareAndExecuteRequest var1);

    public SyncResultsResponse apply(SyncResultsRequest var1);

    public FetchResponse apply(FetchRequest var1);

    public CreateStatementResponse apply(CreateStatementRequest var1);

    public CloseStatementResponse apply(CloseStatementRequest var1);

    public OpenConnectionResponse apply(OpenConnectionRequest var1);

    public CloseConnectionResponse apply(CloseConnectionRequest var1);

    public ConnectionSyncResponse apply(ConnectionSyncRequest var1);

    public DatabasePropertyResponse apply(DatabasePropertyRequest var1);

    public CommitResponse apply(CommitRequest var1);

    public RollbackResponse apply(RollbackRequest var1);

    public ExecuteBatchResponse apply(PrepareAndExecuteBatchRequest var1);

    public ExecuteBatchResponse apply(ExecuteBatchRequest var1);

    public void setRpcMetadata(RpcMetadataResponse var1);

    public static class ExecuteBatchResponse
    extends Response {
        private static final Descriptors.FieldDescriptor RPC_METADATA_DESCRIPTOR = Responses.ExecuteBatchResponse.getDescriptor().findFieldByNumber(5);
        public final String connectionId;
        public final int statementId;
        public final long[] updateCounts;
        public final boolean missingStatement;
        public final RpcMetadataResponse rpcMetadata;

        ExecuteBatchResponse() {
            this.connectionId = null;
            this.statementId = 0;
            this.updateCounts = null;
            this.missingStatement = false;
            this.rpcMetadata = null;
        }

        @JsonCreator
        public ExecuteBatchResponse(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId, @JsonProperty(value="updateCounts") long[] updateCounts, @JsonProperty(value="missingStatement") boolean missingStatement, @JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.updateCounts = updateCounts;
            this.missingStatement = missingStatement;
            this.rpcMetadata = rpcMetadata;
        }

        public int hashCode() {
            int result = 1;
            result = ExecuteBatchResponse.p(result, this.connectionId);
            result = ExecuteBatchResponse.p(result, this.statementId);
            result = ExecuteBatchResponse.p(result, this.updateCounts);
            result = ExecuteBatchResponse.p(result, this.missingStatement);
            return result;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof ExecuteBatchResponse && Arrays.equals(this.updateCounts, ((ExecuteBatchResponse)o).updateCounts) && Objects.equals(this.connectionId, ((ExecuteBatchResponse)o).connectionId) && this.statementId == ((ExecuteBatchResponse)o).statementId && this.missingStatement == ((ExecuteBatchResponse)o).missingStatement;
        }

        @Override
        ExecuteBatchResponse deserialize(Message genericMsg) {
            Responses.ExecuteBatchResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.ExecuteBatchResponse.class);
            long[] updateCounts = new long[msg.getUpdateCountsCount()];
            int i = 0;
            for (Long updateCount : msg.getUpdateCountsList()) {
                updateCounts[i++] = updateCount;
            }
            RpcMetadataResponse metadata = null;
            if (msg.hasField(RPC_METADATA_DESCRIPTOR)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new ExecuteBatchResponse(msg.getConnectionId(), msg.getStatementId(), updateCounts, msg.getMissingStatement(), metadata);
        }

        @Override
        Responses.ExecuteBatchResponse serialize() {
            Responses.ExecuteBatchResponse.Builder builder = Responses.ExecuteBatchResponse.newBuilder();
            if (null != this.updateCounts) {
                for (int i = 0; i < this.updateCounts.length; ++i) {
                    builder.addUpdateCounts(this.updateCounts[i]);
                }
            }
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            return builder.setConnectionId(this.connectionId).setStatementId(this.statementId).build();
        }
    }

    public static class ExecuteBatchRequest
    extends Request {
        public final String connectionId;
        public final int statementId;
        public final List<List<TypedValue>> parameterValues;
        @JsonIgnore
        private List<Requests.UpdateBatch> protoParameterValues = null;

        ExecuteBatchRequest() {
            this.connectionId = null;
            this.statementId = 0;
            this.parameterValues = null;
        }

        @JsonCreator
        public ExecuteBatchRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId, @JsonProperty(value="parameterValues") List<List<TypedValue>> parameterValues) {
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.parameterValues = parameterValues;
        }

        ExecuteBatchRequest(String connectionId, int statementId) {
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.parameterValues = null;
        }

        public boolean hasProtoUpdateBatches() {
            return null != this.protoParameterValues;
        }

        @JsonIgnore
        public List<Requests.UpdateBatch> getProtoUpdateBatches() {
            return this.protoParameterValues;
        }

        @Override
        public ExecuteBatchResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        ExecuteBatchRequest deserialize(Message genericMsg) {
            Requests.ExecuteBatchRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.ExecuteBatchRequest.class);
            List<Requests.UpdateBatch> updateBatches = msg.getUpdatesList();
            ExecuteBatchRequest pojo = new ExecuteBatchRequest(msg.getConnectionId(), msg.getStatementId());
            pojo.protoParameterValues = updateBatches;
            return pojo;
        }

        @Override
        Requests.ExecuteBatchRequest serialize() {
            Requests.ExecuteBatchRequest.Builder builder = Requests.ExecuteBatchRequest.newBuilder();
            if (this.hasProtoUpdateBatches()) {
                builder.addAllUpdates(this.protoParameterValues);
            } else if (null != this.parameterValues) {
                for (List<TypedValue> updateBatch : this.parameterValues) {
                    Requests.UpdateBatch.Builder batchBuilder = Requests.UpdateBatch.newBuilder();
                    for (TypedValue update : updateBatch) {
                        batchBuilder.addParameterValues(update.toProto());
                    }
                    builder.addUpdates(batchBuilder.build());
                }
            }
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.setStatementId(this.statementId).build();
        }

        public int hashCode() {
            int result = 1;
            result = ExecuteBatchRequest.p(result, this.connectionId);
            result = ExecuteBatchRequest.p(result, this.statementId);
            result = ExecuteBatchRequest.p(result, this.parameterValues);
            return result;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof ExecuteBatchRequest && Objects.equals(this.connectionId, ((ExecuteBatchRequest)o).connectionId) && this.statementId == ((ExecuteBatchRequest)o).statementId && Objects.equals(this.protoParameterValues, ((ExecuteBatchRequest)o).protoParameterValues) && Objects.equals(this.parameterValues, ((ExecuteBatchRequest)o).parameterValues);
        }
    }

    public static class PrepareAndExecuteBatchRequest
    extends Request {
        public final String connectionId;
        public final List<String> sqlCommands;
        public final int statementId;

        PrepareAndExecuteBatchRequest() {
            this.connectionId = null;
            this.statementId = 0;
            this.sqlCommands = null;
        }

        @JsonCreator
        public PrepareAndExecuteBatchRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId, @JsonProperty(value="sqlCommands") List<String> sqlCommands) {
            this.connectionId = connectionId;
            this.sqlCommands = sqlCommands;
            this.statementId = statementId;
        }

        @Override
        public ExecuteBatchResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        public Requests.PrepareAndExecuteBatchRequest serialize() {
            Requests.PrepareAndExecuteBatchRequest.Builder builder = Requests.PrepareAndExecuteBatchRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.sqlCommands) {
                builder.addAllSqlCommands(this.sqlCommands);
            }
            return builder.setStatementId(this.statementId).build();
        }

        @Override
        public PrepareAndExecuteBatchRequest deserialize(Message genericMsg) {
            Requests.PrepareAndExecuteBatchRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.PrepareAndExecuteBatchRequest.class);
            ArrayList<String> sqlCommands = new ArrayList<String>(msg.getSqlCommandsList());
            return new PrepareAndExecuteBatchRequest(msg.getConnectionId(), msg.getStatementId(), sqlCommands);
        }

        public int hashCode() {
            int result = 1;
            result = PrepareAndExecuteBatchRequest.p(result, this.connectionId);
            result = PrepareAndExecuteBatchRequest.p(result, this.statementId);
            result = PrepareAndExecuteBatchRequest.p(result, this.sqlCommands);
            return result;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof PrepareAndExecuteBatchRequest && Objects.equals(this.connectionId, ((PrepareAndExecuteBatchRequest)o).connectionId) && this.statementId == ((PrepareAndExecuteBatchRequest)o).statementId && Objects.equals(this.sqlCommands, ((PrepareAndExecuteBatchRequest)o).sqlCommands);
        }
    }

    public static class RollbackResponse
    extends Response {
        private static final RollbackResponse INSTANCE = new RollbackResponse();
        private static final Responses.RollbackResponse PB_INSTANCE = Responses.RollbackResponse.getDefaultInstance();

        RollbackResponse() {
        }

        @Override
        RollbackResponse deserialize(Message genericMsg) {
            ProtobufService.castProtobufMessage(genericMsg, Responses.RollbackResponse.class);
            return INSTANCE;
        }

        @Override
        Responses.RollbackResponse serialize() {
            return PB_INSTANCE;
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof RollbackResponse;
        }
    }

    public static class RollbackRequest
    extends Request {
        private static final Descriptors.FieldDescriptor CONNECTION_ID_DESCRIPTOR = Requests.RollbackRequest.getDescriptor().findFieldByNumber(1);
        public final String connectionId;

        RollbackRequest() {
            this.connectionId = null;
        }

        public RollbackRequest(@JsonProperty(value="connectionId") String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        RollbackResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        RollbackRequest deserialize(Message genericMsg) {
            Requests.RollbackRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.RollbackRequest.class);
            String connectionId = null;
            if (msg.hasField(CONNECTION_ID_DESCRIPTOR)) {
                connectionId = msg.getConnectionId();
            }
            return new RollbackRequest(connectionId);
        }

        @Override
        Requests.RollbackRequest serialize() {
            Requests.RollbackRequest.Builder builder = Requests.RollbackRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.build();
        }

        public int hashCode() {
            int result = 1;
            result = RollbackRequest.p(result, this.connectionId);
            return result;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof RollbackRequest && Objects.equals(this.connectionId, ((RollbackRequest)o).connectionId);
        }
    }

    public static class CommitResponse
    extends Response {
        private static final CommitResponse INSTANCE = new CommitResponse();
        private static final Responses.CommitResponse PB_INSTANCE = Responses.CommitResponse.getDefaultInstance();

        CommitResponse() {
        }

        @Override
        CommitResponse deserialize(Message genericMsg) {
            ProtobufService.castProtobufMessage(genericMsg, Responses.CommitResponse.class);
            return INSTANCE;
        }

        @Override
        Responses.CommitResponse serialize() {
            return PB_INSTANCE;
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof CommitResponse;
        }
    }

    public static class CommitRequest
    extends Request {
        private static final Descriptors.FieldDescriptor CONNECTION_ID_DESCRIPTOR = Requests.CommitRequest.getDescriptor().findFieldByNumber(1);
        public final String connectionId;

        CommitRequest() {
            this.connectionId = null;
        }

        public CommitRequest(@JsonProperty(value="connectionId") String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        CommitResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        CommitRequest deserialize(Message genericMsg) {
            Requests.CommitRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.CommitRequest.class);
            String connectionId = null;
            if (msg.hasField(CONNECTION_ID_DESCRIPTOR)) {
                connectionId = msg.getConnectionId();
            }
            return new CommitRequest(connectionId);
        }

        @Override
        Requests.CommitRequest serialize() {
            Requests.CommitRequest.Builder builder = Requests.CommitRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.build();
        }

        public int hashCode() {
            int result = 1;
            result = CommitRequest.p(result, this.connectionId);
            return result;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof CommitRequest && Objects.equals(this.connectionId, ((CommitRequest)o).connectionId);
        }
    }

    public static class RpcMetadataResponse
    extends Response {
        private static final Descriptors.FieldDescriptor SERVER_ADDRESS_DESCRIPTOR = Responses.RpcMetadata.getDescriptor().findFieldByNumber(1);
        public final String serverAddress;
        private final ByteString serverAddressAsBytes;

        public RpcMetadataResponse() {
            this.serverAddress = null;
            this.serverAddressAsBytes = null;
        }

        public RpcMetadataResponse(@JsonProperty(value="serverAddress") String serverAddress) {
            this.serverAddress = serverAddress;
            this.serverAddressAsBytes = UnsafeByteOperations.unsafeWrap(serverAddress.getBytes(StandardCharsets.UTF_8));
        }

        @Override
        RpcMetadataResponse deserialize(Message genericMsg) {
            Responses.RpcMetadata msg = ProtobufService.castProtobufMessage(genericMsg, Responses.RpcMetadata.class);
            return RpcMetadataResponse.fromProto(msg);
        }

        @Override
        Responses.RpcMetadata serialize() {
            return Responses.RpcMetadata.newBuilder().setServerAddressBytes(this.serverAddressAsBytes).build();
        }

        static RpcMetadataResponse fromProto(Responses.RpcMetadata msg) {
            String serverAddress = null;
            if (msg.hasField(SERVER_ADDRESS_DESCRIPTOR)) {
                serverAddress = msg.getServerAddress();
            }
            return new RpcMetadataResponse(serverAddress);
        }

        public int hashCode() {
            int result = 1;
            result = RpcMetadataResponse.p(result, this.serverAddress);
            return result;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof RpcMetadataResponse && Objects.equals(this.serverAddress, ((RpcMetadataResponse)o).serverAddress);
        }
    }

    public static class SyncResultsResponse
    extends Response {
        private static final Descriptors.FieldDescriptor METADATA_DESCRIPTOR = Responses.SyncResultsResponse.getDescriptor().findFieldByNumber(3);
        public boolean missingStatement = false;
        public final boolean moreResults;
        public final RpcMetadataResponse rpcMetadata;

        SyncResultsResponse() {
            this.moreResults = false;
            this.rpcMetadata = null;
        }

        public SyncResultsResponse(@JsonProperty(value="moreResults") boolean moreResults, @JsonProperty(value="missingStatement") boolean missingStatement, @JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.moreResults = moreResults;
            this.missingStatement = missingStatement;
            this.rpcMetadata = rpcMetadata;
        }

        @Override
        SyncResultsResponse deserialize(Message genericMsg) {
            Responses.SyncResultsResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.SyncResultsResponse.class);
            RpcMetadataResponse metadata = null;
            if (msg.hasField(METADATA_DESCRIPTOR)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new SyncResultsResponse(msg.getMoreResults(), msg.getMissingStatement(), metadata);
        }

        @Override
        Responses.SyncResultsResponse serialize() {
            Responses.SyncResultsResponse.Builder builder = Responses.SyncResultsResponse.newBuilder();
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            return builder.setMoreResults(this.moreResults).setMissingStatement(this.missingStatement).build();
        }

        public int hashCode() {
            int result = 1;
            result = SyncResultsResponse.p(result, this.missingStatement);
            result = SyncResultsResponse.p(result, this.moreResults);
            result = SyncResultsResponse.p(result, this.rpcMetadata);
            return result;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof SyncResultsResponse && this.missingStatement == ((SyncResultsResponse)o).missingStatement && this.moreResults == ((SyncResultsResponse)o).moreResults && Objects.equals(this.rpcMetadata, ((SyncResultsResponse)o).rpcMetadata);
        }
    }

    public static class SyncResultsRequest
    extends Request {
        private static final Descriptors.FieldDescriptor CONNECTION_ID_DESCRIPTOR = Requests.SyncResultsRequest.getDescriptor().findFieldByNumber(1);
        private static final Descriptors.FieldDescriptor STATEMENT_ID_DESCRIPTOR = Requests.SyncResultsRequest.getDescriptor().findFieldByNumber(2);
        private static final Descriptors.FieldDescriptor STATE_DESCRIPTOR = Requests.SyncResultsRequest.getDescriptor().findFieldByNumber(3);
        private static final Descriptors.FieldDescriptor OFFSET_DESCRIPTOR = Requests.SyncResultsRequest.getDescriptor().findFieldByNumber(4);
        public final String connectionId;
        public final int statementId;
        public final QueryState state;
        public final long offset;

        SyncResultsRequest() {
            this.connectionId = null;
            this.statementId = 0;
            this.state = null;
            this.offset = 0L;
        }

        public SyncResultsRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId, @JsonProperty(value="state") QueryState state, @JsonProperty(value="offset") long offset) {
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.state = state;
            this.offset = offset;
        }

        @Override
        SyncResultsResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        Request deserialize(Message genericMsg) {
            Requests.SyncResultsRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.SyncResultsRequest.class);
            String connectionId = null;
            if (msg.hasField(CONNECTION_ID_DESCRIPTOR)) {
                connectionId = msg.getConnectionId();
            }
            int statementId = 0;
            if (msg.hasField(STATEMENT_ID_DESCRIPTOR)) {
                statementId = msg.getStatementId();
            }
            Common.QueryState state = null;
            if (msg.hasField(STATE_DESCRIPTOR)) {
                state = msg.getState();
            }
            long offset = 0L;
            if (msg.hasField(OFFSET_DESCRIPTOR)) {
                offset = msg.getOffset();
            }
            return new SyncResultsRequest(connectionId, statementId, null == state ? null : QueryState.fromProto(msg.getState()), offset);
        }

        @Override
        Requests.SyncResultsRequest serialize() {
            Requests.SyncResultsRequest.Builder builder = Requests.SyncResultsRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.state) {
                builder.setState(this.state.toProto());
            }
            builder.setStatementId(this.statementId);
            builder.setOffset(this.offset);
            return builder.build();
        }

        public int hashCode() {
            int result = 1;
            result = SyncResultsRequest.p(result, this.connectionId);
            result = SyncResultsRequest.p(result, this.offset);
            result = SyncResultsRequest.p(result, this.state);
            result = SyncResultsRequest.p(result, this.statementId);
            return result;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof SyncResultsRequest && this.statementId == ((SyncResultsRequest)o).statementId && this.offset == ((SyncResultsRequest)o).offset && Objects.equals(this.connectionId, ((SyncResultsRequest)o).connectionId) && Objects.equals(this.state, ((SyncResultsRequest)o).state);
        }
    }

    public static class ErrorResponse
    extends Response {
        private static final Descriptors.FieldDescriptor ERROR_MESSAGE_DESCRIPTOR = Responses.ErrorResponse.getDescriptor().findFieldByNumber(2);
        private static final Descriptors.FieldDescriptor SQL_DESCRIPTOR = Responses.ErrorResponse.getDescriptor().findFieldByNumber(5);
        private static final Descriptors.FieldDescriptor SEVERITY_DESCRIPTOR = Responses.ErrorResponse.getDescriptor().findFieldByNumber(3);
        private static final Descriptors.FieldDescriptor METADATA_DESCRIPTOR = Responses.ErrorResponse.getDescriptor().findFieldByNumber(6);
        public static final int UNKNOWN_ERROR_CODE = -1;
        public static final int MISSING_CONNECTION_ERROR_CODE = 1;
        public static final int UNAUTHORIZED_ERROR_CODE = 2;
        public static final String UNKNOWN_SQL_STATE = "00000";
        public static final String UNAUTHORIZED_SQL_STATE = "00002";
        public final List<String> exceptions;
        public final String errorMessage;
        public final int errorCode;
        public final String sqlState;
        public final AvaticaSeverity severity;
        public final RpcMetadataResponse rpcMetadata;

        ErrorResponse() {
            this.exceptions = Collections.singletonList("Unhandled exception");
            this.errorMessage = "Unknown message";
            this.errorCode = -1;
            this.sqlState = UNKNOWN_SQL_STATE;
            this.severity = AvaticaSeverity.UNKNOWN;
            this.rpcMetadata = null;
        }

        @JsonCreator
        public ErrorResponse(@JsonProperty(value="exceptions") List<String> exceptions, @JsonProperty(value="errorMessage") String errorMessage, @JsonProperty(value="errorCode") int errorCode, @JsonProperty(value="sqlState") String sqlState, @JsonProperty(value="severity") AvaticaSeverity severity, @JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.exceptions = exceptions;
            this.errorMessage = errorMessage;
            this.errorCode = errorCode;
            this.sqlState = sqlState;
            this.severity = severity;
            this.rpcMetadata = rpcMetadata;
        }

        protected ErrorResponse(Exception e, String errorMessage, int code, String sqlState, AvaticaSeverity severity, RpcMetadataResponse rpcMetadata) {
            this(errorMessage, code, sqlState, severity, ErrorResponse.toStackTraces(e), rpcMetadata);
        }

        protected ErrorResponse(String errorMessage, int code, String sqlState, AvaticaSeverity severity, List<String> exceptions, RpcMetadataResponse rpcMetadata) {
            this.exceptions = exceptions;
            this.errorMessage = errorMessage;
            this.errorCode = code;
            this.sqlState = sqlState;
            this.severity = severity;
            this.rpcMetadata = rpcMetadata;
        }

        static List<String> toStackTraces(Exception e) {
            ArrayList<String> stackTraces = new ArrayList<String>();
            stackTraces.add(ErrorResponse.toString(e));
            if (e instanceof SQLException) {
                for (SQLException next = ((SQLException)e).getNextException(); null != next; next = next.getNextException()) {
                    stackTraces.add(ErrorResponse.toString(next));
                }
            }
            return stackTraces;
        }

        static String toString(Exception e) {
            Objects.requireNonNull(e);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            return sw.toString();
        }

        @Override
        ErrorResponse deserialize(Message genericMsg) {
            Responses.ErrorResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.ErrorResponse.class);
            ProtocolStringList exceptions = null;
            if (msg.getHasExceptions()) {
                exceptions = msg.getExceptionsList();
            }
            String errorMessage = null;
            if (msg.hasField(ERROR_MESSAGE_DESCRIPTOR)) {
                errorMessage = msg.getErrorMessage();
            }
            String sqlState = null;
            if (msg.hasField(SQL_DESCRIPTOR)) {
                sqlState = msg.getSqlState();
            }
            AvaticaSeverity severity = null;
            if (msg.hasField(SEVERITY_DESCRIPTOR)) {
                severity = AvaticaSeverity.fromProto(msg.getSeverity());
            }
            RpcMetadataResponse metadata = null;
            if (msg.hasField(METADATA_DESCRIPTOR)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new ErrorResponse(exceptions, errorMessage, msg.getErrorCode(), sqlState, severity, metadata);
        }

        @Override
        public Responses.ErrorResponse serialize() {
            Responses.ErrorResponse.Builder builder = Responses.ErrorResponse.newBuilder();
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            if (null != this.exceptions) {
                builder.setHasExceptions(true);
                builder.addAllExceptions(this.exceptions);
            } else {
                builder.setHasExceptions(false);
            }
            if (null != this.errorMessage) {
                builder.setErrorMessage(this.errorMessage);
            }
            if (null != this.sqlState) {
                builder.setSqlState(this.sqlState);
            }
            if (null != this.severity) {
                builder.setSeverity(this.severity.toProto());
            }
            return builder.setErrorCode(this.errorCode).build();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append("ErrorResponse[errorCode=").append(this.errorCode).append(", sqlState=").append(this.sqlState).append(", severity=").append((Object)this.severity).append(", errorMessage=").append(this.errorMessage).append(", exceptions=").append(this.exceptions);
            return sb.toString();
        }

        public int hashCode() {
            int result = 1;
            result = ErrorResponse.p(result, this.exceptions);
            result = ErrorResponse.p(result, this.errorMessage);
            result = ErrorResponse.p(result, this.errorCode);
            result = ErrorResponse.p(result, this.sqlState);
            result = ErrorResponse.p(result, (Object)this.severity);
            result = ErrorResponse.p(result, this.rpcMetadata);
            return result;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof ErrorResponse && this.errorCode == ((ErrorResponse)o).errorCode && this.severity == ((ErrorResponse)o).severity && Objects.equals(this.exceptions, ((ErrorResponse)o).exceptions) && Objects.equals(this.errorMessage, ((ErrorResponse)o).errorMessage) && Objects.equals(this.sqlState, ((ErrorResponse)o).sqlState) && Objects.equals(this.rpcMetadata, ((ErrorResponse)o).rpcMetadata);
        }

        public AvaticaClientRuntimeException toException() {
            return new AvaticaClientRuntimeException("Remote driver error: " + this.errorMessage, this.errorCode, this.sqlState, this.severity, this.exceptions, this.rpcMetadata);
        }
    }

    public static class DatabasePropertyResponse
    extends Response {
        private static final Descriptors.FieldDescriptor METADATA_DESCRIPTOR = Responses.DatabasePropertyResponse.getDescriptor().findFieldByNumber(2);
        public final Map<Meta.DatabaseProperty, Object> map;
        public final RpcMetadataResponse rpcMetadata;

        DatabasePropertyResponse() {
            this.map = null;
            this.rpcMetadata = null;
        }

        @JsonCreator
        public DatabasePropertyResponse(@JsonProperty(value="map") Map<Meta.DatabaseProperty, Object> map, @JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.map = map;
            this.rpcMetadata = rpcMetadata;
        }

        @Override
        DatabasePropertyResponse deserialize(Message genericMsg) {
            Responses.DatabasePropertyResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.DatabasePropertyResponse.class);
            HashMap<Meta.DatabaseProperty, Object> properties = new HashMap<Meta.DatabaseProperty, Object>();
            for (Responses.DatabasePropertyElement property : msg.getPropsList()) {
                Object obj;
                Meta.DatabaseProperty dbProp = Meta.DatabaseProperty.fromProto(property.getKey());
                Common.TypedValue value = property.getValue();
                block0 : switch (dbProp) {
                    case GET_NUMERIC_FUNCTIONS: 
                    case GET_STRING_FUNCTIONS: 
                    case GET_SYSTEM_FUNCTIONS: 
                    case GET_TIME_DATE_FUNCTIONS: 
                    case GET_S_Q_L_KEYWORDS: {
                        if (Common.Rep.STRING != value.getType()) {
                            throw new IllegalArgumentException("Expected STRING, but got " + value.getType());
                        }
                        obj = value.getStringValue();
                        break;
                    }
                    case GET_DEFAULT_TRANSACTION_ISOLATION: {
                        if (Common.Rep.INTEGER != value.getType()) {
                            throw new IllegalArgumentException("Expected INTEGER, but got " + value.getType());
                        }
                        obj = (int)value.getNumberValue();
                        break;
                    }
                    default: {
                        switch (value.getType()) {
                            case INTEGER: {
                                obj = Long.valueOf(value.getNumberValue()).intValue();
                                break block0;
                            }
                            case STRING: {
                                obj = value.getStringValue();
                                break block0;
                            }
                        }
                        throw new IllegalArgumentException("Unhandled value type, " + value.getType());
                    }
                }
                properties.put(dbProp, obj);
            }
            RpcMetadataResponse metadata = null;
            if (msg.hasField(METADATA_DESCRIPTOR)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new DatabasePropertyResponse(properties, metadata);
        }

        @Override
        Responses.DatabasePropertyResponse serialize() {
            Responses.DatabasePropertyResponse.Builder builder = Responses.DatabasePropertyResponse.newBuilder();
            if (null != this.map) {
                for (Map.Entry<Meta.DatabaseProperty, Object> entry : this.map.entrySet()) {
                    Object obj = entry.getValue();
                    Common.TypedValue.Builder valueBuilder = Common.TypedValue.newBuilder();
                    switch (entry.getKey()) {
                        case GET_NUMERIC_FUNCTIONS: 
                        case GET_STRING_FUNCTIONS: 
                        case GET_SYSTEM_FUNCTIONS: 
                        case GET_TIME_DATE_FUNCTIONS: 
                        case GET_S_Q_L_KEYWORDS: {
                            if (!(obj instanceof String)) {
                                throw new RuntimeException("Expected a String, but got " + obj.getClass());
                            }
                            valueBuilder.setType(Common.Rep.STRING).setStringValue((String)obj);
                            break;
                        }
                        case GET_DEFAULT_TRANSACTION_ISOLATION: {
                            if (!(obj instanceof Integer)) {
                                throw new RuntimeException("Expected an Integer, but got " + obj.getClass());
                            }
                            valueBuilder.setType(Common.Rep.INTEGER).setNumberValue(((Integer)obj).longValue());
                            break;
                        }
                        default: {
                            if (obj instanceof Integer) {
                                valueBuilder.setType(Common.Rep.INTEGER).setNumberValue(((Integer)obj).intValue());
                                break;
                            }
                            String value = obj instanceof String ? (String)obj : obj.toString();
                            valueBuilder.setType(Common.Rep.STRING).setStringValue(value);
                        }
                    }
                    builder.addProps(Responses.DatabasePropertyElement.newBuilder().setKey(entry.getKey().toProto()).setValue(valueBuilder.build()));
                }
            }
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            return builder.build();
        }

        public int hashCode() {
            int result = 1;
            result = DatabasePropertyResponse.p(result, this.map);
            result = DatabasePropertyResponse.p(result, this.rpcMetadata);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof DatabasePropertyResponse && Objects.equals(this.map, ((DatabasePropertyResponse)o).map) && Objects.equals(this.rpcMetadata, ((DatabasePropertyResponse)o).rpcMetadata);
        }
    }

    public static class ConnectionSyncResponse
    extends Response {
        private static final Descriptors.FieldDescriptor METADATA_DESCRIPTOR = Responses.ConnectionSyncResponse.getDescriptor().findFieldByNumber(2);
        public final Meta.ConnectionProperties connProps;
        public final RpcMetadataResponse rpcMetadata;

        ConnectionSyncResponse() {
            this.connProps = null;
            this.rpcMetadata = null;
        }

        @JsonCreator
        public ConnectionSyncResponse(@JsonProperty(value="connProps") Meta.ConnectionProperties connProps, @JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.connProps = connProps;
            this.rpcMetadata = rpcMetadata;
        }

        @Override
        ConnectionSyncResponse deserialize(Message genericMsg) {
            Responses.ConnectionSyncResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.ConnectionSyncResponse.class);
            RpcMetadataResponse metadata = null;
            if (msg.hasField(METADATA_DESCRIPTOR)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new ConnectionSyncResponse(ConnectionPropertiesImpl.fromProto(msg.getConnProps()), metadata);
        }

        @Override
        Responses.ConnectionSyncResponse serialize() {
            Responses.ConnectionSyncResponse.Builder builder = Responses.ConnectionSyncResponse.newBuilder();
            if (null != this.connProps) {
                builder.setConnProps(this.connProps.toProto());
            }
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            return builder.build();
        }

        public int hashCode() {
            int result = 1;
            result = ConnectionSyncResponse.p(result, this.connProps);
            result = ConnectionSyncResponse.p(result, this.rpcMetadata);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof ConnectionSyncResponse && Objects.equals(this.connProps, ((ConnectionSyncResponse)o).connProps) && Objects.equals(this.rpcMetadata, ((ConnectionSyncResponse)o).rpcMetadata);
        }
    }

    public static class ConnectionSyncRequest
    extends Request {
        private static final Descriptors.FieldDescriptor CONNECTION_ID_DESCRIPTOR = Requests.ConnectionSyncRequest.getDescriptor().findFieldByNumber(1);
        private static final Descriptors.FieldDescriptor CONN_PROPS_DESCRIPTOR = Requests.ConnectionSyncRequest.getDescriptor().findFieldByNumber(2);
        public final String connectionId;
        public final Meta.ConnectionProperties connProps;

        ConnectionSyncRequest() {
            this.connectionId = null;
            this.connProps = null;
        }

        @JsonCreator
        public ConnectionSyncRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="connProps") Meta.ConnectionProperties connProps) {
            this.connectionId = connectionId;
            this.connProps = connProps;
        }

        @Override
        ConnectionSyncResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        ConnectionSyncRequest deserialize(Message genericMsg) {
            Requests.ConnectionSyncRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.ConnectionSyncRequest.class);
            String connectionId = null;
            if (msg.hasField(CONNECTION_ID_DESCRIPTOR)) {
                connectionId = msg.getConnectionId();
            }
            ConnectionPropertiesImpl connProps = null;
            if (msg.hasField(CONN_PROPS_DESCRIPTOR)) {
                connProps = ConnectionPropertiesImpl.fromProto(msg.getConnProps());
            }
            return new ConnectionSyncRequest(connectionId, connProps);
        }

        @Override
        Requests.ConnectionSyncRequest serialize() {
            Requests.ConnectionSyncRequest.Builder builder = Requests.ConnectionSyncRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.connProps) {
                builder.setConnProps(this.connProps.toProto());
            }
            return builder.build();
        }

        public int hashCode() {
            int result = 1;
            result = ConnectionSyncRequest.p(result, this.connProps);
            result = ConnectionSyncRequest.p(result, this.connectionId);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof ConnectionSyncRequest && Objects.equals(this.connectionId, ((ConnectionSyncRequest)o).connectionId) && Objects.equals(this.connProps, ((ConnectionSyncRequest)o).connProps);
        }
    }

    public static class CloseConnectionResponse
    extends Response {
        private static final Descriptors.FieldDescriptor METADATA_DESCRIPTOR = Responses.CloseConnectionResponse.getDescriptor().findFieldByNumber(1);
        public final RpcMetadataResponse rpcMetadata;

        public CloseConnectionResponse() {
            this.rpcMetadata = null;
        }

        @JsonCreator
        public CloseConnectionResponse(@JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.rpcMetadata = rpcMetadata;
        }

        @Override
        CloseConnectionResponse deserialize(Message genericMsg) {
            Responses.CloseConnectionResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.CloseConnectionResponse.class);
            RpcMetadataResponse metadata = null;
            if (msg.hasField(METADATA_DESCRIPTOR)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new CloseConnectionResponse(metadata);
        }

        @Override
        Responses.CloseConnectionResponse serialize() {
            Responses.CloseConnectionResponse.Builder builder = Responses.CloseConnectionResponse.newBuilder();
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            return builder.build();
        }

        public int hashCode() {
            int result = 1;
            result = CloseConnectionResponse.p(result, this.rpcMetadata);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof CloseConnectionResponse && Objects.equals(this.rpcMetadata, ((CloseConnectionResponse)o).rpcMetadata);
        }
    }

    public static class CloseConnectionRequest
    extends Request {
        private static final Descriptors.FieldDescriptor CONNECTION_ID_DESCRIPTOR = Requests.CloseConnectionRequest.getDescriptor().findFieldByNumber(1);
        public final String connectionId;

        CloseConnectionRequest() {
            this.connectionId = null;
        }

        @JsonCreator
        public CloseConnectionRequest(@JsonProperty(value="connectionId") String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        CloseConnectionResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        CloseConnectionRequest deserialize(Message genericMsg) {
            Requests.CloseConnectionRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.CloseConnectionRequest.class);
            String connectionId = null;
            if (msg.hasField(CONNECTION_ID_DESCRIPTOR)) {
                connectionId = msg.getConnectionId();
            }
            return new CloseConnectionRequest(connectionId);
        }

        @Override
        Requests.CloseConnectionRequest serialize() {
            Requests.CloseConnectionRequest.Builder builder = Requests.CloseConnectionRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.build();
        }

        public int hashCode() {
            int result = 1;
            result = CloseConnectionRequest.p(result, this.connectionId);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof CloseConnectionRequest && Objects.equals(this.connectionId, ((CloseConnectionRequest)o).connectionId);
        }
    }

    public static class OpenConnectionResponse
    extends Response {
        private static final Descriptors.FieldDescriptor METADATA_DESCRIPTOR = Responses.OpenConnectionResponse.getDescriptor().findFieldByNumber(1);
        public final RpcMetadataResponse rpcMetadata;

        public OpenConnectionResponse() {
            this.rpcMetadata = null;
        }

        @JsonCreator
        public OpenConnectionResponse(@JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.rpcMetadata = rpcMetadata;
        }

        @Override
        OpenConnectionResponse deserialize(Message genericMsg) {
            Responses.OpenConnectionResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.OpenConnectionResponse.class);
            RpcMetadataResponse metadata = null;
            if (msg.hasField(METADATA_DESCRIPTOR)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new OpenConnectionResponse(metadata);
        }

        @Override
        Responses.OpenConnectionResponse serialize() {
            Responses.OpenConnectionResponse.Builder builder = Responses.OpenConnectionResponse.newBuilder();
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            return builder.build();
        }

        public int hashCode() {
            int result = 1;
            result = OpenConnectionResponse.p(result, this.rpcMetadata);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof OpenConnectionResponse && Objects.equals(this.rpcMetadata, ((OpenConnectionResponse)o).rpcMetadata);
        }
    }

    public static class OpenConnectionRequest
    extends Request {
        private static final Descriptors.FieldDescriptor CONNECTION_ID_DESCRIPTOR = Requests.OpenConnectionRequest.getDescriptor().findFieldByNumber(1);
        public final String connectionId;
        public final Map<String, String> info;

        public OpenConnectionRequest() {
            this.connectionId = null;
            this.info = null;
        }

        @JsonCreator
        public OpenConnectionRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="info") Map<String, String> info) {
            this.connectionId = connectionId;
            this.info = info;
        }

        @Override
        OpenConnectionResponse accept(Service service) {
            return service.apply(this);
        }

        public static Map<String, String> serializeProperties(Properties props) {
            HashMap<String, String> infoAsString = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                if (BuiltInConnectionProperty.isLocalProperty(entry.getKey())) continue;
                infoAsString.put(entry.getKey().toString(), entry.getValue().toString());
            }
            return infoAsString;
        }

        @Override
        Request deserialize(Message genericMsg) {
            Map<String, String> info;
            Requests.OpenConnectionRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.OpenConnectionRequest.class);
            String connectionId = null;
            if (msg.hasField(CONNECTION_ID_DESCRIPTOR)) {
                connectionId = msg.getConnectionId();
            }
            if ((info = msg.getInfoMap()).isEmpty()) {
                info = null;
            }
            return new OpenConnectionRequest(connectionId, info);
        }

        @Override
        Message serialize() {
            Requests.OpenConnectionRequest.Builder builder = Requests.OpenConnectionRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.info) {
                builder.putAllInfo(this.info);
            }
            return builder.build();
        }

        public int hashCode() {
            int result = 1;
            result = OpenConnectionRequest.p(result, this.connectionId);
            result = OpenConnectionRequest.p(result, this.info);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof OpenConnectionRequest && Objects.equals(this.connectionId, ((OpenConnectionRequest)o).connectionId) && Objects.equals(this.info, ((OpenConnectionRequest)o).info);
        }
    }

    public static class CloseStatementResponse
    extends Response {
        private static final Descriptors.FieldDescriptor CONNECTION_ID_DESCRIPTOR = Responses.CloseStatementResponse.getDescriptor().findFieldByNumber(1);
        public final RpcMetadataResponse rpcMetadata;

        public CloseStatementResponse() {
            this.rpcMetadata = null;
        }

        @JsonCreator
        public CloseStatementResponse(@JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.rpcMetadata = rpcMetadata;
        }

        @Override
        CloseStatementResponse deserialize(Message genericMsg) {
            Responses.CloseStatementResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.CloseStatementResponse.class);
            RpcMetadataResponse metadata = null;
            if (msg.hasField(CONNECTION_ID_DESCRIPTOR)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new CloseStatementResponse(metadata);
        }

        @Override
        Responses.CloseStatementResponse serialize() {
            Responses.CloseStatementResponse.Builder builder = Responses.CloseStatementResponse.newBuilder();
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            return builder.build();
        }

        public int hashCode() {
            int result = 1;
            result = CloseStatementResponse.p(result, this.rpcMetadata);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof CloseStatementResponse && Objects.equals(this.rpcMetadata, ((CloseStatementResponse)o).rpcMetadata);
        }
    }

    public static class CloseStatementRequest
    extends Request {
        private static final Descriptors.FieldDescriptor CONNECTION_ID_DESCRIPTOR = Requests.CloseStatementRequest.getDescriptor().findFieldByNumber(1);
        public final String connectionId;
        public final int statementId;

        CloseStatementRequest() {
            this.connectionId = null;
            this.statementId = 0;
        }

        @JsonCreator
        public CloseStatementRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId) {
            this.connectionId = connectionId;
            this.statementId = statementId;
        }

        @Override
        CloseStatementResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        CloseStatementRequest deserialize(Message genericMsg) {
            Requests.CloseStatementRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.CloseStatementRequest.class);
            String connectionId = null;
            if (msg.hasField(CONNECTION_ID_DESCRIPTOR)) {
                connectionId = msg.getConnectionId();
            }
            return new CloseStatementRequest(connectionId, msg.getStatementId());
        }

        @Override
        Requests.CloseStatementRequest serialize() {
            Requests.CloseStatementRequest.Builder builder = Requests.CloseStatementRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.setStatementId(this.statementId).build();
        }

        public int hashCode() {
            int result = 1;
            result = CloseStatementRequest.p(result, this.connectionId);
            result = CloseStatementRequest.p(result, this.statementId);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof CloseStatementRequest && this.statementId == ((CloseStatementRequest)o).statementId && Objects.equals(this.connectionId, ((CloseStatementRequest)o).connectionId);
        }
    }

    public static class CreateStatementResponse
    extends Response {
        private static final Descriptors.FieldDescriptor CONNECTION_ID_DESCRIPTOR = Responses.CreateStatementResponse.getDescriptor().findFieldByNumber(1);
        private static final Descriptors.FieldDescriptor METADATA_DESCRIPTOR = Responses.CreateStatementResponse.getDescriptor().findFieldByNumber(3);
        public final String connectionId;
        public final int statementId;
        public final RpcMetadataResponse rpcMetadata;

        CreateStatementResponse() {
            this.connectionId = null;
            this.statementId = 0;
            this.rpcMetadata = null;
        }

        @JsonCreator
        public CreateStatementResponse(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId, @JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.rpcMetadata = rpcMetadata;
        }

        @Override
        CreateStatementResponse deserialize(Message genericMsg) {
            Responses.CreateStatementResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.CreateStatementResponse.class);
            String connectionId = null;
            if (msg.hasField(CONNECTION_ID_DESCRIPTOR)) {
                connectionId = msg.getConnectionId();
            }
            RpcMetadataResponse metadata = null;
            if (msg.hasField(METADATA_DESCRIPTOR)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new CreateStatementResponse(connectionId, msg.getStatementId(), metadata);
        }

        @Override
        Responses.CreateStatementResponse serialize() {
            Responses.CreateStatementResponse.Builder builder = Responses.CreateStatementResponse.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            builder.setStatementId(this.statementId);
            return builder.build();
        }

        public int hashCode() {
            int result = 1;
            result = CreateStatementResponse.p(result, this.connectionId);
            result = CreateStatementResponse.p(result, this.statementId);
            result = CreateStatementResponse.p(result, this.rpcMetadata);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof CreateStatementResponse && this.statementId == ((CreateStatementResponse)o).statementId && Objects.equals(this.connectionId, ((CreateStatementResponse)o).connectionId) && Objects.equals(this.rpcMetadata, ((CreateStatementResponse)o).rpcMetadata);
        }
    }

    public static class CreateStatementRequest
    extends Request {
        private static final Descriptors.FieldDescriptor CONNECTION_ID_DESCRIPTOR = Requests.CreateStatementRequest.getDescriptor().findFieldByNumber(1);
        public final String connectionId;

        CreateStatementRequest() {
            this.connectionId = null;
        }

        @JsonCreator
        public CreateStatementRequest(@JsonProperty(value="signature") String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        CreateStatementResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        CreateStatementRequest deserialize(Message genericMsg) {
            Requests.CreateStatementRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.CreateStatementRequest.class);
            String connectionId = null;
            if (msg.hasField(CONNECTION_ID_DESCRIPTOR)) {
                connectionId = msg.getConnectionId();
            }
            return new CreateStatementRequest(connectionId);
        }

        @Override
        Requests.CreateStatementRequest serialize() {
            Requests.CreateStatementRequest.Builder builder = Requests.CreateStatementRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.build();
        }

        public int hashCode() {
            int result = 1;
            result = CreateStatementRequest.p(result, this.connectionId);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof CreateStatementRequest && Objects.equals(this.connectionId, ((CreateStatementRequest)o).connectionId);
        }
    }

    public static class FetchResponse
    extends Response {
        private static final Descriptors.FieldDescriptor METADATA_DESCRIPTOR = Responses.FetchResponse.getDescriptor().findFieldByNumber(4);
        public final Meta.Frame frame;
        public boolean missingStatement = false;
        public boolean missingResults = false;
        public final RpcMetadataResponse rpcMetadata;

        FetchResponse() {
            this.frame = null;
            this.rpcMetadata = null;
        }

        @JsonCreator
        public FetchResponse(@JsonProperty(value="frame") Meta.Frame frame, @JsonProperty(value="missingStatement") boolean missingStatement, @JsonProperty(value="missingResults") boolean missingResults, @JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.frame = frame;
            this.missingStatement = missingStatement;
            this.missingResults = missingResults;
            this.rpcMetadata = rpcMetadata;
        }

        @Override
        FetchResponse deserialize(Message genericMsg) {
            Responses.FetchResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.FetchResponse.class);
            RpcMetadataResponse metadata = null;
            if (msg.hasField(METADATA_DESCRIPTOR)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new FetchResponse(Meta.Frame.fromProto(msg.getFrame()), msg.getMissingStatement(), msg.getMissingResults(), metadata);
        }

        @Override
        Responses.FetchResponse serialize() {
            Responses.FetchResponse.Builder builder = Responses.FetchResponse.newBuilder();
            if (null != this.frame) {
                builder.setFrame(this.frame.toProto());
            }
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            return builder.setMissingStatement(this.missingStatement).setMissingResults(this.missingResults).build();
        }

        public int hashCode() {
            int result = 1;
            result = FetchResponse.p(result, this.frame);
            result = FetchResponse.p(result, this.rpcMetadata);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof FetchResponse && Objects.equals(this.frame, ((FetchResponse)o).frame) && Objects.equals(this.rpcMetadata, ((FetchResponse)o).rpcMetadata) && this.missingStatement == ((FetchResponse)o).missingStatement;
        }
    }

    public static class FetchRequest
    extends Request {
        private static final Descriptors.FieldDescriptor CONNECTION_ID_DESCRIPTOR = Requests.FetchRequest.getDescriptor().findFieldByNumber(1);
        private static final Descriptors.FieldDescriptor FRAME_MAX_SIZE_DESCRIPTOR = Requests.FetchRequest.getDescriptor().findFieldByNumber(5);
        public final String connectionId;
        public final int statementId;
        public final long offset;
        public final int fetchMaxRowCount;

        FetchRequest() {
            this.connectionId = null;
            this.statementId = 0;
            this.offset = 0L;
            this.fetchMaxRowCount = 0;
        }

        @JsonCreator
        public FetchRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId, @JsonProperty(value="offset") long offset, @JsonProperty(value="fetchMaxRowCount") int fetchMaxRowCount) {
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.offset = offset;
            this.fetchMaxRowCount = fetchMaxRowCount;
        }

        @Override
        FetchResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        FetchRequest deserialize(Message genericMsg) {
            Requests.FetchRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.FetchRequest.class);
            String connectionId = null;
            if (msg.hasField(CONNECTION_ID_DESCRIPTOR)) {
                connectionId = msg.getConnectionId();
            }
            int fetchMaxRowCount = msg.getFetchMaxRowCount();
            if (msg.hasField(FRAME_MAX_SIZE_DESCRIPTOR)) {
                fetchMaxRowCount = msg.getFrameMaxSize();
            }
            return new FetchRequest(connectionId, msg.getStatementId(), msg.getOffset(), fetchMaxRowCount);
        }

        @Override
        Requests.FetchRequest serialize() {
            Requests.FetchRequest.Builder builder = Requests.FetchRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            builder.setStatementId(this.statementId);
            builder.setOffset(this.offset);
            builder.setFetchMaxRowCount(this.fetchMaxRowCount).setFrameMaxSize(this.fetchMaxRowCount);
            return builder.build();
        }

        public int hashCode() {
            int result = 1;
            result = FetchRequest.p(result, this.connectionId);
            result = FetchRequest.p(result, this.fetchMaxRowCount);
            result = FetchRequest.p(result, this.offset);
            result = FetchRequest.p(result, this.statementId);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof FetchRequest && this.statementId == ((FetchRequest)o).statementId && this.offset == ((FetchRequest)o).offset && this.fetchMaxRowCount == ((FetchRequest)o).fetchMaxRowCount && Objects.equals(this.connectionId, ((FetchRequest)o).connectionId);
        }
    }

    public static class PrepareResponse
    extends Response {
        private static final Descriptors.FieldDescriptor METADATA_DESCRIPTOR = Responses.PrepareResponse.getDescriptor().findFieldByNumber(2);
        public final Meta.StatementHandle statement;
        public final RpcMetadataResponse rpcMetadata;

        PrepareResponse() {
            this.statement = null;
            this.rpcMetadata = null;
        }

        @JsonCreator
        public PrepareResponse(@JsonProperty(value="statement") Meta.StatementHandle statement, @JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.statement = statement;
            this.rpcMetadata = rpcMetadata;
        }

        @Override
        PrepareResponse deserialize(Message genericMsg) {
            Responses.PrepareResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.PrepareResponse.class);
            RpcMetadataResponse metadata = null;
            if (msg.hasField(METADATA_DESCRIPTOR)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new PrepareResponse(Meta.StatementHandle.fromProto(msg.getStatement()), metadata);
        }

        @Override
        Responses.PrepareResponse serialize() {
            Responses.PrepareResponse.Builder builder = Responses.PrepareResponse.newBuilder();
            if (null != this.statement) {
                builder.setStatement(this.statement.toProto());
            }
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            return builder.build();
        }

        public int hashCode() {
            int result = 1;
            result = PrepareResponse.p(result, this.statement);
            result = PrepareResponse.p(result, this.rpcMetadata);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof PrepareResponse && Objects.equals(this.statement, ((PrepareResponse)o).statement) && Objects.equals(this.rpcMetadata, ((PrepareResponse)o).rpcMetadata);
        }
    }

    public static class PrepareRequest
    extends Request {
        private static final Descriptors.FieldDescriptor CONNECTION_ID_DESCRIPTOR = Requests.PrepareRequest.getDescriptor().findFieldByNumber(1);
        private static final Descriptors.FieldDescriptor SQL_DESCRIPTOR = Requests.PrepareRequest.getDescriptor().findFieldByNumber(2);
        private static final Descriptors.FieldDescriptor MAX_ROWS_TOTAL_DESCRIPTOR = Requests.PrepareRequest.getDescriptor().findFieldByNumber(4);
        public final String connectionId;
        public final String sql;
        public final long maxRowCount;

        PrepareRequest() {
            this.connectionId = null;
            this.sql = null;
            this.maxRowCount = 0L;
        }

        @JsonCreator
        public PrepareRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="sql") String sql, @JsonProperty(value="maxRowCount") long maxRowCount) {
            this.connectionId = connectionId;
            this.sql = sql;
            this.maxRowCount = maxRowCount;
        }

        @Override
        PrepareResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        PrepareRequest deserialize(Message genericMsg) {
            Requests.PrepareRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.PrepareRequest.class);
            String connectionId = null;
            if (msg.hasField(CONNECTION_ID_DESCRIPTOR)) {
                connectionId = msg.getConnectionId();
            }
            String sql = null;
            if (msg.hasField(SQL_DESCRIPTOR)) {
                sql = msg.getSql();
            }
            long totalRowsForStatement = msg.getMaxRowCount();
            if (msg.hasField(MAX_ROWS_TOTAL_DESCRIPTOR)) {
                totalRowsForStatement = msg.getMaxRowsTotal();
            }
            return new PrepareRequest(connectionId, sql, totalRowsForStatement);
        }

        @Override
        Requests.PrepareRequest serialize() {
            Requests.PrepareRequest.Builder builder = Requests.PrepareRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.sql) {
                builder.setSql(this.sql);
            }
            return builder.setMaxRowCount(this.maxRowCount).setMaxRowsTotal(this.maxRowCount).build();
        }

        public int hashCode() {
            int result = 1;
            result = PrepareRequest.p(result, this.connectionId);
            result = PrepareRequest.p(result, this.maxRowCount);
            result = PrepareRequest.p(result, this.sql);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof PrepareRequest && this.maxRowCount == ((PrepareRequest)o).maxRowCount && Objects.equals(this.connectionId, ((PrepareRequest)o).connectionId) && Objects.equals(this.sql, ((PrepareRequest)o).sql);
        }
    }

    public static class ExecuteResponse
    extends Response {
        private static final Descriptors.FieldDescriptor METADATA_DESCRIPTOR = Responses.ExecuteResponse.getDescriptor().findFieldByNumber(3);
        public final List<ResultSetResponse> results;
        public boolean missingStatement = false;
        public final RpcMetadataResponse rpcMetadata;

        ExecuteResponse() {
            this.results = null;
            this.rpcMetadata = null;
        }

        @JsonCreator
        public ExecuteResponse(@JsonProperty(value="resultSets") List<ResultSetResponse> results, @JsonProperty(value="missingStatement") boolean missingStatement, @JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.results = results;
            this.missingStatement = missingStatement;
            this.rpcMetadata = rpcMetadata;
        }

        @Override
        ExecuteResponse deserialize(Message genericMsg) {
            Responses.ExecuteResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.ExecuteResponse.class);
            List<Responses.ResultSetResponse> msgResults = msg.getResultsList();
            ArrayList<ResultSetResponse> copiedResults = new ArrayList<ResultSetResponse>(msgResults.size());
            for (Responses.ResultSetResponse msgResult : msgResults) {
                copiedResults.add(ResultSetResponse.fromProto(msgResult));
            }
            RpcMetadataResponse metadata = null;
            if (msg.hasField(METADATA_DESCRIPTOR)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new ExecuteResponse(copiedResults, msg.getMissingStatement(), metadata);
        }

        @Override
        Responses.ExecuteResponse serialize() {
            Responses.ExecuteResponse.Builder builder = Responses.ExecuteResponse.newBuilder();
            if (null != this.results) {
                for (ResultSetResponse result : this.results) {
                    builder.addResults(result.serialize());
                }
            }
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            return builder.setMissingStatement(this.missingStatement).build();
        }

        public int hashCode() {
            int result = 1;
            result = ExecuteResponse.p(result, this.results);
            result = ExecuteResponse.p(result, this.rpcMetadata);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof ExecuteResponse && Objects.equals(this.results, ((ExecuteResponse)o).results) && Objects.equals(this.rpcMetadata, ((ExecuteResponse)o).rpcMetadata);
        }
    }

    public static class ExecuteRequest
    extends Request {
        private static final Descriptors.FieldDescriptor STATEMENT_HANDLE_DESCRIPTOR = Requests.ExecuteRequest.getDescriptor().findFieldByNumber(1);
        private static final Descriptors.FieldDescriptor DEPRECATED_FIRST_FRAME_MAX_SIZE_DESCRIPTOR = Requests.ExecuteRequest.getDescriptor().findFieldByNumber(3);
        private static final Descriptors.FieldDescriptor FIRST_FRAME_MAX_SIZE_DESCRIPTOR = Requests.ExecuteRequest.getDescriptor().findFieldByNumber(5);
        public final Meta.StatementHandle statementHandle;
        public final List<TypedValue> parameterValues;
        public final int maxRowCount;

        ExecuteRequest() {
            this.statementHandle = null;
            this.parameterValues = null;
            this.maxRowCount = 0;
        }

        @JsonCreator
        public ExecuteRequest(@JsonProperty(value="statementHandle") Meta.StatementHandle statementHandle, @JsonProperty(value="parameterValues") List<TypedValue> parameterValues, @JsonProperty(value="maxRowCount") int maxRowCount) {
            this.statementHandle = statementHandle;
            this.parameterValues = parameterValues;
            this.maxRowCount = maxRowCount;
        }

        @Override
        ExecuteResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        ExecuteRequest deserialize(Message genericMsg) {
            Requests.ExecuteRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.ExecuteRequest.class);
            Meta.StatementHandle statementHandle = null;
            if (msg.hasField(STATEMENT_HANDLE_DESCRIPTOR)) {
                statementHandle = Meta.StatementHandle.fromProto(msg.getStatementHandle());
            }
            ArrayList<TypedValue> values = null;
            if (msg.getHasParameterValues()) {
                values = new ArrayList<TypedValue>(msg.getParameterValuesCount());
                for (Common.TypedValue valueProto : msg.getParameterValuesList()) {
                    if (TypedValue.PROTO_IMPLICIT_NULL.equals(valueProto)) {
                        values.add(null);
                        continue;
                    }
                    values.add(TypedValue.fromProto(valueProto));
                }
            }
            int maxFrameSize = 0;
            if (msg.hasField(FIRST_FRAME_MAX_SIZE_DESCRIPTOR)) {
                maxFrameSize = msg.getFirstFrameMaxSize();
            } else if (msg.hasField(DEPRECATED_FIRST_FRAME_MAX_SIZE_DESCRIPTOR)) {
                maxFrameSize = (int)msg.getDeprecatedFirstFrameMaxSize();
            }
            return new ExecuteRequest(statementHandle, values, maxFrameSize);
        }

        @Override
        Requests.ExecuteRequest serialize() {
            Requests.ExecuteRequest.Builder builder = Requests.ExecuteRequest.newBuilder();
            if (null != this.statementHandle) {
                builder.setStatementHandle(this.statementHandle.toProto());
            }
            if (null != this.parameterValues) {
                builder.setHasParameterValues(true);
                for (TypedValue paramValue : this.parameterValues) {
                    if (paramValue == null) {
                        builder.addParameterValues(TypedValue.PROTO_IMPLICIT_NULL);
                        continue;
                    }
                    builder.addParameterValues(paramValue.toProto());
                }
            } else {
                builder.setHasParameterValues(false);
            }
            builder.setDeprecatedFirstFrameMaxSize(this.maxRowCount);
            builder.setFirstFrameMaxSize(this.maxRowCount);
            return builder.build();
        }

        public int hashCode() {
            int result = 1;
            result = ExecuteRequest.p(result, this.statementHandle);
            result = ExecuteRequest.p(result, this.parameterValues);
            result = ExecuteRequest.p(result, this.maxRowCount);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof ExecuteRequest && this.maxRowCount == ((ExecuteRequest)o).maxRowCount && Objects.equals(this.statementHandle, ((ExecuteRequest)o).statementHandle) && Objects.equals(this.parameterValues, ((ExecuteRequest)o).parameterValues);
        }
    }

    public static class PrepareAndExecuteRequest
    extends Request {
        private static final Descriptors.FieldDescriptor CONNECTION_ID_DESCRIPTOR = Requests.PrepareAndExecuteRequest.getDescriptor().findFieldByNumber(1);
        private static final Descriptors.FieldDescriptor SQL_DESCRIPTOR = Requests.PrepareAndExecuteRequest.getDescriptor().findFieldByNumber(2);
        private static final Descriptors.FieldDescriptor MAX_ROWS_TOTAL_DESCRIPTOR = Requests.PrepareAndExecuteRequest.getDescriptor().findFieldByNumber(5);
        private static final Descriptors.FieldDescriptor FIRST_FRAME_MAX_SIZE_DESCRIPTOR = Requests.PrepareAndExecuteRequest.getDescriptor().findFieldByNumber(6);
        public final String connectionId;
        public final String sql;
        public final long maxRowCount;
        public final int maxRowsInFirstFrame;
        public final int statementId;

        PrepareAndExecuteRequest() {
            this.connectionId = null;
            this.sql = null;
            this.maxRowCount = 0L;
            this.maxRowsInFirstFrame = 0;
            this.statementId = 0;
        }

        public PrepareAndExecuteRequest(String connectionId, int statementId, String sql, long maxRowCount) {
            this(connectionId, statementId, sql, maxRowCount, AvaticaUtils.toSaturatedInt(maxRowCount));
        }

        @JsonCreator
        public PrepareAndExecuteRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId, @JsonProperty(value="sql") String sql, @JsonProperty(value="maxRowsTotal") long maxRowCount, @JsonProperty(value="maxRowsInFirstFrame") int maxRowsInFirstFrame) {
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.sql = sql;
            this.maxRowCount = maxRowCount;
            this.maxRowsInFirstFrame = maxRowsInFirstFrame;
        }

        @Override
        ExecuteResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        PrepareAndExecuteRequest deserialize(Message genericMsg) {
            Requests.PrepareAndExecuteRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.PrepareAndExecuteRequest.class);
            String connectionId = null;
            if (msg.hasField(CONNECTION_ID_DESCRIPTOR)) {
                connectionId = msg.getConnectionId();
            }
            String sql = null;
            if (msg.hasField(SQL_DESCRIPTOR)) {
                sql = msg.getSql();
            }
            long maxRowsTotal = msg.getMaxRowCount();
            if (msg.hasField(MAX_ROWS_TOTAL_DESCRIPTOR)) {
                maxRowsTotal = msg.getMaxRowsTotal();
            }
            int maxRowsInFirstFrame = (int)maxRowsTotal;
            if (msg.hasField(FIRST_FRAME_MAX_SIZE_DESCRIPTOR)) {
                maxRowsInFirstFrame = msg.getFirstFrameMaxSize();
            }
            return new PrepareAndExecuteRequest(connectionId, msg.getStatementId(), sql, maxRowsTotal, maxRowsInFirstFrame);
        }

        @Override
        Requests.PrepareAndExecuteRequest serialize() {
            Requests.PrepareAndExecuteRequest.Builder builder = Requests.PrepareAndExecuteRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.sql) {
                builder.setSql(this.sql);
            }
            builder.setStatementId(this.statementId);
            builder.setMaxRowCount(this.maxRowCount).setMaxRowsTotal(this.maxRowCount);
            builder.setFirstFrameMaxSize(this.maxRowsInFirstFrame);
            return builder.build();
        }

        public int hashCode() {
            int result = 1;
            result = PrepareAndExecuteRequest.p(result, this.connectionId);
            result = PrepareAndExecuteRequest.p(result, this.maxRowCount);
            result = PrepareAndExecuteRequest.p(result, this.maxRowsInFirstFrame);
            result = PrepareAndExecuteRequest.p(result, this.sql);
            result = PrepareAndExecuteRequest.p(result, this.statementId);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof PrepareAndExecuteRequest && this.statementId == ((PrepareAndExecuteRequest)o).statementId && this.maxRowCount == ((PrepareAndExecuteRequest)o).maxRowCount && this.maxRowsInFirstFrame == ((PrepareAndExecuteRequest)o).maxRowsInFirstFrame && Objects.equals(this.connectionId, ((PrepareAndExecuteRequest)o).connectionId) && Objects.equals(this.sql, ((PrepareAndExecuteRequest)o).sql);
        }
    }

    public static class ResultSetResponse
    extends Response {
        private static final Descriptors.FieldDescriptor CONNECTION_ID_DESCRIPTOR = Responses.ResultSetResponse.getDescriptor().findFieldByNumber(1);
        private static final Descriptors.FieldDescriptor SIGNATURE_DESCRIPTOR = Responses.ResultSetResponse.getDescriptor().findFieldByNumber(4);
        private static final Descriptors.FieldDescriptor FIRST_FRAME_DESCRIPTOR = Responses.ResultSetResponse.getDescriptor().findFieldByNumber(5);
        private static final Descriptors.FieldDescriptor METADATA_DESCRIPTOR = Responses.ResultSetResponse.getDescriptor().findFieldByNumber(7);
        public final String connectionId;
        public final int statementId;
        public final boolean ownStatement;
        public final Meta.Signature signature;
        public final Meta.Frame firstFrame;
        public final long updateCount;
        public final RpcMetadataResponse rpcMetadata;

        ResultSetResponse() {
            this.connectionId = null;
            this.statementId = 0;
            this.ownStatement = false;
            this.signature = null;
            this.firstFrame = null;
            this.updateCount = 0L;
            this.rpcMetadata = null;
        }

        @JsonCreator
        public ResultSetResponse(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId, @JsonProperty(value="ownStatement") boolean ownStatement, @JsonProperty(value="signature") Meta.Signature signature, @JsonProperty(value="firstFrame") Meta.Frame firstFrame, @JsonProperty(value="updateCount") long updateCount, @JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.ownStatement = ownStatement;
            this.signature = signature;
            this.firstFrame = firstFrame;
            this.updateCount = updateCount;
            this.rpcMetadata = rpcMetadata;
        }

        @Override
        ResultSetResponse deserialize(Message genericMsg) {
            Responses.ResultSetResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.ResultSetResponse.class);
            return ResultSetResponse.fromProto(msg);
        }

        static ResultSetResponse fromProto(Responses.ResultSetResponse msg) {
            String connectionId = null;
            if (msg.hasField(CONNECTION_ID_DESCRIPTOR)) {
                connectionId = msg.getConnectionId();
            }
            Meta.Signature signature = null;
            if (msg.hasField(SIGNATURE_DESCRIPTOR)) {
                signature = Meta.Signature.fromProto(msg.getSignature());
            }
            Meta.Frame frame = null;
            if (msg.hasField(FIRST_FRAME_DESCRIPTOR)) {
                frame = Meta.Frame.fromProto(msg.getFirstFrame());
            }
            RpcMetadataResponse metadata = null;
            if (msg.hasField(METADATA_DESCRIPTOR)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new ResultSetResponse(connectionId, msg.getStatementId(), msg.getOwnStatement(), signature, frame, msg.getUpdateCount(), metadata);
        }

        @Override
        Responses.ResultSetResponse serialize() {
            Responses.ResultSetResponse.Builder builder = Responses.ResultSetResponse.newBuilder();
            builder.setStatementId(this.statementId).setOwnStatement(this.ownStatement).setUpdateCount(this.updateCount);
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.signature) {
                builder.setSignature(this.signature.toProto());
            }
            if (null != this.firstFrame) {
                builder.setFirstFrame(this.firstFrame.toProto());
            }
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            return builder.build();
        }

        public int hashCode() {
            int result = 1;
            result = ResultSetResponse.p(result, this.connectionId);
            result = ResultSetResponse.p(result, this.firstFrame);
            result = ResultSetResponse.p(result, this.ownStatement);
            result = ResultSetResponse.p(result, this.signature);
            result = ResultSetResponse.p(result, this.statementId);
            result = ResultSetResponse.p(result, this.updateCount);
            result = ResultSetResponse.p(result, this.rpcMetadata);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof ResultSetResponse && this.statementId == ((ResultSetResponse)o).statementId && this.ownStatement == ((ResultSetResponse)o).ownStatement && this.updateCount == ((ResultSetResponse)o).updateCount && Objects.equals(this.connectionId, ((ResultSetResponse)o).connectionId) && Objects.equals(this.firstFrame, ((ResultSetResponse)o).firstFrame) && Objects.equals(this.signature, ((ResultSetResponse)o).signature) && Objects.equals(this.rpcMetadata, ((ResultSetResponse)o).rpcMetadata);
        }
    }

    public static class TypeInfoRequest
    extends Request {
        private static final Descriptors.FieldDescriptor CONNECTION_ID_DESCRIPTOR = Requests.TypeInfoRequest.getDescriptor().findFieldByNumber(1);
        public final String connectionId;

        public TypeInfoRequest() {
            this.connectionId = null;
        }

        @JsonCreator
        public TypeInfoRequest(@JsonProperty(value="connectionId") String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        ResultSetResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        TypeInfoRequest deserialize(Message genericMsg) {
            Requests.TypeInfoRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.TypeInfoRequest.class);
            String connectionId = null;
            if (msg.hasField(CONNECTION_ID_DESCRIPTOR)) {
                connectionId = msg.getConnectionId();
            }
            return new TypeInfoRequest(connectionId);
        }

        @Override
        Requests.TypeInfoRequest serialize() {
            Requests.TypeInfoRequest.Builder builder = Requests.TypeInfoRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.build();
        }

        public int hashCode() {
            int result = 1;
            result = TypeInfoRequest.p(result, this.connectionId);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof TypeInfoRequest && Objects.equals(this.connectionId, ((TypeInfoRequest)o).connectionId);
        }
    }

    public static class ColumnsRequest
    extends Request {
        private static final Descriptors.FieldDescriptor CONNECTION_ID_DESCRIPTOR = Requests.ColumnsRequest.getDescriptor().findFieldByNumber(5);
        private static final Descriptors.FieldDescriptor CATALOG_DESCRIPTOR = Requests.ColumnsRequest.getDescriptor().findFieldByNumber(1);
        private static final Descriptors.FieldDescriptor SCHEMA_PATTERN_DESCRIPTOR = Requests.ColumnsRequest.getDescriptor().findFieldByNumber(2);
        private static final Descriptors.FieldDescriptor TABLE_NAME_PATTERN_DESCRIPTOR = Requests.ColumnsRequest.getDescriptor().findFieldByNumber(3);
        private static final Descriptors.FieldDescriptor COLUMN_NAME_PATTERN_DESCRIPTOR = Requests.ColumnsRequest.getDescriptor().findFieldByNumber(4);
        public final String connectionId;
        public final String catalog;
        public final String schemaPattern;
        public final String tableNamePattern;
        public final String columnNamePattern;

        ColumnsRequest() {
            this.connectionId = null;
            this.catalog = null;
            this.schemaPattern = null;
            this.tableNamePattern = null;
            this.columnNamePattern = null;
        }

        @JsonCreator
        public ColumnsRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="catalog") String catalog, @JsonProperty(value="schemaPattern") String schemaPattern, @JsonProperty(value="tableNamePattern") String tableNamePattern, @JsonProperty(value="columnNamePattern") String columnNamePattern) {
            this.connectionId = connectionId;
            this.catalog = catalog;
            this.schemaPattern = schemaPattern;
            this.tableNamePattern = tableNamePattern;
            this.columnNamePattern = columnNamePattern;
        }

        @Override
        ResultSetResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        ColumnsRequest deserialize(Message genericMsg) {
            Requests.ColumnsRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.ColumnsRequest.class);
            String connectionId = null;
            if (msg.hasField(CONNECTION_ID_DESCRIPTOR)) {
                connectionId = msg.getConnectionId();
            }
            String catalog = null;
            if (msg.hasField(CATALOG_DESCRIPTOR)) {
                catalog = msg.getCatalog();
            }
            String schemaPattern = null;
            if (msg.hasField(SCHEMA_PATTERN_DESCRIPTOR)) {
                schemaPattern = msg.getSchemaPattern();
            }
            String tableNamePattern = null;
            if (msg.hasField(TABLE_NAME_PATTERN_DESCRIPTOR)) {
                tableNamePattern = msg.getTableNamePattern();
            }
            String columnNamePattern = null;
            if (msg.hasField(COLUMN_NAME_PATTERN_DESCRIPTOR)) {
                columnNamePattern = msg.getColumnNamePattern();
            }
            return new ColumnsRequest(connectionId, catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }

        @Override
        Requests.ColumnsRequest serialize() {
            Requests.ColumnsRequest.Builder builder = Requests.ColumnsRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.catalog) {
                builder.setCatalog(this.catalog);
            }
            if (null != this.schemaPattern) {
                builder.setSchemaPattern(this.schemaPattern);
            }
            if (null != this.tableNamePattern) {
                builder.setTableNamePattern(this.tableNamePattern);
            }
            if (null != this.columnNamePattern) {
                builder.setColumnNamePattern(this.columnNamePattern);
            }
            return builder.build();
        }

        public int hashCode() {
            int result = 1;
            result = ColumnsRequest.p(result, this.connectionId);
            result = ColumnsRequest.p(result, this.catalog);
            result = ColumnsRequest.p(result, this.columnNamePattern);
            result = ColumnsRequest.p(result, this.schemaPattern);
            result = ColumnsRequest.p(result, this.tableNamePattern);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof ColumnsRequest && Objects.equals(this.connectionId, ((ColumnsRequest)o).connectionId) && Objects.equals(this.catalog, ((ColumnsRequest)o).catalog) && Objects.equals(this.schemaPattern, ((ColumnsRequest)o).schemaPattern) && Objects.equals(this.tableNamePattern, ((ColumnsRequest)o).tableNamePattern) && Objects.equals(this.columnNamePattern, ((ColumnsRequest)o).columnNamePattern);
        }
    }

    public static class TableTypesRequest
    extends Request {
        private static final Descriptors.FieldDescriptor CONNECTION_ID_DESCRIPTOR = Requests.TableTypesRequest.getDescriptor().findFieldByNumber(1);
        public final String connectionId;

        public TableTypesRequest() {
            this.connectionId = null;
        }

        @JsonCreator
        public TableTypesRequest(@JsonProperty(value="connectionId") String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        ResultSetResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        TableTypesRequest deserialize(Message genericMsg) {
            Requests.TableTypesRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.TableTypesRequest.class);
            String connectionId = null;
            if (msg.hasField(CONNECTION_ID_DESCRIPTOR)) {
                connectionId = msg.getConnectionId();
            }
            return new TableTypesRequest(connectionId);
        }

        @Override
        Requests.TableTypesRequest serialize() {
            Requests.TableTypesRequest.Builder builder = Requests.TableTypesRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.build();
        }

        public int hashCode() {
            int result = 1;
            result = TableTypesRequest.p(result, this.connectionId);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof TableTypesRequest && Objects.equals(this.connectionId, ((TableTypesRequest)o).connectionId);
        }
    }

    public static class TablesRequest
    extends Request {
        private static final Descriptors.FieldDescriptor CONNECTION_ID_DESCRIPTOR = Requests.TablesRequest.getDescriptor().findFieldByNumber(7);
        private static final Descriptors.FieldDescriptor CATALOG_DESCRIPTOR = Requests.TablesRequest.getDescriptor().findFieldByNumber(1);
        private static final Descriptors.FieldDescriptor SCHEMA_PATTERN_DESCRIPTOR = Requests.TablesRequest.getDescriptor().findFieldByNumber(2);
        private static final Descriptors.FieldDescriptor TABLE_NAME_PATTERN_DESCRIPTOR = Requests.TablesRequest.getDescriptor().findFieldByNumber(3);
        public final String connectionId;
        public final String catalog;
        public final String schemaPattern;
        public final String tableNamePattern;
        public final List<String> typeList;

        TablesRequest() {
            this.connectionId = null;
            this.catalog = null;
            this.schemaPattern = null;
            this.tableNamePattern = null;
            this.typeList = null;
        }

        @JsonCreator
        public TablesRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="catalog") String catalog, @JsonProperty(value="schemaPattern") String schemaPattern, @JsonProperty(value="tableNamePattern") String tableNamePattern, @JsonProperty(value="typeList") List<String> typeList) {
            this.connectionId = connectionId;
            this.catalog = catalog;
            this.schemaPattern = schemaPattern;
            this.tableNamePattern = tableNamePattern;
            this.typeList = typeList;
        }

        @Override
        Response accept(Service service) {
            return service.apply(this);
        }

        @Override
        Request deserialize(Message genericMsg) {
            Requests.TablesRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.TablesRequest.class);
            String connectionId = null;
            if (msg.hasField(CONNECTION_ID_DESCRIPTOR)) {
                connectionId = msg.getConnectionId();
            }
            String catalog = null;
            if (msg.hasField(CATALOG_DESCRIPTOR)) {
                catalog = msg.getCatalog();
            }
            String schemaPattern = null;
            if (msg.hasField(SCHEMA_PATTERN_DESCRIPTOR)) {
                schemaPattern = msg.getSchemaPattern();
            }
            String tableNamePattern = null;
            if (msg.hasField(TABLE_NAME_PATTERN_DESCRIPTOR)) {
                tableNamePattern = msg.getTableNamePattern();
            }
            ProtocolStringList typeList = null;
            if (msg.getHasTypeList()) {
                typeList = msg.getTypeListList();
            }
            return new TablesRequest(connectionId, catalog, schemaPattern, tableNamePattern, typeList);
        }

        @Override
        Requests.TablesRequest serialize() {
            Requests.TablesRequest.Builder builder = Requests.TablesRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.catalog) {
                builder.setCatalog(this.catalog);
            }
            if (null != this.schemaPattern) {
                builder.setSchemaPattern(this.schemaPattern);
            }
            if (null != this.tableNamePattern) {
                builder.setTableNamePattern(this.tableNamePattern);
            }
            if (null != this.typeList) {
                builder.setHasTypeList(true);
                builder.addAllTypeList(this.typeList);
            } else {
                builder.setHasTypeList(false);
            }
            return builder.build();
        }

        public int hashCode() {
            int result = 1;
            result = TablesRequest.p(result, this.connectionId);
            result = TablesRequest.p(result, this.catalog);
            result = TablesRequest.p(result, this.schemaPattern);
            result = TablesRequest.p(result, this.tableNamePattern);
            result = TablesRequest.p(result, this.typeList);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof TablesRequest && Objects.equals(this.connectionId, ((TablesRequest)o).connectionId) && Objects.equals(this.catalog, ((TablesRequest)o).catalog) && Objects.equals(this.schemaPattern, ((TablesRequest)o).schemaPattern) && Objects.equals(this.tableNamePattern, ((TablesRequest)o).tableNamePattern) && Objects.equals(this.typeList, ((TablesRequest)o).typeList);
        }
    }

    public static class SchemasRequest
    extends Request {
        private static final Descriptors.FieldDescriptor CONNECTION_ID_DESCRIPTOR = Requests.SchemasRequest.getDescriptor().findFieldByNumber(3);
        private static final Descriptors.FieldDescriptor CATALOG_DESCRIPTOR = Requests.SchemasRequest.getDescriptor().findFieldByNumber(1);
        private static final Descriptors.FieldDescriptor SCHEMA_PATTERN_DESCRIPTOR = Requests.SchemasRequest.getDescriptor().findFieldByNumber(2);
        public final String connectionId;
        public final String catalog;
        public final String schemaPattern;

        SchemasRequest() {
            this.connectionId = null;
            this.catalog = null;
            this.schemaPattern = null;
        }

        @JsonCreator
        public SchemasRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="catalog") String catalog, @JsonProperty(value="schemaPattern") String schemaPattern) {
            this.connectionId = connectionId;
            this.catalog = catalog;
            this.schemaPattern = schemaPattern;
        }

        @Override
        ResultSetResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        SchemasRequest deserialize(Message genericMsg) {
            Requests.SchemasRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.SchemasRequest.class);
            String connectionId = null;
            if (msg.hasField(CONNECTION_ID_DESCRIPTOR)) {
                connectionId = msg.getConnectionId();
            }
            String catalog = null;
            if (msg.hasField(CATALOG_DESCRIPTOR)) {
                catalog = msg.getCatalog();
            }
            String schemaPattern = null;
            if (msg.hasField(SCHEMA_PATTERN_DESCRIPTOR)) {
                schemaPattern = msg.getSchemaPattern();
            }
            return new SchemasRequest(connectionId, catalog, schemaPattern);
        }

        @Override
        Requests.SchemasRequest serialize() {
            Requests.SchemasRequest.Builder builder = Requests.SchemasRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.catalog) {
                builder.setCatalog(this.catalog);
            }
            if (null != this.schemaPattern) {
                builder.setSchemaPattern(this.schemaPattern);
            }
            return builder.build();
        }

        public int hashCode() {
            int result = 1;
            result = SchemasRequest.p(result, this.connectionId);
            result = SchemasRequest.p(result, this.catalog);
            result = SchemasRequest.p(result, this.schemaPattern);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof SchemasRequest && Objects.equals(this.connectionId, ((SchemasRequest)o).connectionId) && Objects.equals(this.catalog, ((SchemasRequest)o).catalog) && Objects.equals(this.schemaPattern, ((SchemasRequest)o).schemaPattern);
        }
    }

    public static class DatabasePropertyRequest
    extends Request {
        private static final Descriptors.FieldDescriptor CONNECTION_ID_DESCRIPTOR = Requests.DatabasePropertyRequest.getDescriptor().findFieldByNumber(1);
        public final String connectionId;

        public DatabasePropertyRequest() {
            this.connectionId = null;
        }

        @JsonCreator
        public DatabasePropertyRequest(@JsonProperty(value="connectionId") String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        DatabasePropertyResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        DatabasePropertyRequest deserialize(Message genericMsg) {
            Requests.DatabasePropertyRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.DatabasePropertyRequest.class);
            String connectionId = null;
            if (msg.hasField(CONNECTION_ID_DESCRIPTOR)) {
                connectionId = msg.getConnectionId();
            }
            return new DatabasePropertyRequest(connectionId);
        }

        @Override
        Requests.DatabasePropertyRequest serialize() {
            Requests.DatabasePropertyRequest.Builder builder = Requests.DatabasePropertyRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.build();
        }

        public int hashCode() {
            int result = 1;
            result = DatabasePropertyRequest.p(result, this.connectionId);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof DatabasePropertyRequest && Objects.equals(this.connectionId, ((DatabasePropertyRequest)o).connectionId);
        }
    }

    public static class CatalogsRequest
    extends Request {
        private static final Descriptors.FieldDescriptor CONNECTION_ID_DESCRIPTOR = Requests.CatalogsRequest.getDescriptor().findFieldByNumber(1);
        public final String connectionId;

        public CatalogsRequest() {
            this.connectionId = null;
        }

        @JsonCreator
        public CatalogsRequest(@JsonProperty(value="connectionId") String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        ResultSetResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        CatalogsRequest deserialize(Message genericMsg) {
            Requests.CatalogsRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.CatalogsRequest.class);
            String connectionId = null;
            if (msg.hasField(CONNECTION_ID_DESCRIPTOR)) {
                connectionId = msg.getConnectionId();
            }
            return new CatalogsRequest(connectionId);
        }

        @Override
        Requests.CatalogsRequest serialize() {
            Requests.CatalogsRequest.Builder builder = Requests.CatalogsRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.build();
        }

        public int hashCode() {
            int result = 1;
            result = CatalogsRequest.p(result, this.connectionId);
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof CatalogsRequest && Objects.equals(this.connectionId, ((CatalogsRequest)o).connectionId);
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="response")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=OpenConnectionResponse.class, name="openConnection"), @JsonSubTypes.Type(value=ResultSetResponse.class, name="resultSet"), @JsonSubTypes.Type(value=PrepareResponse.class, name="prepare"), @JsonSubTypes.Type(value=FetchResponse.class, name="fetch"), @JsonSubTypes.Type(value=CreateStatementResponse.class, name="createStatement"), @JsonSubTypes.Type(value=CloseStatementResponse.class, name="closeStatement"), @JsonSubTypes.Type(value=CloseConnectionResponse.class, name="closeConnection"), @JsonSubTypes.Type(value=ConnectionSyncResponse.class, name="connectionSync"), @JsonSubTypes.Type(value=DatabasePropertyResponse.class, name="databaseProperties"), @JsonSubTypes.Type(value=ExecuteResponse.class, name="executeResults"), @JsonSubTypes.Type(value=ErrorResponse.class, name="error"), @JsonSubTypes.Type(value=SyncResultsResponse.class, name="syncResults"), @JsonSubTypes.Type(value=RpcMetadataResponse.class, name="rpcMetadata"), @JsonSubTypes.Type(value=CommitResponse.class, name="commit"), @JsonSubTypes.Type(value=RollbackResponse.class, name="rollback"), @JsonSubTypes.Type(value=ExecuteBatchResponse.class, name="executeBatch")})
    public static abstract class Response
    extends Base {
        abstract Response deserialize(Message var1);

        abstract Message serialize();
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="request", defaultImpl=SchemasRequest.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=CatalogsRequest.class, name="getCatalogs"), @JsonSubTypes.Type(value=SchemasRequest.class, name="getSchemas"), @JsonSubTypes.Type(value=TablesRequest.class, name="getTables"), @JsonSubTypes.Type(value=TableTypesRequest.class, name="getTableTypes"), @JsonSubTypes.Type(value=TypeInfoRequest.class, name="getTypeInfo"), @JsonSubTypes.Type(value=ColumnsRequest.class, name="getColumns"), @JsonSubTypes.Type(value=ExecuteRequest.class, name="execute"), @JsonSubTypes.Type(value=PrepareRequest.class, name="prepare"), @JsonSubTypes.Type(value=PrepareAndExecuteRequest.class, name="prepareAndExecute"), @JsonSubTypes.Type(value=FetchRequest.class, name="fetch"), @JsonSubTypes.Type(value=CreateStatementRequest.class, name="createStatement"), @JsonSubTypes.Type(value=CloseStatementRequest.class, name="closeStatement"), @JsonSubTypes.Type(value=OpenConnectionRequest.class, name="openConnection"), @JsonSubTypes.Type(value=CloseConnectionRequest.class, name="closeConnection"), @JsonSubTypes.Type(value=ConnectionSyncRequest.class, name="connectionSync"), @JsonSubTypes.Type(value=DatabasePropertyRequest.class, name="databaseProperties"), @JsonSubTypes.Type(value=SyncResultsRequest.class, name="syncResults"), @JsonSubTypes.Type(value=CommitRequest.class, name="commit"), @JsonSubTypes.Type(value=RollbackRequest.class, name="rollback"), @JsonSubTypes.Type(value=PrepareAndExecuteBatchRequest.class, name="prepareAndExecuteBatch"), @JsonSubTypes.Type(value=ExecuteBatchRequest.class, name="executeBatch")})
    public static abstract class Request
    extends Base {
        abstract Response accept(Service var1);

        abstract Request deserialize(Message var1);

        abstract Message serialize();
    }

    public static abstract class Base {
        static final int PRIME = 31;

        protected static int p(int result, Object o) {
            return 31 * result + (o == null ? 0 : o.hashCode());
        }

        protected static int p(int result, boolean v) {
            return 31 * result + (v ? 1231 : 1237);
        }

        protected static int p(int result, int v) {
            return 31 * result + v;
        }

        protected static int p(int result, long v) {
            return 31 * result + (int)(v ^ v >>> 32);
        }
    }

    public static interface Factory {
        public Service create(AvaticaConnection var1);
    }
}

