/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.UdfImplReflectiveFunctionBase;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.adapter.enumerable.CallImplementor;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.adapter.enumerable.ReflectiveCallNotNullImplementor;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.avatica.util.ByteString;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.function.SemiStrict;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.function.Strict;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.tree.Expression;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.tree.Expressions;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.Function;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.ImplementableFunction;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.ScalarFunction;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.Static;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMultimap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ScalarFunctionImpl
extends UdfImplReflectiveFunctionBase
implements ScalarFunction,
ImplementableFunction {
    private final @UnknownKeyFor @NonNull @Initialized CallImplementor implementor;
    private final @UnknownKeyFor @NonNull @Initialized String jarPath;

    protected ScalarFunctionImpl(@UnknownKeyFor @NonNull @Initialized Method method, @UnknownKeyFor @NonNull @Initialized CallImplementor implementor, @UnknownKeyFor @NonNull @Initialized String jarPath) {
        super(method);
        this.implementor = implementor;
        this.jarPath = jarPath;
    }

    protected ScalarFunctionImpl(@UnknownKeyFor @NonNull @Initialized Method method, @UnknownKeyFor @NonNull @Initialized CallImplementor implementor) {
        this(method, implementor, "");
    }

    public @UnknownKeyFor @NonNull @Initialized String getJarPath() {
        return this.jarPath;
    }

    public static @UnknownKeyFor @NonNull @Initialized ImmutableMultimap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Function> createAll(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Method method : clazz.getMethods()) {
            if (method.getDeclaringClass() == Object.class || !Modifier.isStatic(method.getModifiers()) && !ScalarFunctionImpl.classHasPublicZeroArgsConstructor(clazz)) continue;
            Function function = ScalarFunctionImpl.create(method);
            builder.put((Object)method.getName(), (Object)function);
        }
        return builder.build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Function create(@UnknownKeyFor @NonNull @Initialized Method method) {
        return ScalarFunctionImpl.create(method, "");
    }

    public static @UnknownKeyFor @NonNull @Initialized Function create(@UnknownKeyFor @NonNull @Initialized Method method, @UnknownKeyFor @NonNull @Initialized String jarPath) {
        ScalarFunctionImpl.validateMethod(method);
        CallImplementor implementor = ScalarFunctionImpl.createImplementor(method);
        return new ScalarFunctionImpl(method, implementor, jarPath);
    }

    protected static void validateMethod(@UnknownKeyFor @NonNull @Initialized Method method) {
        Class<?> clazz;
        if (!Modifier.isStatic(method.getModifiers()) && !ScalarFunctionImpl.classHasPublicZeroArgsConstructor(clazz = method.getDeclaringClass())) {
            throw (RuntimeException)Static.RESOURCE.requireDefaultConstructor(clazz.getName()).ex();
        }
        if (method.getExceptionTypes().length != 0) {
            throw new RuntimeException(method.getName() + " must not throw checked exception");
        }
    }

    public @UnknownKeyFor @NonNull @Initialized RelDataType getReturnType(@UnknownKeyFor @NonNull @Initialized RelDataTypeFactory typeFactory) {
        return CalciteUtils.sqlTypeWithAutoCast(typeFactory, this.method.getGenericReturnType());
    }

    public @UnknownKeyFor @NonNull @Initialized CallImplementor getImplementor() {
        return this.implementor;
    }

    protected static @UnknownKeyFor @NonNull @Initialized CallImplementor createImplementor(@UnknownKeyFor @NonNull @Initialized Method method) {
        NullPolicy nullPolicy = ScalarFunctionImpl.getNullPolicy(method);
        return RexImpTable.createImplementor((NotNullImplementor)new ScalarReflectiveCallNotNullImplementor(method), (NullPolicy)nullPolicy, (boolean)false);
    }

    private static @UnknownKeyFor @NonNull @Initialized NullPolicy getNullPolicy(@UnknownKeyFor @NonNull @Initialized Method m) {
        if (m.getAnnotation(Strict.class) != null) {
            return NullPolicy.STRICT;
        }
        if (m.getAnnotation(SemiStrict.class) != null) {
            return NullPolicy.SEMI_STRICT;
        }
        if (m.getDeclaringClass().getAnnotation(Strict.class) != null) {
            return NullPolicy.STRICT;
        }
        if (m.getDeclaringClass().getAnnotation(SemiStrict.class) != null) {
            return NullPolicy.SEMI_STRICT;
        }
        return NullPolicy.NONE;
    }

    public @UnknownKeyFor @NonNull @Initialized RelDataType getReturnType(@UnknownKeyFor @NonNull @Initialized RelDataTypeFactory typeFactory, @UnknownKeyFor @NonNull @Initialized SqlOperatorBinding opBinding) {
        RelDataType returnType = this.getReturnType(typeFactory);
        switch (ScalarFunctionImpl.getNullPolicy(this.method)) {
            case STRICT: {
                for (RelDataType type : opBinding.collectOperandTypes()) {
                    if (!type.isNullable()) continue;
                    return typeFactory.createTypeWithNullability(returnType, true);
                }
                break;
            }
            case SEMI_STRICT: {
                return typeFactory.createTypeWithNullability(returnType, true);
            }
        }
        return returnType;
    }

    static @UnknownKeyFor @NonNull @Initialized boolean classHasPublicZeroArgsConstructor(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != 0 || !Modifier.isPublic(constructor.getModifiers())) continue;
            return true;
        }
        return false;
    }

    private static class ScalarReflectiveCallNotNullImplementor
    extends ReflectiveCallNotNullImplementor {
        ScalarReflectiveCallNotNullImplementor(@UnknownKeyFor @NonNull @Initialized Method method) {
            super(method);
        }

        private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Expression> translate(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Type> types, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Expression> expressions) {
            Preconditions.checkArgument((types.size() >= expressions.size() ? 1 : 0) != 0, (Object)"types.size() < expressions.size()");
            ArrayList<Expression> translated = new ArrayList<Expression>();
            for (int i = 0; i < expressions.size(); ++i) {
                translated.add(ScalarReflectiveCallNotNullImplementor.translate(types.get(i), expressions.get(i)));
            }
            return translated;
        }

        private static @UnknownKeyFor @NonNull @Initialized Expression translate(@UnknownKeyFor @NonNull @Initialized Type type, @UnknownKeyFor @NonNull @Initialized Expression expression) {
            if (type == byte[].class && expression.type == ByteString.class) {
                return Expressions.condition((Expression)Expressions.equal((Expression)expression, (Expression)Expressions.constant(null)), (Expression)Expressions.constant(null), (Expression)Expressions.call((Expression)expression, (String)"getBytes", (Expression[])new Expression[0]));
            }
            return expression;
        }

        public @UnknownKeyFor @NonNull @Initialized Expression implement(@UnknownKeyFor @NonNull @Initialized RexToLixTranslator translator, @UnknownKeyFor @NonNull @Initialized RexCall call, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Expression> translatedOperands) {
            List<Expression> translated = ScalarReflectiveCallNotNullImplementor.translate(Arrays.asList(this.method.getParameterTypes()), translatedOperands);
            return super.implement(translator, call, translated);
        }
    }
}

