/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.bigquery;

import java.util.List;
import java.util.Map;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.avatica.util.Casing;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.config.NullCollation;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlAbstractDateTimeLiteral;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlCall;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlDialect;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlTimestampLiteral;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlWriter;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.dialect.BigQuerySqlDialect;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamBigQuerySqlDialect
extends BigQuerySqlDialect {
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.BIG_QUERY).withIdentifierQuoteString("`").withNullCollation(NullCollation.LOW).withUnquotedCasing(Casing.UNCHANGED).withQuotedCasing(Casing.UNCHANGED).withCaseSensitive(false);
    public static final @UnknownKeyFor @NonNull @Initialized SqlDialect DEFAULT = new BeamBigQuerySqlDialect(DEFAULT_CONTEXT);
    private static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> FUNCTIONS_USING_INTERVAL = ImmutableList.of((Object)"date_add", (Object)"date_sub", (Object)"datetime_add", (Object)"datetime_sub", (Object)"time_add", (Object)"time_sub", (Object)"timestamp_add", (Object)"timestamp_sub");
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> EXTRACT_FUNCTIONS = ImmutableMap.builder().put((Object)"$extract", (Object)"").put((Object)"$extract_date", (Object)"DATE").put((Object)"$extract_time", (Object)"TIME").put((Object)"$extract_datetime", (Object)"DATETIME").build();
    public static final @UnknownKeyFor @NonNull @Initialized String DOUBLE_POSITIVE_INF_WRAPPER = "double_positive_inf";
    public static final @UnknownKeyFor @NonNull @Initialized String DOUBLE_NEGATIVE_INF_WRAPPER = "double_negative_inf";
    public static final @UnknownKeyFor @NonNull @Initialized String DOUBLE_NAN_WRAPPER = "double_nan";
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> DOUBLE_LITERAL_WRAPPERS = ImmutableMap.builder().put((Object)"double_positive_inf", (Object)"CAST('+inf' AS FLOAT64)").put((Object)"double_negative_inf", (Object)"CAST('-inf' AS FLOAT64)").put((Object)"double_nan", (Object)"CAST('NaN' AS FLOAT64)").build();
    public static final @UnknownKeyFor @NonNull @Initialized String NUMERIC_LITERAL_WRAPPER = "numeric_literal";
    public static final @UnknownKeyFor @NonNull @Initialized String IN_ARRAY_OPERATOR = "$in_array";

    public BeamBigQuerySqlDialect(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized SqlDialect.Context context) {
        super(context);
    }

    public @UnknownKeyFor @NonNull @Initialized String quoteIdentifier(@UnknownKeyFor @NonNull @Initialized String val) {
        return this.quoteIdentifier(new StringBuilder(), val).toString();
    }

    public void unparseCall(@UnknownKeyFor @NonNull @Initialized SqlWriter writer, @UnknownKeyFor @NonNull @Initialized SqlCall call, @UnknownKeyFor @NonNull @Initialized int leftPrec, @UnknownKeyFor @NonNull @Initialized int rightPrec) {
        switch (call.getKind()) {
            case ROW: {
                SqlWriter.Frame structFrame = writer.startFunCall("STRUCT");
                for (SqlNode operand : call.getOperandList()) {
                    writer.sep(",");
                    operand.unparse(writer, leftPrec, rightPrec);
                }
                writer.endFunCall(structFrame);
                break;
            }
            case OTHER_FUNCTION: {
                String funName = call.getOperator().getName();
                if (DOUBLE_LITERAL_WRAPPERS.containsKey(funName)) {
                    this.unparseDoubleLiteralWrapperFunction(writer, funName);
                    break;
                }
                if (NUMERIC_LITERAL_WRAPPER.equals(funName)) {
                    this.unparseNumericLiteralWrapperFunction(writer, call, leftPrec, rightPrec);
                    break;
                }
                if (FUNCTIONS_USING_INTERVAL.contains(funName)) {
                    this.unparseFunctionsUsingInterval(writer, call, leftPrec, rightPrec);
                    break;
                }
                if (EXTRACT_FUNCTIONS.containsKey(funName)) {
                    this.unparseExtractFunctions(writer, call, leftPrec, rightPrec);
                    break;
                }
                if (IN_ARRAY_OPERATOR.equals(funName)) {
                    this.unparseInArrayOperator(writer, call, leftPrec, rightPrec);
                    break;
                }
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }

    public void unparseSqlIntervalLiteral(@UnknownKeyFor @NonNull @Initialized SqlWriter writer, @UnknownKeyFor @NonNull @Initialized SqlIntervalLiteral literal, @UnknownKeyFor @NonNull @Initialized int leftPrec, @UnknownKeyFor @NonNull @Initialized int rightPrec) {
        Long intervalValueInLong;
        SqlIntervalLiteral.IntervalValue interval = (SqlIntervalLiteral.IntervalValue)literal.getValue();
        writer.keyword("INTERVAL");
        if (interval.getSign() == -1) {
            writer.print("-");
        }
        try {
            intervalValueInLong = Long.parseLong(literal.getValue().toString());
        }
        catch (NumberFormatException e) {
            throw new UnsupportedOperationException("Only INT64 is supported as the interval value for BigQuery.");
        }
        writer.literal(intervalValueInLong.toString());
        this.unparseSqlIntervalQualifier(writer, interval.getIntervalQualifier(), RelDataTypeSystem.DEFAULT);
    }

    private void unparseDoubleLiteralWrapperFunction(@UnknownKeyFor @NonNull @Initialized SqlWriter writer, @UnknownKeyFor @NonNull @Initialized String funName) {
        writer.literal(DOUBLE_LITERAL_WRAPPERS.get(funName));
    }

    private void unparseNumericLiteralWrapperFunction(@UnknownKeyFor @NonNull @Initialized SqlWriter writer, @UnknownKeyFor @NonNull @Initialized SqlCall call, @UnknownKeyFor @NonNull @Initialized int leftPrec, @UnknownKeyFor @NonNull @Initialized int rightPrec) {
        writer.literal("NUMERIC '");
        call.operand(0).unparse(writer, leftPrec, rightPrec);
        writer.literal("'");
    }

    private void unparseFunctionsUsingInterval(@UnknownKeyFor @NonNull @Initialized SqlWriter writer, @UnknownKeyFor @NonNull @Initialized SqlCall call, @UnknownKeyFor @NonNull @Initialized int leftPrec, @UnknownKeyFor @NonNull @Initialized int rightPrec) {
        int operandCount = call.operandCount();
        if (operandCount == 2) {
            super.unparseCall(writer, call, leftPrec, rightPrec);
        } else if (operandCount == 3) {
            SqlWriter.Frame frame = writer.startFunCall(call.getOperator().getName());
            call.operand(0).unparse(writer, leftPrec, rightPrec);
            writer.literal(",");
            writer.literal("INTERVAL");
            call.operand(1).unparse(writer, leftPrec, rightPrec);
            call.operand(2).unparse(writer, leftPrec, rightPrec);
            writer.endFunCall(frame);
        } else {
            throw new IllegalArgumentException(String.format("Unable to unparse %s with %d operands.", call.getOperator().getName(), operandCount));
        }
    }

    private void unparseExtractFunctions(@UnknownKeyFor @NonNull @Initialized SqlWriter writer, @UnknownKeyFor @NonNull @Initialized SqlCall call, @UnknownKeyFor @NonNull @Initialized int leftPrec, @UnknownKeyFor @NonNull @Initialized int rightPrec) {
        String funName = call.getOperator().getName();
        int operandCount = call.operandCount();
        SqlNode tz = null;
        SqlWriter.Frame frame = writer.startFunCall("EXTRACT");
        if (!(funName.equals("$extract") || operandCount != 1 && operandCount != 2)) {
            writer.literal(EXTRACT_FUNCTIONS.get(funName));
            if (operandCount == 2) {
                tz = call.operand(1);
            }
        } else if (funName.equals("$extract") && (operandCount == 2 || operandCount == 3)) {
            call.operand(1).unparse(writer, leftPrec, rightPrec);
            if (operandCount == 3) {
                tz = call.operand(2);
            }
        } else {
            throw new IllegalArgumentException(String.format("Unable to unparse %s with %d operands.", funName, operandCount));
        }
        writer.literal("FROM");
        call.operand(0).unparse(writer, leftPrec, rightPrec);
        if (tz != null) {
            writer.literal("AT TIME ZONE");
            tz.unparse(writer, leftPrec, rightPrec);
        }
        writer.endFunCall(frame);
    }

    private void unparseInArrayOperator(@UnknownKeyFor @NonNull @Initialized SqlWriter writer, @UnknownKeyFor @NonNull @Initialized SqlCall call, @UnknownKeyFor @NonNull @Initialized int leftPrec, @UnknownKeyFor @NonNull @Initialized int rightPrec) {
        call.operand(0).unparse(writer, leftPrec, rightPrec);
        writer.literal("IN UNNEST(");
        call.operand(1).unparse(writer, leftPrec, rightPrec);
        writer.literal(")");
    }

    public void unparseDateTimeLiteral(@UnknownKeyFor @NonNull @Initialized SqlWriter writer, @UnknownKeyFor @NonNull @Initialized SqlAbstractDateTimeLiteral literal, @UnknownKeyFor @NonNull @Initialized int leftPrec, @UnknownKeyFor @NonNull @Initialized int rightPrec) {
        if (literal instanceof SqlTimestampLiteral) {
            writer.literal("TIMESTAMP '" + literal.toFormattedString() + "Z'");
        } else {
            super.unparseDateTimeLiteral(writer, literal, leftPrec, rightPrec);
        }
    }
}

