/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.planner;

import java.util.Objects;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCost;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCostFactory;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class BeamCostModel
implements RelOptCost {
    private static final @UnknownKeyFor @NonNull @Initialized double RATE_IMPORTANCE = 3600.0;
    static final @UnknownKeyFor @NonNull @Initialized BeamCostModel INFINITY = new BeamCostModel(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY){

        @Override
        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "{inf}";
        }
    };
    static final @UnknownKeyFor @NonNull @Initialized BeamCostModel HUGE = new BeamCostModel(Double.MAX_VALUE, Double.MAX_VALUE){

        @Override
        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "{huge}";
        }
    };
    static final @UnknownKeyFor @NonNull @Initialized BeamCostModel ZERO = new BeamCostModel(0.0, 0.0){

        @Override
        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "{0}";
        }
    };
    static final @UnknownKeyFor @NonNull @Initialized BeamCostModel TINY = new BeamCostModel(1.0, 0.001){

        @Override
        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "{tiny}";
        }
    };
    public static final @UnknownKeyFor @NonNull @Initialized Factory FACTORY = new Factory();
    final @UnknownKeyFor @NonNull @Initialized double cpu;
    final @UnknownKeyFor @NonNull @Initialized double cpuRate;

    BeamCostModel(@UnknownKeyFor @NonNull @Initialized double cpu, @UnknownKeyFor @NonNull @Initialized double cpuRate) {
        this.cpu = Math.max(cpu, 0.0);
        this.cpuRate = Math.max(cpuRate, 0.0);
    }

    public @UnknownKeyFor @NonNull @Initialized double getCpu() {
        return this.cpu;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isInfinite() {
        return this.equals(INFINITY) || this.cpu == Double.POSITIVE_INFINITY || this.cpuRate == Double.POSITIVE_INFINITY;
    }

    public @UnknownKeyFor @NonNull @Initialized double getIo() {
        return 0.0;
    }

    public @UnknownKeyFor @NonNull @Initialized double getCpuRate() {
        return this.cpuRate;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isLe(@UnknownKeyFor @NonNull @Initialized RelOptCost other) {
        BeamCostModel that = (BeamCostModel)other;
        if (this.isInfinite() || that.isInfinite()) {
            return that.isInfinite();
        }
        return BeamCostModel.getCostCombination(this) <= BeamCostModel.getCostCombination(that);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isLt(@UnknownKeyFor @NonNull @Initialized RelOptCost other) {
        BeamCostModel that = (BeamCostModel)other;
        if (that.isInfinite() || this.isInfinite()) {
            return !this.isInfinite();
        }
        return BeamCostModel.getCostCombination(this) < BeamCostModel.getCostCombination(that);
    }

    private static @UnknownKeyFor @NonNull @Initialized double getCostCombination(@UnknownKeyFor @NonNull @Initialized BeamCostModel cost) {
        return cost.cpu + cost.cpuRate * 3600.0;
    }

    public @UnknownKeyFor @NonNull @Initialized double getRows() {
        return 0.0;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.cpu, this.cpuRate);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean equals(@UnknownKeyFor @NonNull @Initialized RelOptCost other) {
        return other instanceof BeamCostModel && this.cpu == ((BeamCostModel)other).cpu && this.cpuRate == ((BeamCostModel)other).cpuRate;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        if (obj instanceof BeamCostModel) {
            return this.equals((BeamCostModel)obj);
        }
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isEqWithEpsilon(@UnknownKeyFor @NonNull @Initialized RelOptCost other) {
        if (!(other instanceof BeamCostModel)) {
            return false;
        }
        BeamCostModel that = (BeamCostModel)other;
        return Math.abs(this.cpu - that.cpu) < 1.0E-5 && Math.abs(this.cpuRate - that.cpuRate) < 1.0E-5;
    }

    public @UnknownKeyFor @NonNull @Initialized BeamCostModel minus(@UnknownKeyFor @NonNull @Initialized RelOptCost other) {
        if (this.equals(INFINITY)) {
            return this;
        }
        BeamCostModel that = (BeamCostModel)other;
        return new BeamCostModel(this.cpu - that.cpu, this.cpuRate - that.cpuRate);
    }

    public @UnknownKeyFor @NonNull @Initialized BeamCostModel multiplyBy(@UnknownKeyFor @NonNull @Initialized double factor) {
        if (this.equals(INFINITY)) {
            return this;
        }
        return new BeamCostModel(this.cpu * factor, this.cpuRate * factor);
    }

    public @UnknownKeyFor @NonNull @Initialized double divideBy(@UnknownKeyFor @NonNull @Initialized RelOptCost cost) {
        BeamCostModel that = (BeamCostModel)cost;
        if (BeamCostModel.getCostCombination(this) != 0.0 && !Double.isInfinite(BeamCostModel.getCostCombination(this)) && BeamCostModel.getCostCombination(that) != 0.0 && !Double.isInfinite(BeamCostModel.getCostCombination(that))) {
            return BeamCostModel.getCostCombination(this) / BeamCostModel.getCostCombination(that);
        }
        return 1.0;
    }

    public @UnknownKeyFor @NonNull @Initialized BeamCostModel plus(@UnknownKeyFor @NonNull @Initialized RelOptCost other) {
        BeamCostModel that = (BeamCostModel)other;
        if (this.equals(INFINITY) || that.equals(INFINITY)) {
            return INFINITY;
        }
        return new BeamCostModel(this.cpu + that.cpu, this.cpuRate + that.cpuRate);
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "{" + this.cpu + " cpu, " + this.cpuRate + " cpuRate }";
    }

    public static @UnknownKeyFor @NonNull @Initialized BeamCostModel convertRelOptCost(@UnknownKeyFor @NonNull @Initialized RelOptCost ic) {
        BeamCostModel inputCost = ic instanceof BeamCostModel ? (BeamCostModel)ic : FACTORY.makeCost(ic.getRows(), ic.getCpu(), ic.getIo());
        return inputCost;
    }

    public static class Factory
    implements RelOptCostFactory {
        public @UnknownKeyFor @NonNull @Initialized BeamCostModel makeCost(@UnknownKeyFor @NonNull @Initialized double dRows, @UnknownKeyFor @NonNull @Initialized double dCpu, @UnknownKeyFor @NonNull @Initialized double dIo) {
            return INFINITY;
        }

        public @UnknownKeyFor @NonNull @Initialized BeamCostModel makeCost(@UnknownKeyFor @NonNull @Initialized double dCpu, @UnknownKeyFor @NonNull @Initialized double dCpuRate) {
            return new BeamCostModel(dCpu, dCpuRate);
        }

        public @UnknownKeyFor @NonNull @Initialized BeamCostModel makeHugeCost() {
            return HUGE;
        }

        public @UnknownKeyFor @NonNull @Initialized BeamCostModel makeInfiniteCost() {
            return INFINITY;
        }

        public @UnknownKeyFor @NonNull @Initialized BeamCostModel makeTinyCost() {
            return TINY;
        }

        public @UnknownKeyFor @NonNull @Initialized BeamCostModel makeZeroCost() {
            return ZERO;
        }
    }
}

