/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform.agg;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.AutoValue_CovarianceAccumulator;
import org.apache.beam.sdk.extensions.sql.impl.transform.agg.CovarianceFn;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
abstract class CovarianceAccumulator
implements Serializable {
    static final @UnknownKeyFor @NonNull @Initialized CovarianceAccumulator EMPTY = CovarianceAccumulator.newCovarianceAccumulator(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);

    CovarianceAccumulator() {
    }

    abstract @UnknownKeyFor @NonNull @Initialized BigDecimal covariance();

    abstract @UnknownKeyFor @NonNull @Initialized BigDecimal count();

    abstract @UnknownKeyFor @NonNull @Initialized BigDecimal xavg();

    abstract @UnknownKeyFor @NonNull @Initialized BigDecimal yavg();

    static @UnknownKeyFor @NonNull @Initialized CovarianceAccumulator newCovarianceAccumulator(@UnknownKeyFor @NonNull @Initialized BigDecimal covariance, @UnknownKeyFor @NonNull @Initialized BigDecimal count, @UnknownKeyFor @NonNull @Initialized BigDecimal xavg, @UnknownKeyFor @NonNull @Initialized BigDecimal yavg) {
        return new AutoValue_CovarianceAccumulator(covariance, count, xavg, yavg);
    }

    static @UnknownKeyFor @NonNull @Initialized CovarianceAccumulator ofZeroElements() {
        return EMPTY;
    }

    static @UnknownKeyFor @NonNull @Initialized CovarianceAccumulator ofSingleElement(@UnknownKeyFor @NonNull @Initialized BigDecimal inputElementX, @UnknownKeyFor @NonNull @Initialized BigDecimal inputElementY) {
        return CovarianceAccumulator.newCovarianceAccumulator(BigDecimal.ZERO, BigDecimal.ONE, inputElementX, inputElementY);
    }

    @UnknownKeyFor @NonNull @Initialized CovarianceAccumulator combineWith(@UnknownKeyFor @NonNull @Initialized CovarianceAccumulator otherCovariance) {
        if (EMPTY.equals(this)) {
            return otherCovariance;
        }
        if (EMPTY.equals(otherCovariance)) {
            return this;
        }
        BigDecimal increment = this.calculateIncrement(this, otherCovariance);
        BigDecimal combinedCovariance = this.covariance().add(otherCovariance.covariance()).add(increment);
        return CovarianceAccumulator.newCovarianceAccumulator(combinedCovariance, this.count().add(otherCovariance.count()), this.calculateXavg(this, otherCovariance), this.calculateYavg(this, otherCovariance));
    }

    private @UnknownKeyFor @NonNull @Initialized BigDecimal calculateIncrement(@UnknownKeyFor @NonNull @Initialized CovarianceAccumulator covarA, @UnknownKeyFor @NonNull @Initialized CovarianceAccumulator covarB) {
        BigDecimal countA = covarA.count();
        BigDecimal countB = covarB.count();
        BigDecimal totalCount = countA.add(countB);
        BigDecimal avgXA = covarA.xavg();
        BigDecimal avgYA = covarA.yavg();
        BigDecimal avgXB = covarB.xavg();
        BigDecimal avgYB = covarB.yavg();
        return avgXA.subtract(avgXB).multiply(avgYA.subtract(avgYB)).multiply(countA).multiply(countB).divide(totalCount, CovarianceFn.MATH_CTX);
    }

    private @UnknownKeyFor @NonNull @Initialized BigDecimal calculateXavg(@UnknownKeyFor @NonNull @Initialized CovarianceAccumulator covarA, @UnknownKeyFor @NonNull @Initialized CovarianceAccumulator covarB) {
        BigDecimal countA = covarA.count();
        BigDecimal countB = covarB.count();
        BigDecimal totalCount = countA.add(countB);
        BigDecimal avgXA = covarA.xavg();
        BigDecimal avgXB = covarB.xavg();
        return avgXA.multiply(countA).add(avgXB.multiply(countB)).divide(totalCount, CovarianceFn.MATH_CTX);
    }

    private @UnknownKeyFor @NonNull @Initialized BigDecimal calculateYavg(@UnknownKeyFor @NonNull @Initialized CovarianceAccumulator covarA, @UnknownKeyFor @NonNull @Initialized CovarianceAccumulator covarB) {
        BigDecimal countA = covarA.count();
        BigDecimal countB = covarB.count();
        BigDecimal totalCount = countA.add(countB);
        BigDecimal avgYA = covarA.yavg();
        BigDecimal avgYB = covarB.yavg();
        return avgYA.multiply(countA).add(avgYB.multiply(countB)).divide(totalCount, CovarianceFn.MATH_CTX);
    }
}

