/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.text;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.BeamTextCSVTableIOReader;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.BeamTextCSVTableIOWriter;
import org.apache.beam.sdk.extensions.sql.meta.provider.text.BeamTextTable;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;
import org.apache.commons.csv.CSVFormat;

public class BeamTextCSVTable
extends BeamTextTable {
    private String filePattern;
    private CSVFormat csvFormat;

    public BeamTextCSVTable(Schema beamSchema, String filePattern) {
        this(beamSchema, filePattern, CSVFormat.DEFAULT);
    }

    public BeamTextCSVTable(Schema schema, String filePattern, CSVFormat csvFormat) {
        super(schema, filePattern);
        this.filePattern = filePattern;
        this.csvFormat = csvFormat;
    }

    @Override
    public PCollection<Row> buildIOReader(Pipeline pipeline) {
        return (PCollection)((PCollection)PBegin.in((Pipeline)pipeline).apply("decodeRecord", (PTransform)TextIO.read().from(this.filePattern))).apply("parseCSVLine", (PTransform)new BeamTextCSVTableIOReader(this.schema, this.filePattern, this.csvFormat));
    }

    @Override
    public PTransform<? super PCollection<Row>, POutput> buildIOWriter() {
        return new BeamTextCSVTableIOWriter(this.schema, this.filePattern, this.csvFormat);
    }

    public CSVFormat getCsvFormat() {
        return this.csvFormat;
    }

    public String getFilePattern() {
        return this.filePattern;
    }
}

