/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.meta.provider.kafka;

import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamTableUtils;
import org.apache.beam.sdk.extensions.sql.meta.provider.kafka.BeamKafkaTable;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.commons.csv.CSVFormat;

public class BeamKafkaCSVTable
extends BeamKafkaTable {
    private CSVFormat csvFormat;

    public BeamKafkaCSVTable(Schema beamSchema, String bootstrapServers, List<String> topics) {
        this(beamSchema, bootstrapServers, topics, CSVFormat.DEFAULT);
    }

    public BeamKafkaCSVTable(Schema beamSchema, String bootstrapServers, List<String> topics, CSVFormat format) {
        super(beamSchema, bootstrapServers, topics);
        this.csvFormat = format;
    }

    @Override
    public PTransform<PCollection<KV<byte[], byte[]>>, PCollection<Row>> getPTransformForInput() {
        return new CsvRecorderDecoder(this.schema, this.csvFormat);
    }

    @Override
    public PTransform<PCollection<Row>, PCollection<KV<byte[], byte[]>>> getPTransformForOutput() {
        return new CsvRecorderEncoder(this.schema, this.csvFormat);
    }

    public static class CsvRecorderEncoder
    extends PTransform<PCollection<Row>, PCollection<KV<byte[], byte[]>>> {
        private Schema schema;
        private CSVFormat format;

        public CsvRecorderEncoder(Schema schema, CSVFormat format) {
            this.schema = schema;
            this.format = format;
        }

        public PCollection<KV<byte[], byte[]>> expand(PCollection<Row> input) {
            return (PCollection)input.apply("encodeRecord", (PTransform)ParDo.of((DoFn)new DoFn<Row, KV<byte[], byte[]>>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    Row in = (Row)c.element();
                    c.output((Object)KV.of((Object)new byte[0], (Object)BeamTableUtils.beamRow2CsvLine(in, format).getBytes()));
                }
            }));
        }
    }

    public static class CsvRecorderDecoder
    extends PTransform<PCollection<KV<byte[], byte[]>>, PCollection<Row>> {
        private Schema schema;
        private CSVFormat format;

        public CsvRecorderDecoder(Schema schema, CSVFormat format) {
            this.schema = schema;
            this.format = format;
        }

        public PCollection<Row> expand(PCollection<KV<byte[], byte[]>> input) {
            return (PCollection)input.apply("decodeRecord", (PTransform)ParDo.of((DoFn)new DoFn<KV<byte[], byte[]>, Row>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    String rowInString = new String((byte[])((KV)c.element()).getValue());
                    c.output((Object)BeamTableUtils.csvLine2BeamRow(format, rowInString, schema));
                }
            }));
        }
    }
}

