/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.transform;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableMap;
import org.apache.beam.sdk.extensions.sql.impl.interpreter.BeamSqlExpressionExecutor;
import org.apache.beam.sdk.extensions.sql.impl.schema.BeamTableUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.Row;

public class BeamSqlProjectFn
extends DoFn<Row, Row> {
    private String stepName;
    private BeamSqlExpressionExecutor executor;
    private Schema outputSchema;

    public BeamSqlProjectFn(String stepName, BeamSqlExpressionExecutor executor, Schema outputSchema) {
        this.stepName = stepName;
        this.executor = executor;
        this.outputSchema = outputSchema;
    }

    @DoFn.Setup
    public void setup() {
        this.executor.prepare();
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext c, BoundedWindow window) {
        Row inputRow = (Row)c.element();
        List<Object> rawResultValues = this.executor.execute(inputRow, window, ImmutableMap.of());
        List castResultValues = IntStream.range(0, this.outputSchema.getFieldCount()).mapToObj(i -> this.castField(rawResultValues, i)).collect(Collectors.toList());
        c.output((Object)Row.withSchema((Schema)this.outputSchema).addValues(castResultValues).build());
    }

    private Object castField(List<Object> resultValues, int i) {
        return BeamTableUtils.autoCastField(this.outputSchema.getField(i), resultValues.get(i));
    }

    @DoFn.Teardown
    public void close() {
        this.executor.close();
    }
}

