/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rule;

import java.util.List;
import java.util.Optional;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.Aggregate;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.Project;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.RelFactories;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexCall;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.tools.RelBuilderFactory;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.ImmutableBitSet;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamAggregationRel;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamLogicalConvention;
import org.apache.beam.sdk.extensions.sql.impl.rule.AggregateWindowFactory;
import org.apache.beam.sdk.extensions.sql.impl.rule.AggregateWindowField;

public class BeamAggregationRule
extends RelOptRule {
    public static final BeamAggregationRule INSTANCE = new BeamAggregationRule(Aggregate.class, Project.class, RelFactories.LOGICAL_BUILDER);

    public BeamAggregationRule(Class<? extends Aggregate> aggregateClass, Class<? extends Project> projectClass, RelBuilderFactory relBuilderFactory) {
        super(BeamAggregationRule.operand(aggregateClass, BeamAggregationRule.operand(projectClass, BeamAggregationRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project project;
        Aggregate aggregate = (Aggregate)call.rel(0);
        RelNode x = BeamAggregationRule.updateWindow(call, aggregate, project = (Project)call.rel(1));
        if (x != null) {
            call.transformTo(x);
        }
    }

    private static RelNode updateWindow(RelOptRuleCall call, Aggregate aggregate, Project project) {
        ImmutableBitSet groupByFields = aggregate.getGroupSet();
        List<RexNode> projectMapping = project.getProjects();
        Optional<AggregateWindowField> windowField = Optional.empty();
        for (int groupFieldIndex : groupByFields.asList()) {
            RexNode projNode = projectMapping.get(groupFieldIndex);
            if (!(projNode instanceof RexCall)) continue;
            windowField = AggregateWindowFactory.getWindowFieldAt((RexCall)projNode, groupFieldIndex);
        }
        BeamAggregationRel newAggregator = new BeamAggregationRel(aggregate.getCluster(), aggregate.getTraitSet().replace(BeamLogicalConvention.INSTANCE), BeamAggregationRule.convert(aggregate.getInput(), aggregate.getInput().getTraitSet().replace(BeamLogicalConvention.INSTANCE)), aggregate.indicator, aggregate.getGroupSet(), aggregate.getGroupSets(), aggregate.getAggCallList(), windowField);
        return newAggregator;
    }
}

