/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.rule;

import java.util.List;
import java.util.Optional;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexCall;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlKind;
import org.apache.beam.sdk.extensions.sql.impl.rule.AggregateWindowField;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Sessions;
import org.apache.beam.sdk.transforms.windowing.SlidingWindows;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.Row;
import org.joda.time.Duration;

class AggregateWindowFactory {
    AggregateWindowFactory() {
    }

    static Optional<AggregateWindowField> getWindowFieldAt(RexCall call, int groupField) {
        Optional<WindowFn> windowFnOptional = AggregateWindowFactory.createWindowFn(call.operands, call.op.kind);
        return windowFnOptional.map(windowFn -> AggregateWindowField.builder().setFieldIndex(groupField).setWindowFn((WindowFn<Row, ? extends BoundedWindow>)windowFn).build());
    }

    private static Optional<WindowFn> createWindowFn(List<RexNode> parameters, SqlKind operatorKind) {
        switch (operatorKind) {
            case TUMBLE: {
                FixedWindows fixedWindows = FixedWindows.of((Duration)AggregateWindowFactory.durationParameter(parameters, 1));
                if (parameters.size() == 3) {
                    fixedWindows = fixedWindows.withOffset(AggregateWindowFactory.durationParameter(parameters, 2));
                }
                return Optional.of(fixedWindows);
            }
            case HOP: {
                SlidingWindows slidingWindows = SlidingWindows.of((Duration)AggregateWindowFactory.durationParameter(parameters, 2)).every(AggregateWindowFactory.durationParameter(parameters, 1));
                if (parameters.size() == 4) {
                    slidingWindows = slidingWindows.withOffset(AggregateWindowFactory.durationParameter(parameters, 3));
                }
                return Optional.of(slidingWindows);
            }
            case SESSION: {
                Sessions sessions = Sessions.withGapDuration((Duration)AggregateWindowFactory.durationParameter(parameters, 1));
                if (parameters.size() == 3) {
                    throw new UnsupportedOperationException("Specifying alignment (offset) is not supported for session windows");
                }
                return Optional.of(sessions);
            }
        }
        return Optional.empty();
    }

    private static Duration durationParameter(List<RexNode> parameters, int parameterIndex) {
        return Duration.millis((long)AggregateWindowFactory.intValue(parameters.get(parameterIndex)));
    }

    private static long intValue(RexNode operand) {
        if (operand instanceof RexLiteral) {
            return RexLiteral.intValue(operand);
        }
        throw new IllegalArgumentException(String.format("[%s] is not valid.", operand));
    }
}

